/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.ql.security.authorization.HiveMetastoreAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePolicyProvider;

public class PolicyProviderContainer
implements Iterable<HivePolicyProvider> {
    List<HiveAuthorizer> authorizers = new ArrayList<HiveAuthorizer>();
    List<HiveMetastoreAuthorizationProvider> authorizationProviders = new ArrayList<HiveMetastoreAuthorizationProvider>();

    public void addAuthorizer(HiveAuthorizer authorizer) {
        this.authorizers.add(authorizer);
    }

    public void addAuthorizationProvider(HiveMetastoreAuthorizationProvider authorizationProvider) {
        this.authorizationProviders.add(authorizationProvider);
    }

    public int size() {
        return this.authorizers.size() + this.authorizationProviders.size();
    }

    @Override
    public Iterator<HivePolicyProvider> iterator() {
        return new PolicyIterator();
    }

    class PolicyIterator
    implements Iterator<HivePolicyProvider> {
        int currentAuthorizerPosition = 0;
        int authorizationProviderPosition = 0;

        PolicyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentAuthorizerPosition < PolicyProviderContainer.this.authorizers.size() || this.authorizationProviderPosition < PolicyProviderContainer.this.authorizationProviders.size();
        }

        @Override
        public HivePolicyProvider next() {
            try {
                if (this.currentAuthorizerPosition < PolicyProviderContainer.this.authorizers.size()) {
                    return PolicyProviderContainer.this.authorizers.get(this.currentAuthorizerPosition++).getHivePolicyProvider();
                }
                return PolicyProviderContainer.this.authorizationProviders.get(this.authorizationProviderPosition++).getHivePolicyProvider();
            }
            catch (HiveAuthzPluginException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

