/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Description(name="inline", value="_FUNC_( ARRAY( STRUCT()[,STRUCT()] - explodes and array and struct into a table")
public class GenericUDTFInline
extends GenericUDTF {
    private transient ListObjectInspector li;

    @Override
    public StructObjectInspector initialize(ObjectInspector[] ois) throws UDFArgumentException {
        if (ois.length != 1) {
            throw new UDFArgumentException("UDF tables only one argument");
        }
        if (ois[0].getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException("Top level object must be an array but was " + ois[0].getTypeName());
        }
        this.li = (ListObjectInspector)ois[0];
        ObjectInspector sub = this.li.getListElementObjectInspector();
        if (sub.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new UDFArgumentException("The sub element must be struct, but was " + sub.getTypeName());
        }
        return (StructObjectInspector)sub;
    }

    @Override
    public void process(Object[] os) throws HiveException {
        List<?> list = this.li.getList(os[0]);
        if (list != null && !list.isEmpty()) {
            for (Object row : list.toArray()) {
                this.forward(row);
            }
        }
    }

    @Override
    public void close() throws HiveException {
    }

    public String toString() {
        return "inline";
    }
}

