/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hugegraph.driver.SchemaManager;
import org.apache.hugegraph.structure.SchemaElement;
import org.apache.hugegraph.structure.constant.AggregateType;
import org.apache.hugegraph.structure.constant.Cardinality;
import org.apache.hugegraph.structure.constant.DataType;
import org.apache.hugegraph.structure.constant.HugeType;
import org.apache.hugegraph.structure.constant.WriteType;
import org.apache.hugegraph.structure.schema.SchemaBuilder;
import org.apache.hugegraph.util.E;

public class PropertyKey
extends SchemaElement {
    @JsonProperty(value="data_type")
    private DataType dataType = DataType.TEXT;
    @JsonProperty(value="cardinality")
    private Cardinality cardinality = Cardinality.SINGLE;
    @JsonProperty(value="aggregate_type")
    private AggregateType aggregateType = AggregateType.NONE;
    @JsonProperty(value="write_type")
    private WriteType writeType = WriteType.OLTP;

    @JsonCreator
    public PropertyKey(@JsonProperty(value="name") String name) {
        super(name);
    }

    @Override
    public String type() {
        return HugeType.PROPERTY_KEY.string();
    }

    public DataType dataType() {
        return this.dataType;
    }

    public Cardinality cardinality() {
        return this.cardinality;
    }

    public AggregateType aggregateType() {
        return this.aggregateType;
    }

    public WriteType writeType() {
        return this.writeType;
    }

    @Override
    public String toString() {
        return String.format("{name=%s, cardinality=%s, dataType=%s, aggregateType=%s, properties=%s, writeType=%s}", new Object[]{this.name, this.cardinality, this.dataType, this.aggregateType, this.properties, this.writeType});
    }

    public PropertyKeyV46 switchV46() {
        return new PropertyKeyV46(this);
    }

    public PropertyKeyV58 switchV58() {
        return new PropertyKeyV58(this);
    }

    public static class PropertyKeyV58
    extends PropertyKeyV46 {
        @JsonProperty(value="aggregate_type")
        private AggregateType aggregateType;

        @JsonCreator
        public PropertyKeyV58(@JsonProperty(value="name") String name) {
            super(name);
            this.aggregateType = AggregateType.NONE;
        }

        private PropertyKeyV58(PropertyKey propertyKey) {
            super(propertyKey);
            this.aggregateType = propertyKey.aggregateType;
        }

        public AggregateType aggregateType() {
            return this.aggregateType;
        }

        @Override
        public String toString() {
            return String.format("{name=%s, cardinality=%s, dataType=%s, aggregateType=%s, properties=%s}", new Object[]{this.name, this.cardinality(), this.dataType(), this.aggregateType, this.properties});
        }
    }

    public static class PropertyKeyV46
    extends SchemaElement {
        @JsonProperty(value="data_type")
        private DataType dataType;
        @JsonProperty(value="cardinality")
        private Cardinality cardinality;

        @JsonCreator
        public PropertyKeyV46(@JsonProperty(value="name") String name) {
            super(name);
            this.dataType = DataType.TEXT;
            this.cardinality = Cardinality.SINGLE;
        }

        private PropertyKeyV46(PropertyKey propertyKey) {
            super(propertyKey.name);
            this.dataType = propertyKey.dataType;
            this.cardinality = propertyKey.cardinality;
            this.id = propertyKey.id();
            this.properties = propertyKey.properties();
            this.userdata = propertyKey.userdata();
            this.checkExist = propertyKey.checkExist();
        }

        public DataType dataType() {
            return this.dataType;
        }

        public Cardinality cardinality() {
            return this.cardinality;
        }

        @Override
        public String toString() {
            return String.format("{name=%s, cardinality=%s, dataType=%s, properties=%s}", new Object[]{this.name, this.cardinality, this.dataType, this.properties});
        }

        @Override
        public String type() {
            return HugeType.PROPERTY_KEY.string();
        }
    }

    public static class PropertyKeyWithTask {
        @JsonProperty(value="property_key")
        private PropertyKey propertyKey;
        @JsonProperty(value="task_id")
        private long taskId;

        @JsonCreator
        public PropertyKeyWithTask(@JsonProperty(value="property_key") PropertyKey propertyKey, @JsonProperty(value="task_id") long taskId) {
            this.propertyKey = propertyKey;
            this.taskId = taskId;
        }

        public PropertyKey propertyKey() {
            return this.propertyKey;
        }

        public long taskId() {
            return this.taskId;
        }
    }

    public static class BuilderImpl
    implements Builder {
        private final PropertyKey propertyKey;
        private final SchemaManager manager;
        private String oldName;

        public BuilderImpl(String name, SchemaManager manager) {
            this.propertyKey = new PropertyKey(name);
            this.manager = manager;
        }

        @Override
        public PropertyKey build() {
            return this.propertyKey;
        }

        @Override
        public PropertyKey create() {
            return this.manager.addPropertyKey(this.propertyKey);
        }

        @Override
        public PropertyKey append() {
            return this.manager.appendPropertyKey(this.propertyKey);
        }

        @Override
        public PropertyKey eliminate() {
            return this.manager.eliminatePropertyKey(this.propertyKey);
        }

        @Override
        public PropertyKey update() {
            return this.manager.updatePropertyKey(this.oldName, this.propertyKey);
        }

        @Override
        public Builder id(long id) {
            this.propertyKey.id = id;
            return this;
        }

        @Override
        public void remove() {
            this.manager.removePropertyKey(this.propertyKey.name);
        }

        @Override
        public Builder dataType(DataType dataType) {
            this.propertyKey.dataType = dataType;
            return this;
        }

        @Override
        public Builder newName(String name) {
            this.oldName = this.propertyKey.name;
            this.propertyKey.name = name;
            return this;
        }

        @Override
        public Builder asText() {
            this.propertyKey.dataType = DataType.TEXT;
            return this;
        }

        @Override
        public Builder asInt() {
            this.propertyKey.dataType = DataType.INT;
            return this;
        }

        @Override
        public Builder asDate() {
            this.propertyKey.dataType = DataType.DATE;
            return this;
        }

        @Override
        public Builder asUUID() {
            this.propertyKey.dataType = DataType.UUID;
            return this;
        }

        @Override
        public Builder asBoolean() {
            this.propertyKey.dataType = DataType.BOOLEAN;
            return this;
        }

        @Override
        public Builder asByte() {
            this.propertyKey.dataType = DataType.BYTE;
            return this;
        }

        @Override
        public Builder asBlob() {
            this.propertyKey.dataType = DataType.BLOB;
            return this;
        }

        @Override
        public Builder asDouble() {
            this.propertyKey.dataType = DataType.DOUBLE;
            return this;
        }

        @Override
        public Builder asFloat() {
            this.propertyKey.dataType = DataType.FLOAT;
            return this;
        }

        @Override
        public Builder asLong() {
            this.propertyKey.dataType = DataType.LONG;
            return this;
        }

        @Override
        public Builder cardinality(Cardinality cardinality) {
            this.propertyKey.cardinality = cardinality;
            return this;
        }

        @Override
        public Builder valueSingle() {
            this.propertyKey.cardinality = Cardinality.SINGLE;
            return this;
        }

        @Override
        public Builder valueList() {
            this.propertyKey.cardinality = Cardinality.LIST;
            return this;
        }

        @Override
        public Builder valueSet() {
            this.propertyKey.cardinality = Cardinality.SET;
            return this;
        }

        @Override
        public Builder aggregateType(AggregateType aggregateType) {
            this.propertyKey.aggregateType = aggregateType;
            return this;
        }

        @Override
        public Builder writeType(WriteType writeType) {
            this.propertyKey.writeType = writeType;
            return this;
        }

        @Override
        public Builder writeType(String name) {
            this.propertyKey.writeType = WriteType.valueOf(name);
            return this;
        }

        @Override
        public Builder calcSum() {
            this.propertyKey.aggregateType = AggregateType.SUM;
            return this;
        }

        @Override
        public Builder calcMax() {
            this.propertyKey.aggregateType = AggregateType.MAX;
            return this;
        }

        @Override
        public Builder calcMin() {
            this.propertyKey.aggregateType = AggregateType.MIN;
            return this;
        }

        @Override
        public Builder calcOld() {
            this.propertyKey.aggregateType = AggregateType.OLD;
            return this;
        }

        @Override
        public Builder userdata(String key, Object val) {
            E.checkArgumentNotNull((Object)key, (String)"The user data key can't be null", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)val, (String)"The user data value can't be null", (Object[])new Object[0]);
            this.propertyKey.userdata.put(key, val);
            return this;
        }

        @Override
        public Builder ifNotExist() {
            this.propertyKey.checkExist = false;
            return this;
        }
    }

    public static interface Builder
    extends SchemaBuilder<PropertyKey> {
        public Builder dataType(DataType var1);

        public Builder asText();

        public Builder asInt();

        public Builder asDate();

        public Builder asUUID();

        public Builder asBoolean();

        public Builder asByte();

        public Builder asBlob();

        public Builder asDouble();

        public Builder asFloat();

        public Builder asLong();

        public Builder cardinality(Cardinality var1);

        public Builder valueSingle();

        public Builder valueList();

        public Builder valueSet();

        public Builder aggregateType(AggregateType var1);

        public Builder writeType(WriteType var1);

        public Builder writeType(String var1);

        public Builder calcSum();

        public Builder calcMax();

        public Builder calcMin();

        public Builder calcOld();

        public Builder userdata(String var1, Object var2);

        public Builder ifNotExist();

        public Builder newName(String var1);

        public PropertyKey update();

        public Builder id(long var1);
    }
}

