/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.plan.AbstractVectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class VectorMapJoinDesc
extends AbstractVectorDesc {
    private static final long serialVersionUID = 1L;
    private HashTableImplementationType hashTableImplementationType = HashTableImplementationType.NONE;
    private HashTableKind hashTableKind = HashTableKind.NONE;
    private HashTableKeyType hashTableKeyType = HashTableKeyType.NONE;
    private VectorMapJoinVariation vectorMapJoinVariation = VectorMapJoinVariation.NONE;
    private boolean minMaxEnabled = false;
    private VectorExpression[] allBigTableKeyExpressions = null;
    private VectorExpression[] allBigTableValueExpressions = null;
    private VectorMapJoinInfo vectorMapJoinInfo = null;
    private boolean useOptimizedTable;
    private boolean isVectorizationMapJoinNativeEnabled;
    private String engine;
    private boolean oneMapJoinCondition;
    private boolean hasNullSafes;
    private boolean isFastHashTableEnabled;
    private boolean isHybridHashJoin;
    private boolean supportsKeyTypes;
    private List<String> notSupportedKeyTypes;
    private boolean smallTableExprVectorizes;
    private boolean outerJoinHasNoKeys;

    @Override
    public VectorMapJoinDesc clone() {
        VectorMapJoinDesc clone = new VectorMapJoinDesc();
        clone.hashTableImplementationType = this.hashTableImplementationType;
        clone.hashTableKind = this.hashTableKind;
        clone.hashTableKeyType = this.hashTableKeyType;
        clone.vectorMapJoinVariation = this.vectorMapJoinVariation;
        clone.minMaxEnabled = this.minMaxEnabled;
        if (this.vectorMapJoinInfo != null) {
            throw new RuntimeException("Cloning VectorMapJoinInfo not supported");
        }
        return clone;
    }

    public HashTableImplementationType getHashTableImplementationType() {
        return this.hashTableImplementationType;
    }

    public void setHashTableImplementationType(HashTableImplementationType hashTableImplementationType) {
        this.hashTableImplementationType = hashTableImplementationType;
    }

    public HashTableKind getHashTableKind() {
        return this.hashTableKind;
    }

    public void setHashTableKind(HashTableKind hashTableKind) {
        this.hashTableKind = hashTableKind;
    }

    public HashTableKeyType getHashTableKeyType() {
        return this.hashTableKeyType;
    }

    public void setHashTableKeyType(HashTableKeyType hashTableKeyType) {
        this.hashTableKeyType = hashTableKeyType;
    }

    public VectorMapJoinVariation getVectorMapJoinVariation() {
        return this.vectorMapJoinVariation;
    }

    public void setVectorMapJoinVariation(VectorMapJoinVariation vectorMapJoinVariation) {
        this.vectorMapJoinVariation = vectorMapJoinVariation;
    }

    public boolean getMinMaxEnabled() {
        return this.minMaxEnabled;
    }

    public void setMinMaxEnabled(boolean minMaxEnabled) {
        this.minMaxEnabled = minMaxEnabled;
    }

    public VectorExpression[] getAllBigTableKeyExpressions() {
        return this.allBigTableKeyExpressions;
    }

    public void setAllBigTableKeyExpressions(VectorExpression[] allBigTableKeyExpressions) {
        this.allBigTableKeyExpressions = allBigTableKeyExpressions;
    }

    public VectorExpression[] getAllBigTableValueExpressions() {
        return this.allBigTableValueExpressions;
    }

    public void setAllBigTableValueExpressions(VectorExpression[] allBigTableValueExpressions) {
        this.allBigTableValueExpressions = allBigTableValueExpressions;
    }

    public void setVectorMapJoinInfo(VectorMapJoinInfo vectorMapJoinInfo) {
        Preconditions.checkState(vectorMapJoinInfo != null);
        this.vectorMapJoinInfo = vectorMapJoinInfo;
    }

    public VectorMapJoinInfo getVectorMapJoinInfo() {
        return this.vectorMapJoinInfo;
    }

    public void setUseOptimizedTable(boolean useOptimizedTable) {
        this.useOptimizedTable = useOptimizedTable;
    }

    public boolean getUseOptimizedTable() {
        return this.useOptimizedTable;
    }

    public void setIsVectorizationMapJoinNativeEnabled(boolean isVectorizationMapJoinNativeEnabled) {
        this.isVectorizationMapJoinNativeEnabled = isVectorizationMapJoinNativeEnabled;
    }

    public boolean getIsVectorizationMapJoinNativeEnabled() {
        return this.isVectorizationMapJoinNativeEnabled;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setOneMapJoinCondition(boolean oneMapJoinCondition) {
        this.oneMapJoinCondition = oneMapJoinCondition;
    }

    public boolean getOneMapJoinCondition() {
        return this.oneMapJoinCondition;
    }

    public void setHasNullSafes(boolean hasNullSafes) {
        this.hasNullSafes = hasNullSafes;
    }

    public boolean getHasNullSafes() {
        return this.hasNullSafes;
    }

    public void setSupportsKeyTypes(boolean supportsKeyTypes) {
        this.supportsKeyTypes = supportsKeyTypes;
    }

    public boolean getSupportsKeyTypes() {
        return this.supportsKeyTypes;
    }

    public void setNotSupportedKeyTypes(List<String> notSupportedKeyTypes) {
        this.notSupportedKeyTypes = notSupportedKeyTypes;
    }

    public List<String> getNotSupportedKeyTypes() {
        return this.notSupportedKeyTypes;
    }

    public void setSmallTableExprVectorizes(boolean smallTableExprVectorizes) {
        this.smallTableExprVectorizes = smallTableExprVectorizes;
    }

    public boolean getSmallTableExprVectorizes() {
        return this.smallTableExprVectorizes;
    }

    public void setOuterJoinHasNoKeys(boolean outerJoinHasNoKeys) {
        this.outerJoinHasNoKeys = outerJoinHasNoKeys;
    }

    public boolean getOuterJoinHasNoKeys() {
        return this.outerJoinHasNoKeys;
    }

    public void setIsFastHashTableEnabled(boolean isFastHashTableEnabled) {
        this.isFastHashTableEnabled = isFastHashTableEnabled;
    }

    public boolean getIsFastHashTableEnabled() {
        return this.isFastHashTableEnabled;
    }

    public void setIsHybridHashJoin(boolean isHybridHashJoin) {
        this.isHybridHashJoin = isHybridHashJoin;
    }

    public boolean getIsHybridHashJoin() {
        return this.isHybridHashJoin;
    }

    public static enum VectorMapJoinVariation {
        NONE,
        INNER_BIG_ONLY,
        INNER,
        LEFT_SEMI,
        OUTER;

    }

    public static enum HashTableKeyType {
        NONE,
        BOOLEAN,
        BYTE,
        SHORT,
        INT,
        LONG,
        STRING,
        MULTI_KEY;


        public PrimitiveTypeInfo getPrimitiveTypeInfo() {
            switch (this) {
                case BOOLEAN: {
                    return TypeInfoFactory.booleanTypeInfo;
                }
                case BYTE: {
                    return TypeInfoFactory.byteTypeInfo;
                }
                case INT: {
                    return TypeInfoFactory.intTypeInfo;
                }
                case LONG: {
                    return TypeInfoFactory.longTypeInfo;
                }
                case NONE: {
                    return TypeInfoFactory.voidTypeInfo;
                }
                case SHORT: {
                    return TypeInfoFactory.shortTypeInfo;
                }
                case STRING: {
                    return TypeInfoFactory.stringTypeInfo;
                }
            }
            return null;
        }
    }

    public static enum HashTableKind {
        NONE,
        HASH_SET,
        HASH_MULTISET,
        HASH_MAP;

    }

    public static enum HashTableImplementationType {
        NONE,
        OPTIMIZED,
        FAST;

    }
}

