/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.rest;

import com.google.common.collect.ImmutableMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.rest.OkHttpBasicAuthInterceptor;
import org.apache.hugegraph.rest.OkHttpTokenInterceptor;
import org.apache.hugegraph.rest.RestClient;
import org.apache.hugegraph.rest.RestClientConfig;
import org.apache.hugegraph.rest.RestHeaders;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.util.JsonUtilCommon;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRestClient
implements RestClient {
    private final ThreadLocal<String> authContext;
    private final OkHttpClient client;
    private final String baseUrl;

    public AbstractRestClient(String url, int timeout) {
        this(url, RestClientConfig.builder().timeout(timeout).build());
    }

    public AbstractRestClient(String url, String user, String password, int timeout) {
        this(url, RestClientConfig.builder().user(user).password(password).timeout(timeout).build());
    }

    public AbstractRestClient(String url, int timeout, int idleTime, int maxConns, int maxConnsPerRoute) {
        this(url, RestClientConfig.builder().idleTime(idleTime).timeout(timeout).maxConns(maxConns).maxConnsPerRoute(maxConnsPerRoute).build());
    }

    public AbstractRestClient(String url, String user, String password, int timeout, int maxConns, int maxConnsPerRoute, String trustStoreFile, String trustStorePassword) {
        this(url, RestClientConfig.builder().user(user).password(password).timeout(timeout).maxConns(maxConns).maxConnsPerRoute(maxConnsPerRoute).trustStoreFile(trustStoreFile).trustStorePassword(trustStorePassword).build());
    }

    public AbstractRestClient(String url, String token, int timeout, int maxConns, int maxConnsPerRoute, String trustStoreFile, String trustStorePassword) {
        this(url, RestClientConfig.builder().token(token).timeout(timeout).maxConns(maxConns).maxConnsPerRoute(maxConnsPerRoute).trustStoreFile(trustStoreFile).trustStorePassword(trustStorePassword).build());
    }

    public AbstractRestClient(String url, RestClientConfig config) {
        this.baseUrl = url;
        this.client = this.buildOkHttpClient(config);
        this.authContext = new InheritableThreadLocal<String>();
    }

    private static RequestBody buildRequestBody(Object body, RestHeaders headers) {
        String contentType = AbstractRestClient.parseContentType(headers);
        String bodyContent = "application/json".equals(contentType) ? (body == null ? "{}" : (body instanceof String ? (String)body : JsonUtilCommon.toJson(body))) : String.valueOf(body);
        RequestBody requestBody = RequestBody.create((byte[])bodyContent.getBytes(), (MediaType)MediaType.parse((String)contentType));
        if (headers != null && "gzip".equals(headers.get("Content-Encoding"))) {
            requestBody = AbstractRestClient.gzipBody(requestBody);
        }
        return requestBody;
    }

    private static RequestBody gzipBody(final RequestBody body) {
        return new RequestBody(){

            public MediaType contentType() {
                return body.contentType();
            }

            public long contentLength() {
                return -1L;
            }

            public void writeTo(@NotNull BufferedSink sink) throws IOException {
                BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)sink));
                body.writeTo(gzipSink);
                gzipSink.close();
            }
        };
    }

    private static String parseContentType(RestHeaders headers) {
        String contentType;
        if (headers != null && (contentType = headers.get("Content-Type")) != null) {
            return contentType;
        }
        return "application/json";
    }

    private OkHttpClient buildOkHttpClient(RestClientConfig config) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (config.getTimeout() != null) {
            builder.connectTimeout((long)config.getTimeout().intValue(), TimeUnit.MILLISECONDS).readTimeout((long)config.getTimeout().intValue(), TimeUnit.MILLISECONDS);
        }
        if (config.getConnectTimeout() != null) {
            builder.connectTimeout((long)config.getConnectTimeout().intValue(), TimeUnit.MILLISECONDS);
        }
        if (config.getReadTimeout() != null) {
            builder.readTimeout((long)config.getReadTimeout().intValue(), TimeUnit.MILLISECONDS);
        }
        if (config.getMaxIdleConns() != null || config.getIdleTime() != null) {
            ConnectionPool connectionPool = new ConnectionPool(config.getMaxIdleConns().intValue(), (long)config.getIdleTime().intValue(), TimeUnit.SECONDS);
            builder.connectionPool(connectionPool);
        }
        if (StringUtils.isNotBlank((CharSequence)config.getUser()) && StringUtils.isNotBlank((CharSequence)config.getPassword())) {
            builder.addInterceptor((Interceptor)new OkHttpBasicAuthInterceptor(config.getUser(), config.getPassword()));
        }
        if (StringUtils.isNotBlank((CharSequence)config.getToken())) {
            builder.addInterceptor((Interceptor)new OkHttpTokenInterceptor(config.getToken()));
        }
        this.configSsl(builder, this.baseUrl, config.getTrustStoreFile(), config.getTrustStorePassword());
        if (config.getBuilderCallback() != null) {
            config.getBuilderCallback().accept(builder);
        }
        OkHttpClient okHttpClient = builder.build();
        if (config.getMaxConns() != null) {
            okHttpClient.dispatcher().setMaxRequests(config.getMaxConns().intValue());
        }
        if (config.getMaxConnsPerRoute() != null) {
            okHttpClient.dispatcher().setMaxRequestsPerHost(config.getMaxConnsPerRoute().intValue());
        }
        return okHttpClient;
    }

    private void configSsl(OkHttpClient.Builder builder, String url, String trustStoreFile, String trustStorePass) {
        if (StringUtils.isBlank((CharSequence)trustStoreFile) || StringUtils.isBlank((CharSequence)trustStorePass)) {
            return;
        }
        X509TrustManager trustManager = this.trustManagerForCertificates(trustStoreFile, trustStorePass);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{trustManager}, null);
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        builder.sslSocketFactory(sslSocketFactory, trustManager).hostnameVerifier((HostnameVerifier)new HostNameVerifier(url));
    }

    @Override
    public RestResult post(String path, Object object) {
        return this.post(path, object, null, null);
    }

    @Override
    public RestResult post(String path, Object object, RestHeaders headers) {
        return this.post(path, object, headers, null);
    }

    @Override
    public RestResult post(String path, Object object, Map<String, Object> params) {
        return this.post(path, object, null, params);
    }

    private Request.Builder genRequestBuilder(String path, String id, RestHeaders headers, Map<String, Object> params) {
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)this.baseUrl)).newBuilder().addPathSegments(path);
        if (id != null) {
            urlBuilder.addPathSegment(id);
        }
        if (params != null) {
            params.forEach((name, value) -> {
                if (value == null) {
                    return;
                }
                if (value instanceof Collection) {
                    for (Object i : (Collection)value) {
                        urlBuilder.addQueryParameter(name, String.valueOf(i));
                    }
                } else {
                    urlBuilder.addQueryParameter(name, String.valueOf(value));
                }
            });
        }
        Request.Builder builder = this.newRequestBuilder().url(urlBuilder.build());
        if (headers != null) {
            builder.headers(headers.toOkHttpHeader());
        }
        this.attachAuthToRequest(builder);
        return builder;
    }

    protected Request.Builder newRequestBuilder() {
        return new Request.Builder();
    }

    @Override
    public RestResult post(String path, Object object, RestHeaders headers, Map<String, Object> params) {
        RestResult restResult;
        block8: {
            Request.Builder requestBuilder = this.genRequestBuilder(path, null, headers, params);
            requestBuilder.post(AbstractRestClient.buildRequestBody(object, headers));
            Response response = this.request(requestBuilder);
            try {
                this.checkStatus(response, 200, 201, 202);
                restResult = new RestResult(response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            response.close();
        }
        return restResult;
    }

    @Override
    public RestResult put(String path, String id, Object object) {
        return this.put(path, id, object, (Map<String, Object>)ImmutableMap.of());
    }

    @Override
    public RestResult put(String path, String id, Object object, RestHeaders headers) {
        return this.put(path, id, object, headers, null);
    }

    @Override
    public RestResult put(String path, String id, Object object, Map<String, Object> params) {
        return this.put(path, id, object, null, params);
    }

    @Override
    public RestResult put(String path, String id, Object object, RestHeaders headers, Map<String, Object> params) {
        RestResult restResult;
        block8: {
            Request.Builder requestBuilder = this.genRequestBuilder(path, id, headers, params);
            requestBuilder.put(AbstractRestClient.buildRequestBody(object, headers));
            Response response = this.request(requestBuilder);
            try {
                this.checkStatus(response, 200, 202);
                restResult = new RestResult(response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            response.close();
        }
        return restResult;
    }

    @Override
    public RestResult get(String path) {
        return this.get(path, null, (Map<String, Object>)ImmutableMap.of());
    }

    @Override
    public RestResult get(String path, Map<String, Object> params) {
        return this.get(path, null, params);
    }

    @Override
    public RestResult get(String path, String id) {
        return this.get(path, id, (Map<String, Object>)ImmutableMap.of());
    }

    private RestResult get(String path, String id, Map<String, Object> params) {
        RestResult restResult;
        block8: {
            Request.Builder requestBuilder = this.genRequestBuilder(path, id, null, params);
            Response response = this.request(requestBuilder);
            try {
                this.checkStatus(response, 200);
                restResult = new RestResult(response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            response.close();
        }
        return restResult;
    }

    @Override
    public RestResult delete(String path, Map<String, Object> params) {
        return this.delete(path, null, params);
    }

    @Override
    public RestResult delete(String path, String id) {
        return this.delete(path, id, (Map<String, Object>)ImmutableMap.of());
    }

    private RestResult delete(String path, String id, Map<String, Object> params) {
        RestResult restResult;
        block8: {
            Request.Builder requestBuilder = this.genRequestBuilder(path, id, null, params);
            requestBuilder.delete();
            Response response = this.request(requestBuilder);
            try {
                this.checkStatus(response, 204, 202);
                restResult = new RestResult(response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            response.close();
        }
        return restResult;
    }

    protected abstract void checkStatus(Response var1, int ... var2);

    protected Response request(Request.Builder requestBuilder) {
        return this.client.newCall(requestBuilder.build()).execute();
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.dispatcher().executorService().shutdown();
            this.client.connectionPool().evictAll();
            if (this.client.cache() != null) {
                this.client.cache().close();
            }
        }
    }

    public static String encode(String raw) {
        try {
            return URLEncoder.encode(raw, StandardCharsets.UTF_8.toString()).replace("+", "%2B");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Failed to encode string: " + raw, e);
        }
    }

    public void resetAuthContext() {
        this.authContext.remove();
    }

    public String getAuthContext() {
        return this.authContext.get();
    }

    public void setAuthContext(String auth) {
        this.authContext.set(auth);
    }

    private void attachAuthToRequest(Request.Builder builder) {
        String auth = this.getAuthContext();
        if (StringUtils.isNotEmpty((CharSequence)auth)) {
            builder.addHeader("Authorization", auth);
        }
    }

    private X509TrustManager trustManagerForCertificates(String trustStoreFile, String trustStorePass) {
        char[] password = trustStorePass.toCharArray();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream in = new FileInputStream(trustStoreFile);){
            keyStore.load(in, password);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        Object[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
            throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
        }
        return (X509TrustManager)trustManagers[0];
    }

    public static class HostNameVerifier
    implements HostnameVerifier {
        private final String url;

        public HostNameVerifier(String url) {
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                url = "http://" + url;
            }
            this.url = url = URI.create(url).getHost();
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            if (!this.url.isEmpty() && this.url.endsWith(hostname)) {
                return true;
            }
            HostnameVerifier verifier = HttpsURLConnection.getDefaultHostnameVerifier();
            return verifier.verify(hostname, session);
        }
    }
}

