/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.watch;

import java.util.Objects;
import org.apache.hugegraph.pd.grpc.watch.WatchChangeType;

public class PartitionEvent {
    private final String graph;
    private final int partitionId;
    private final ChangeType changeType;

    public PartitionEvent(String graph, int partitionId, ChangeType changeType) {
        this.graph = graph;
        this.partitionId = partitionId;
        this.changeType = changeType;
    }

    public String getGraph() {
        return this.graph;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionEvent that = (PartitionEvent)o;
        return this.partitionId == that.partitionId && Objects.equals(this.graph, that.graph) && this.changeType == that.changeType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.graph, this.partitionId, this.changeType});
    }

    public String toString() {
        return "PartitionEvent{graph='" + this.graph + "', partitionId=" + this.partitionId + ", changeType=" + this.changeType + "}";
    }

    public static enum ChangeType {
        UNKNOWN,
        ADD,
        ALTER,
        DEL;


        public static ChangeType grpcTypeOf(WatchChangeType grpcType) {
            switch (grpcType) {
                case WATCH_CHANGE_TYPE_ADD: {
                    return ADD;
                }
                case WATCH_CHANGE_TYPE_ALTER: {
                    return ALTER;
                }
                case WATCH_CHANGE_TYPE_DEL: {
                    return DEL;
                }
            }
            return UNKNOWN;
        }
    }
}

