/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.metrics;

import org.apache.hugegraph.loader.metrics.LoadMetrics;
import org.apache.hugegraph.loader.metrics.LoadSummary;

public final class LoadReport {
    private long totalTime;
    private long readSuccess;
    private long readFailure;
    private long vertexParseSuccess;
    private long vertexParseFailure;
    private long vertexInsertSuccess;
    private long vertexInsertFailure;
    private long edgeParseSuccess;
    private long edgeParseFailure;
    private long edgeInsertSuccess;
    private long edgeInsertFailure;

    public long totalTime() {
        return this.totalTime;
    }

    public long readSuccess() {
        return this.readSuccess;
    }

    public long readFailure() {
        return this.readFailure;
    }

    public long vertexParseSuccess() {
        return this.vertexParseSuccess;
    }

    public long vertexParseFailure() {
        return this.vertexParseFailure;
    }

    public long vertexInsertSuccess() {
        return this.vertexInsertSuccess;
    }

    public long vertexInsertFailure() {
        return this.vertexInsertFailure;
    }

    public long edgeParseSuccess() {
        return this.edgeParseSuccess;
    }

    public long edgeParseFailure() {
        return this.edgeParseFailure;
    }

    public long edgeInsertSuccess() {
        return this.edgeInsertSuccess;
    }

    public long edgeInsertFailure() {
        return this.edgeInsertFailure;
    }

    public static LoadReport collect(LoadSummary summary) {
        LoadReport report = new LoadReport();
        report.totalTime = summary.totalTime();
        for (LoadMetrics metrics : summary.inputMetricsMap().values()) {
            report.readSuccess += metrics.readSuccess();
            report.readFailure += metrics.readFailure();
            for (LoadMetrics.Metrics labelMetrics : metrics.vertexMetrics().values()) {
                report.vertexParseSuccess += labelMetrics.parseSuccess();
                report.vertexParseFailure += labelMetrics.parseFailure();
                report.vertexInsertSuccess += labelMetrics.insertSuccess();
                report.vertexInsertFailure += labelMetrics.insertFailure();
            }
            for (LoadMetrics.Metrics labelMetrics : metrics.edgeMetrics().values()) {
                report.edgeParseSuccess += labelMetrics.parseSuccess();
                report.edgeParseFailure += labelMetrics.parseFailure();
                report.edgeInsertSuccess += labelMetrics.insertSuccess();
                report.edgeInsertFailure += labelMetrics.insertFailure();
            }
        }
        return report;
    }
}

