/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.metrics;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hugegraph.loader.constant.ElemType;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.mapping.LoadMapping;
import org.apache.hugegraph.loader.metrics.LoadMetrics;
import org.apache.hugegraph.loader.metrics.RangesTimer;
import org.apache.hugegraph.util.InsertionOrderUtil;

public final class LoadSummary {
    private final LongAdder vertexLoaded = new LongAdder();
    private final LongAdder edgeLoaded = new LongAdder();
    private final StopWatch totalTimer = new StopWatch();
    private final AtomicLong vertexTime = new AtomicLong();
    private final AtomicLong edgeTime = new AtomicLong();
    private final AtomicLong loadTime = new AtomicLong();
    private final RangesTimer vertexRangesTimer = new RangesTimer(1000);
    private final RangesTimer edgeRangesTimer = new RangesTimer(1000);
    private final RangesTimer loadRangesTimer = new RangesTimer(1000);
    private final Map<String, LoadMetrics> inputMetricsMap = InsertionOrderUtil.newMap();

    public void initMetrics(LoadMapping mapping) {
        for (InputStruct struct : mapping.structs()) {
            this.inputMetricsMap.put(struct.id(), new LoadMetrics(struct));
        }
    }

    public Map<String, LoadMetrics> inputMetricsMap() {
        return this.inputMetricsMap;
    }

    public LoadMetrics metrics(InputStruct struct) {
        return this.inputMetricsMap.get(struct.id());
    }

    public long vertexLoaded() {
        return this.vertexLoaded.longValue();
    }

    public long edgeLoaded() {
        return this.edgeLoaded.longValue();
    }

    public void plusLoaded(ElemType type, int count) {
        if (type.isVertex()) {
            this.vertexLoaded.add(count);
        } else {
            this.edgeLoaded.add(count);
        }
    }

    public long totalReadLines() {
        Collection<LoadMetrics> metricsList = this.inputMetricsMap.values();
        long lines = 0L;
        for (LoadMetrics metrics : metricsList) {
            lines += metrics.readSuccess();
            lines += metrics.readFailure();
        }
        return lines;
    }

    public long totalReadSuccess() {
        return this.inputMetricsMap.values().stream().map(LoadMetrics::readSuccess).reduce(0L, Long::sum);
    }

    public long totalReadFailures() {
        return this.inputMetricsMap.values().stream().map(LoadMetrics::readFailure).reduce(0L, Long::sum);
    }

    public long totalParseFailures() {
        return this.inputMetricsMap.values().stream().map(LoadMetrics::totalParseFailures).reduce(0L, Long::sum);
    }

    public long totalInsertFailures() {
        return this.inputMetricsMap.values().stream().map(LoadMetrics::totalInsertFailures).reduce(0L, Long::sum);
    }

    public void addTimeRange(ElemType type, long start, long end) {
        RangesTimer timer = type.isVertex() ? this.vertexRangesTimer : this.edgeRangesTimer;
        timer.addTimeRange(start, end);
        this.loadRangesTimer.addTimeRange(start, end);
    }

    public void calculateTotalTime(ElemType type) {
        RangesTimer timer = type.isVertex() ? this.vertexRangesTimer : this.edgeRangesTimer;
        AtomicLong elemTime = type.isVertex() ? this.vertexTime : this.edgeTime;
        elemTime.set(timer.totalTime());
        this.loadTime.set(this.loadRangesTimer.totalTime());
    }

    public long totalTime() {
        return this.totalTimer.getTime();
    }

    public long vertexTime() {
        return this.vertexTime.longValue();
    }

    public long edgeTime() {
        return this.edgeTime.longValue();
    }

    public long loadTime() {
        return this.loadTime.longValue();
    }

    public void startTotalTimer() {
        if (!this.totalTimer.isStarted()) {
            this.totalTimer.start();
        }
    }

    public void stopTotalTimer() {
        if (!this.totalTimer.isStopped()) {
            this.totalTimer.stop();
        }
    }

    public long loadRate(ElemType type) {
        long totalTime;
        this.calculateTotalTime(type);
        boolean isVertex = type.isVertex();
        long l = totalTime = isVertex ? this.vertexTime() : this.edgeTime();
        if (totalTime == 0L) {
            return -1L;
        }
        long success = isVertex ? this.vertexLoaded() : this.edgeLoaded();
        return success * 1000L / totalTime;
    }
}

