/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.source.file;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;

public final class ListFormat {
    private static final String DEFAULT_START_SYMBOL = "";
    private static final String DEFAULT_END_SYMBOL = "";
    private static final String DEFAULT_ELEM_DELIMITER = "|";
    @JsonProperty(value="start_symbol")
    private String startSymbol;
    @JsonProperty(value="end_symbol")
    private String endSymbol;
    @JsonProperty(value="elem_delimiter")
    private String elemDelimiter;
    @JsonProperty(value="ignored_elems")
    private Set<String> ignoredElems;

    public ListFormat() {
        this("", "", DEFAULT_ELEM_DELIMITER);
    }

    public ListFormat(String startSymbol, String endSymbol, String elemDelimiter) {
        this(startSymbol, endSymbol, elemDelimiter, Sets.newHashSet((Object[])new String[]{""}));
    }

    public ListFormat(String startSymbol, String endSymbol, String elemDelimiter, Set<String> ignoredElems) {
        this.startSymbol = startSymbol;
        this.endSymbol = endSymbol;
        this.elemDelimiter = elemDelimiter;
        this.ignoredElems = ignoredElems;
    }

    public String startSymbol() {
        return this.startSymbol;
    }

    public void startSymbol(String startSymbol) {
        this.startSymbol = startSymbol;
    }

    public String endSymbol() {
        return this.endSymbol;
    }

    public void endSymbol(String endSymbol) {
        this.endSymbol = endSymbol;
    }

    public String elemDelimiter() {
        return this.elemDelimiter;
    }

    public void elemDelimiter(String elemDelimiter) {
        this.elemDelimiter = elemDelimiter;
    }

    public Set<String> ignoredElems() {
        return Collections.unmodifiableSet(this.ignoredElems);
    }
}

