/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.task;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.exception.ServerException;
import org.apache.hugegraph.loader.builder.Record;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.loader.mapping.ElementMapping;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.task.InsertTask;
import org.apache.hugegraph.loader.task.TaskManager;
import org.apache.hugegraph.loader.util.Printer;
import org.apache.hugegraph.rest.ClientException;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class BatchInsertTask
extends InsertTask {
    private static final Logger LOG = Log.logger(TaskManager.class);

    public BatchInsertTask(LoadContext context, InputStruct struct, ElementMapping mapping, List<Record> batch) {
        super(context, struct, mapping, batch);
    }

    @Override
    public void execute() {
        int retryCount = 0;
        do {
            try {
                if (this.mapping.updateStrategies().isEmpty()) {
                    this.insertBatch(this.batch, this.options().checkVertex);
                    break;
                }
                this.updateBatch(this.batch, this.options().checkVertex);
                break;
            }
            catch (ClientException e) {
                LOG.debug("client exception: {}", (Object)e.getMessage());
                Throwable cause = e.getCause();
                if (cause != null && cause.getMessage() != null && StringUtils.containsAny((CharSequence)cause.getMessage(), (CharSequence[])UNACCEPTABLE_MESSAGES)) {
                    throw e;
                }
                retryCount = this.waitThenRetry(retryCount, (RuntimeException)((Object)e));
            }
            catch (ServerException e) {
                String message = e.getMessage();
                LOG.error("server exception: {}", (Object)message);
                if (UNACCEPTABLE_EXCEPTIONS.contains(e.exception())) {
                    throw e;
                }
                if (StringUtils.containsAny((CharSequence)message, (CharSequence[])UNACCEPTABLE_MESSAGES)) {
                    throw e;
                }
                retryCount = this.waitThenRetry(retryCount, (RuntimeException)((Object)e));
            }
        } while (retryCount > 0 && retryCount <= this.options().retryTimes);
        int count = this.batch.size();
        this.plusLoadSuccess(count);
        Printer.printProgress(this.context, this.type(), 10000000L, count);
    }

    private int waitThenRetry(int retryCount, RuntimeException e) {
        LoadOptions options = this.options();
        if (options.retryTimes <= 0) {
            return retryCount;
        }
        if (++retryCount > options.retryTimes) {
            LOG.error("Batch insert has been retried more than {} times", (Object)options.retryTimes);
            throw e;
        }
        long interval = (1L << retryCount) * (long)options.retryInterval;
        LOG.debug("Batch insert will sleep {} seconds then do the {}th retry", (Object)interval, (Object)retryCount);
        try {
            Thread.sleep(interval * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return retryCount;
    }
}

