/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.util.ArrayList;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.SourceFieldMapper;
import org.simpleflatmapper.map.context.impl.BreakDetector;
import org.simpleflatmapper.map.context.impl.BreakDetectorMappingContext;
import org.simpleflatmapper.util.ArrayListEnumerable;
import org.simpleflatmapper.util.Enumerable;
import org.simpleflatmapper.util.ErrorHelper;

public class UnorderedJoinMapperEnumerable<S, T>
implements Enumerable<T> {
    private final SourceFieldMapper<S, T> mapper;
    private final MappingContext<? super S> mappingContext;
    private final Enumerable<S> sourceEnumerable;
    private final BreakDetector<? super S> breakDetector;
    private Enumerable<T> objectsEnumerable;

    public UnorderedJoinMapperEnumerable(SourceFieldMapper<S, T> mapper, MappingContext<? super S> mappingContext, Enumerable<S> sourceEnumerable) {
        this.mapper = mapper;
        this.mappingContext = mappingContext;
        this.sourceEnumerable = sourceEnumerable;
        this.breakDetector = this.getRootDetector(mappingContext);
    }

    private BreakDetector<? super S> getRootDetector(MappingContext<? super S> mappingContext) {
        BreakDetectorMappingContext mp = (BreakDetectorMappingContext)mappingContext;
        BreakDetector rootDetector = mp.getRootDetector();
        if (!rootDetector.hasKeyDefinition()) {
            throw new IllegalStateException("No key definitions");
        }
        return rootDetector;
    }

    public boolean next() {
        try {
            if (this.objectsEnumerable == null) {
                this.objectsEnumerable = this.fetchAll();
            }
            return this.objectsEnumerable.next();
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
            return false;
        }
    }

    private Enumerable<T> fetchAll() throws Exception {
        ArrayList<Object> objects = new ArrayList<Object>();
        while (this.sourceEnumerable.next()) {
            Object source = this.sourceEnumerable.currentValue();
            this.mappingContext.handleSource(source);
            Object currentValue = this.breakDetector.getValue();
            if (currentValue == null) {
                currentValue = this.mapper.map((S)source, this.mappingContext);
                this.breakDetector.setValue(currentValue);
                objects.add(currentValue);
                continue;
            }
            this.mapper.mapTo((S)source, currentValue, this.mappingContext);
        }
        return new ArrayListEnumerable(objects);
    }

    public T currentValue() {
        return (T)this.objectsEnumerable.currentValue();
    }

    public String toString() {
        return "UnorderedJoinMapperEnumerable{jdbcMapper=" + this.mapper + '}';
    }
}

