/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.hugegraph.pd.client.Channels;
import org.apache.hugegraph.pd.client.PDPulse;
import org.apache.hugegraph.pd.grpc.pulse.HgPdPulseGrpc;
import org.apache.hugegraph.pd.grpc.pulse.PartitionHeartbeatRequest;
import org.apache.hugegraph.pd.grpc.pulse.PulseAckRequest;
import org.apache.hugegraph.pd.grpc.pulse.PulseCreateRequest;
import org.apache.hugegraph.pd.grpc.pulse.PulseNoticeRequest;
import org.apache.hugegraph.pd.grpc.pulse.PulseRequest;
import org.apache.hugegraph.pd.grpc.pulse.PulseResponse;
import org.apache.hugegraph.pd.grpc.pulse.PulseType;
import org.apache.hugegraph.pd.pulse.PartitionNotice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PDPulseImpl
implements PDPulse {
    private static final Logger log = LoggerFactory.getLogger(PDPulseImpl.class);
    private static final ConcurrentHashMap<String, ManagedChannel> chs = new ConcurrentHashMap();
    private final ExecutorService threadPool;
    private HgPdPulseGrpc.HgPdPulseStub stub;
    private String pdServerAddress;

    public PDPulseImpl(String pdServerAddress) {
        this.pdServerAddress = pdServerAddress;
        this.stub = HgPdPulseGrpc.newStub((Channel)Channels.getChannel(pdServerAddress));
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("ack-notice-pool-%d").build();
        this.threadPool = Executors.newSingleThreadExecutor(namedThreadFactory);
    }

    private String getCurrentHost() {
        return this.pdServerAddress;
    }

    private boolean checkChannel() {
        return this.stub != null && !((ManagedChannel)this.stub.getChannel()).isShutdown();
    }

    @Override
    public PDPulse.Notifier<PartitionHeartbeatRequest.Builder> connectPartition(PDPulse.Listener<PulseResponse> listener) {
        return new PartitionHeartbeat(listener);
    }

    @Override
    public boolean resetStub(String host, PDPulse.Notifier notifier) {
        log.info("reset stub: current, {}, new: {}, channel state:{}", new Object[]{this.getCurrentHost(), host, this.checkChannel()});
        if (Objects.equals(host, this.getCurrentHost()) && this.checkChannel()) {
            return false;
        }
        if (notifier != null) {
            notifier.close();
        }
        this.stub = HgPdPulseGrpc.newStub((Channel)Channels.getChannel(host));
        log.info("pd pulse connect to {}", (Object)host);
        this.pdServerAddress = host;
        return true;
    }

    private abstract class AbstractConnector<N, L>
    implements PDPulse.Notifier<N>,
    StreamObserver<PulseResponse> {
        PDPulse.Listener<L> listener;
        StreamObserver<PulseRequest> reqStream;
        PulseType pulseType;
        PulseRequest.Builder reqBuilder = PulseRequest.newBuilder();
        PulseAckRequest.Builder ackBuilder = PulseAckRequest.newBuilder();

        private AbstractConnector(PDPulse.Listener<L> listener, PulseType pulseType) {
            this.listener = listener;
            this.pulseType = pulseType;
            this.init();
        }

        void init() {
            PulseCreateRequest.Builder builder = PulseCreateRequest.newBuilder().setPulseType(this.pulseType);
            this.reqStream = PDPulseImpl.this.stub.pulse((StreamObserver)this);
            this.reqStream.onNext((Object)this.reqBuilder.clear().setCreateRequest(builder).build());
        }

        @Override
        public void close() {
            this.reqStream.onCompleted();
        }

        @Override
        public abstract void notifyServer(N var1);

        @Override
        public void crash(String error) {
            this.reqStream.onError(new Throwable(error));
        }

        public abstract void onNext(PulseResponse var1);

        public void onError(Throwable throwable) {
            this.listener.onError(throwable);
        }

        public void onCompleted() {
            this.listener.onCompleted();
        }

        protected void ackNotice(long noticeId, long observerId) {
            PDPulseImpl.this.threadPool.execute(() -> this.reqStream.onNext((Object)this.reqBuilder.clear().setAckRequest(this.ackBuilder.clear().setNoticeId(noticeId).setObserverId(observerId).build()).build()));
        }
    }

    private class PartitionHeartbeat
    extends AbstractConnector<PartitionHeartbeatRequest.Builder, PulseResponse> {
        private long observerId;

        PartitionHeartbeat(PDPulse.Listener<PulseResponse> listener) {
            super(listener, PulseType.PULSE_TYPE_PARTITION_HEARTBEAT);
            this.observerId = -1L;
        }

        private void setObserverId(long observerId) {
            if (this.observerId == -1L) {
                this.observerId = observerId;
            }
        }

        @Override
        public void notifyServer(PartitionHeartbeatRequest.Builder requestBuilder) {
            this.reqStream.onNext((Object)PulseRequest.newBuilder().setNoticeRequest(PulseNoticeRequest.newBuilder().setPartitionHeartbeatRequest(requestBuilder.build()).build()).build());
        }

        @Override
        public void onNext(PulseResponse pulseResponse) {
            this.setObserverId(pulseResponse.getObserverId());
            long noticeId = pulseResponse.getNoticeId();
            this.listener.onNext(pulseResponse);
            this.listener.onNotice(new PartitionNotice(noticeId, e -> super.ackNotice((long)e, this.observerId), pulseResponse));
        }
    }
}

