/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.filter.util;

import org.apache.hugegraph.driver.SchemaManager;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.loader.filter.util.ShortIdConfig;
import org.apache.hugegraph.structure.constant.IdStrategy;
import org.apache.hugegraph.structure.schema.VertexLabel;

public class VertexLabelBuilderProxy
implements VertexLabel.Builder {
    private VertexLabel.BuilderImpl builder;
    private ShortIdConfig config;

    public VertexLabelBuilderProxy(String name, SchemaManager manager, LoadOptions options) {
        this.builder = new VertexLabel.BuilderImpl(name, manager);
        for (ShortIdConfig config : options.shorterIDConfigs) {
            if (!config.getVertexLabel().equals(name)) continue;
            this.config = config;
            break;
        }
    }

    public VertexLabel build() {
        return this.builder.build();
    }

    public VertexLabel create() {
        return this.builder.create();
    }

    public VertexLabel append() {
        return this.builder.append();
    }

    public VertexLabel eliminate() {
        return this.builder.eliminate();
    }

    public void remove() {
        this.builder.remove();
    }

    public VertexLabel.Builder idStrategy(IdStrategy idStrategy) {
        this.builder.idStrategy(idStrategy);
        return this;
    }

    public VertexLabel.Builder useAutomaticId() {
        this.builder.useAutomaticId();
        return this;
    }

    public VertexLabel.Builder usePrimaryKeyId() {
        if (this.config != null) {
            this.builder.properties(new String[]{this.config.getIdFieldName()});
            this.builder.nullableKeys(new String[]{this.config.getIdFieldName()});
        } else {
            this.builder.usePrimaryKeyId();
        }
        return this;
    }

    public VertexLabel.Builder useCustomizeStringId() {
        this.builder.useCustomizeStringId();
        if (this.config != null) {
            this.builder.properties(new String[]{this.config.getIdFieldName()});
            this.builder.nullableKeys(new String[]{this.config.getIdFieldName()});
        }
        return this;
    }

    public VertexLabel.Builder useCustomizeNumberId() {
        this.builder.useCustomizeNumberId();
        if (this.config != null) {
            this.builder.properties(new String[]{this.config.getIdFieldName()});
            this.builder.nullableKeys(new String[]{this.config.getIdFieldName()});
        }
        return this;
    }

    public VertexLabel.Builder useCustomizeUuidId() {
        this.builder.useCustomizeUuidId();
        if (this.config != null) {
            this.builder.properties(new String[]{this.config.getIdFieldName()});
            this.builder.nullableKeys(new String[]{this.config.getIdFieldName()});
        }
        return this;
    }

    public VertexLabel.Builder properties(String ... properties) {
        this.builder.properties(properties);
        return this;
    }

    public VertexLabel.Builder primaryKeys(String ... keys) {
        if (this.config != null) {
            this.config.setPrimaryKeyField(keys[0]);
            this.builder.useCustomizeNumberId();
            this.builder.properties(new String[]{this.config.getIdFieldName()});
            this.builder.nullableKeys(new String[]{this.config.getIdFieldName()});
        } else {
            this.builder.primaryKeys(keys);
        }
        return this;
    }

    public VertexLabel.Builder nullableKeys(String ... keys) {
        this.builder.nullableKeys(keys);
        return this;
    }

    public VertexLabel.Builder ttl(long ttl) {
        this.builder.ttl(ttl);
        return this;
    }

    public VertexLabel.Builder ttlStartTime(String ttlStartTime) {
        this.builder.ttlStartTime(ttlStartTime);
        return this;
    }

    public VertexLabel.Builder enableLabelIndex(boolean enable) {
        this.builder.enableLabelIndex(enable);
        return this;
    }

    public VertexLabel.Builder userdata(String key, Object val) {
        this.builder.userdata(key, val);
        return this;
    }

    public VertexLabel.Builder ifNotExist() {
        this.builder.ifNotExist();
        return this;
    }

    public VertexLabel.Builder id(long id) {
        this.builder.id(id);
        return this;
    }
}

