/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.parser;

import java.util.Arrays;
import org.apache.hugegraph.loader.exception.ReadException;
import org.apache.hugegraph.loader.parser.LineParser;
import org.apache.hugegraph.loader.reader.line.Line;
import org.apache.hugegraph.util.StringUtil;

public class TextLineParser
implements LineParser {
    private final String delimiter;

    public TextLineParser(String delimiter) {
        this.delimiter = delimiter != null ? delimiter : "\t";
    }

    public String delimiter() {
        return this.delimiter;
    }

    @Override
    public Line parse(String[] header, String rawLine) throws ReadException {
        Object[] columns = this.split(rawLine);
        if (columns.length > header.length) {
            int extra = columns.length - header.length;
            if (!this.tailColumnEmpty((String[])columns, extra)) {
                throw new ReadException(rawLine, "The column length '%s' doesn't match with header length '%s' on: %s", columns.length, header.length, rawLine);
            }
            Object[] subColumns = new String[header.length];
            System.arraycopy(columns, 0, subColumns, 0, header.length);
            return new Line(rawLine, header, subColumns);
        }
        if (columns.length < header.length) {
            Object[] supColumns = new String[header.length];
            System.arraycopy(columns, 0, supColumns, 0, columns.length);
            Arrays.fill(supColumns, columns.length, supColumns.length, "");
            return new Line(rawLine, header, supColumns);
        }
        return new Line(rawLine, header, columns);
    }

    @Override
    public String[] split(String line) {
        return StringUtil.split((String)line, (String)this.delimiter);
    }

    private boolean tailColumnEmpty(String[] columns, int count) {
        for (int i = 0; i < count; ++i) {
            int tailIdx = columns.length - 1 - i;
            if (columns[tailIdx].equals("")) continue;
            return false;
        }
        return true;
    }
}

