/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.source.graph;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.driver.factory.PDHugeClientFactory;
import org.apache.hugegraph.loader.source.AbstractSource;
import org.apache.hugegraph.loader.source.SourceType;
import org.apache.hugegraph.loader.source.file.FileSource;
import org.apache.hugegraph.util.E;

public class GraphSource
extends AbstractSource {
    @JsonProperty(value="pd-peers")
    private String pdPeers;
    @JsonProperty(value="meta-endpoints")
    private String metaEndPoints;
    @JsonProperty(value="cluster")
    private String cluster;
    @JsonProperty(value="graphspace")
    private String graphSpace;
    @JsonProperty(value="graph")
    private String graph;
    @JsonProperty(value="username")
    private String username;
    @JsonProperty(value="password")
    private String password;
    @JsonProperty(value="selected_vertices")
    private List<SelectedLabelDes> selectedVertices;
    @JsonProperty(value="ignored_vertices")
    private List<IgnoredLabelDes> ignoredVertices;
    @JsonProperty(value="selected_edges")
    private List<SelectedLabelDes> selectedEdges;
    @JsonProperty(value="ignored_edges")
    private List<IgnoredLabelDes> ignoredEdges;
    @JsonProperty(value="batch_size")
    private int batchSize = 500;

    @Override
    public SourceType type() {
        return SourceType.GRAPH;
    }

    @Override
    public void check() throws IllegalArgumentException {
        super.check();
        E.checkArgument((!StringUtils.isEmpty((CharSequence)this.graphSpace) ? 1 : 0) != 0, (String)"graphspace of GraphInput must be not empty", (Object[])new Object[0]);
        E.checkArgument((!StringUtils.isEmpty((CharSequence)this.graph) ? 1 : 0) != 0, (String)"graph of GraphInput must be not empty", (Object[])new Object[0]);
    }

    @Override
    public FileSource asFileSource() {
        FileSource source = new FileSource();
        source.header(this.header());
        source.charset(this.charset());
        source.listFormat(this.listFormat());
        return source;
    }

    public HugeClient createHugeClient() {
        try (PDHugeClientFactory factory = new PDHugeClientFactory(this.pdPeers);){
            HugeClient hugeClient = factory.createAuthClient(this.cluster, this.graphSpace, this.graph, null, this.username, this.password);
            return hugeClient;
        }
    }

    public String getPdPeers() {
        return this.pdPeers;
    }

    public String getMetaEndPoints() {
        return this.metaEndPoints;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getGraphSpace() {
        return this.graphSpace;
    }

    public String getGraph() {
        return this.graph;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public List<SelectedLabelDes> getSelectedVertices() {
        return this.selectedVertices;
    }

    public List<IgnoredLabelDes> getIgnoredVertices() {
        return this.ignoredVertices;
    }

    public List<SelectedLabelDes> getSelectedEdges() {
        return this.selectedEdges;
    }

    public List<IgnoredLabelDes> getIgnoredEdges() {
        return this.ignoredEdges;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty(value="pd-peers")
    public void setPdPeers(String pdPeers) {
        this.pdPeers = pdPeers;
    }

    @JsonProperty(value="meta-endpoints")
    public void setMetaEndPoints(String metaEndPoints) {
        this.metaEndPoints = metaEndPoints;
    }

    @JsonProperty(value="cluster")
    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    @JsonProperty(value="graphspace")
    public void setGraphSpace(String graphSpace) {
        this.graphSpace = graphSpace;
    }

    @JsonProperty(value="graph")
    public void setGraph(String graph) {
        this.graph = graph;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    @JsonProperty(value="selected_vertices")
    public void setSelectedVertices(List<SelectedLabelDes> selectedVertices) {
        this.selectedVertices = selectedVertices;
    }

    @JsonProperty(value="ignored_vertices")
    public void setIgnoredVertices(List<IgnoredLabelDes> ignoredVertices) {
        this.ignoredVertices = ignoredVertices;
    }

    @JsonProperty(value="selected_edges")
    public void setSelectedEdges(List<SelectedLabelDes> selectedEdges) {
        this.selectedEdges = selectedEdges;
    }

    @JsonProperty(value="ignored_edges")
    public void setIgnoredEdges(List<IgnoredLabelDes> ignoredEdges) {
        this.ignoredEdges = ignoredEdges;
    }

    @JsonProperty(value="batch_size")
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphSource)) {
            return false;
        }
        GraphSource other = (GraphSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pdPeers = this.getPdPeers();
        String other$pdPeers = other.getPdPeers();
        if (this$pdPeers == null ? other$pdPeers != null : !this$pdPeers.equals(other$pdPeers)) {
            return false;
        }
        String this$metaEndPoints = this.getMetaEndPoints();
        String other$metaEndPoints = other.getMetaEndPoints();
        if (this$metaEndPoints == null ? other$metaEndPoints != null : !this$metaEndPoints.equals(other$metaEndPoints)) {
            return false;
        }
        String this$cluster = this.getCluster();
        String other$cluster = other.getCluster();
        if (this$cluster == null ? other$cluster != null : !this$cluster.equals(other$cluster)) {
            return false;
        }
        String this$graphSpace = this.getGraphSpace();
        String other$graphSpace = other.getGraphSpace();
        if (this$graphSpace == null ? other$graphSpace != null : !this$graphSpace.equals(other$graphSpace)) {
            return false;
        }
        String this$graph = this.getGraph();
        String other$graph = other.getGraph();
        if (this$graph == null ? other$graph != null : !this$graph.equals(other$graph)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        List<SelectedLabelDes> this$selectedVertices = this.getSelectedVertices();
        List<SelectedLabelDes> other$selectedVertices = other.getSelectedVertices();
        if (this$selectedVertices == null ? other$selectedVertices != null : !((Object)this$selectedVertices).equals(other$selectedVertices)) {
            return false;
        }
        List<IgnoredLabelDes> this$ignoredVertices = this.getIgnoredVertices();
        List<IgnoredLabelDes> other$ignoredVertices = other.getIgnoredVertices();
        if (this$ignoredVertices == null ? other$ignoredVertices != null : !((Object)this$ignoredVertices).equals(other$ignoredVertices)) {
            return false;
        }
        List<SelectedLabelDes> this$selectedEdges = this.getSelectedEdges();
        List<SelectedLabelDes> other$selectedEdges = other.getSelectedEdges();
        if (this$selectedEdges == null ? other$selectedEdges != null : !((Object)this$selectedEdges).equals(other$selectedEdges)) {
            return false;
        }
        List<IgnoredLabelDes> this$ignoredEdges = this.getIgnoredEdges();
        List<IgnoredLabelDes> other$ignoredEdges = other.getIgnoredEdges();
        if (this$ignoredEdges == null ? other$ignoredEdges != null : !((Object)this$ignoredEdges).equals(other$ignoredEdges)) {
            return false;
        }
        return this.getBatchSize() == other.getBatchSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof GraphSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pdPeers = this.getPdPeers();
        result = result * 59 + ($pdPeers == null ? 43 : $pdPeers.hashCode());
        String $metaEndPoints = this.getMetaEndPoints();
        result = result * 59 + ($metaEndPoints == null ? 43 : $metaEndPoints.hashCode());
        String $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : $cluster.hashCode());
        String $graphSpace = this.getGraphSpace();
        result = result * 59 + ($graphSpace == null ? 43 : $graphSpace.hashCode());
        String $graph = this.getGraph();
        result = result * 59 + ($graph == null ? 43 : $graph.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        List<SelectedLabelDes> $selectedVertices = this.getSelectedVertices();
        result = result * 59 + ($selectedVertices == null ? 43 : ((Object)$selectedVertices).hashCode());
        List<IgnoredLabelDes> $ignoredVertices = this.getIgnoredVertices();
        result = result * 59 + ($ignoredVertices == null ? 43 : ((Object)$ignoredVertices).hashCode());
        List<SelectedLabelDes> $selectedEdges = this.getSelectedEdges();
        result = result * 59 + ($selectedEdges == null ? 43 : ((Object)$selectedEdges).hashCode());
        List<IgnoredLabelDes> $ignoredEdges = this.getIgnoredEdges();
        result = result * 59 + ($ignoredEdges == null ? 43 : ((Object)$ignoredEdges).hashCode());
        result = result * 59 + this.getBatchSize();
        return result;
    }

    public String toString() {
        return "GraphSource(pdPeers=" + this.getPdPeers() + ", metaEndPoints=" + this.getMetaEndPoints() + ", cluster=" + this.getCluster() + ", graphSpace=" + this.getGraphSpace() + ", graph=" + this.getGraph() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", selectedVertices=" + this.getSelectedVertices() + ", ignoredVertices=" + this.getIgnoredVertices() + ", selectedEdges=" + this.getSelectedEdges() + ", ignoredEdges=" + this.getIgnoredEdges() + ", batchSize=" + this.getBatchSize() + ")";
    }

    public static class IgnoredLabelDes {
        @JsonProperty(value="label")
        private String label;
        @JsonProperty(value="properties")
        private List<String> properties;

        public String getLabel() {
            return this.label;
        }

        public List<String> getProperties() {
            return this.properties;
        }

        @JsonProperty(value="label")
        public void setLabel(String label) {
            this.label = label;
        }

        @JsonProperty(value="properties")
        public void setProperties(List<String> properties) {
            this.properties = properties;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IgnoredLabelDes)) {
                return false;
            }
            IgnoredLabelDes other = (IgnoredLabelDes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            List<String> this$properties = this.getProperties();
            List<String> other$properties = other.getProperties();
            return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IgnoredLabelDes;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            List<String> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            return result;
        }

        public String toString() {
            return "GraphSource.IgnoredLabelDes(label=" + this.getLabel() + ", properties=" + this.getProperties() + ")";
        }
    }

    public static class SelectedLabelDes {
        @JsonProperty(value="query")
        private Map<String, Object> query;
        @JsonProperty(value="label")
        private String label;
        @JsonProperty(value="properties")
        private List<String> properties;

        public Map<String, Object> getQuery() {
            return this.query;
        }

        public String getLabel() {
            return this.label;
        }

        public List<String> getProperties() {
            return this.properties;
        }

        @JsonProperty(value="query")
        public void setQuery(Map<String, Object> query) {
            this.query = query;
        }

        @JsonProperty(value="label")
        public void setLabel(String label) {
            this.label = label;
        }

        @JsonProperty(value="properties")
        public void setProperties(List<String> properties) {
            this.properties = properties;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SelectedLabelDes)) {
                return false;
            }
            SelectedLabelDes other = (SelectedLabelDes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$query = this.getQuery();
            Map<String, Object> other$query = other.getQuery();
            if (this$query == null ? other$query != null : !((Object)this$query).equals(other$query)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            List<String> this$properties = this.getProperties();
            List<String> other$properties = other.getProperties();
            return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SelectedLabelDes;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $query = this.getQuery();
            result = result * 59 + ($query == null ? 43 : ((Object)$query).hashCode());
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            List<String> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            return result;
        }

        public String toString() {
            return "GraphSource.SelectedLabelDes(query=" + this.getQuery() + ", label=" + this.getLabel() + ", properties=" + this.getProperties() + ")";
        }
    }
}

