/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.reflect.Instantiator;
import org.simpleflatmapper.reflect.MethodBiFunctionPair;
import org.simpleflatmapper.util.ErrorHelper;

public final class BuilderBiInstantiator<S1, S2, T>
implements BiInstantiator<S1, S2, T> {
    public final Instantiator<Void, ?> builderInstantiator;
    public final MethodBiFunctionPair<S1, S2>[] chainedArguments;
    public final MethodBiFunctionPair<S1, S2>[] unchainedArguments;
    public final Method buildMethod;
    public final boolean ignoreNullValues;
    private boolean notStatic;

    public BuilderBiInstantiator(Instantiator<Void, ?> builderInstantiator, MethodBiFunctionPair<S1, S2>[] chainedArguments, MethodBiFunctionPair<S1, S2>[] unchainedArguments, Method buildMethod, boolean ignoreNullValues) {
        this.builderInstantiator = builderInstantiator;
        this.chainedArguments = chainedArguments;
        this.unchainedArguments = unchainedArguments;
        this.buildMethod = buildMethod;
        this.ignoreNullValues = ignoreNullValues;
        this.notStatic = !Modifier.isStatic(buildMethod.getModifiers());
    }

    @Override
    public T newInstance(S1 s1, S2 s2) throws Exception {
        try {
            Object builder = this.newInitialisedBuilderInstace(s1, s2);
            if (this.notStatic) {
                return (T)this.buildMethod.invoke(builder, new Object[0]);
            }
            return (T)this.buildMethod.invoke(null, builder);
        }
        catch (InvocationTargetException e) {
            return (T)ErrorHelper.rethrow((Throwable)e.getCause());
        }
    }

    public Object newInitialisedBuilderInstace(S1 s1, S2 s2) throws Exception {
        Object v;
        Object builder = this.builderInstantiator.newInstance(null);
        for (MethodBiFunctionPair<S1, S2> argument : this.chainedArguments) {
            v = argument.getFunction().apply(s1, s2);
            if (this.ignoreNullValues && v == null) continue;
            builder = argument.getMethod().invoke(builder, v);
        }
        for (MethodBiFunctionPair<S1, S2> argument : this.unchainedArguments) {
            v = argument.getFunction().apply(s1, s2);
            if (this.ignoreNullValues && v == null) continue;
            argument.getMethod().invoke(builder, v);
        }
        return builder;
    }
}

