/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.serializer.direct.reuse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hugegraph.driver.GraphManager;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.driver.SchemaManager;
import org.apache.hugegraph.serializer.direct.HBaseSerializer;
import org.apache.hugegraph.serializer.direct.RocksDBSerializer;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.graph.Vertex;

public class BytesDemo {
    static HugeClient client;
    boolean bypassServer = true;
    RocksDBSerializer ser;
    HBaseSerializer hBaseSer;

    public static void main(String[] args) {
        BytesDemo ins = new BytesDemo();
        ins.initGraph();
    }

    void initGraph() {
        int edgeLogicPartitions = 16;
        int vertexLogicPartitions = 8;
        client = HugeClient.builder("http://localhost:8081", "DEFAULT", "hugegraph").build();
        SchemaManager schema = client.schema();
        schema.propertyKey("name").asText().ifNotExist().create();
        schema.propertyKey("age").asInt().ifNotExist().create();
        schema.propertyKey("lang").asText().ifNotExist().create();
        schema.propertyKey("date").asText().ifNotExist().create();
        schema.propertyKey("price").asText().ifNotExist().create();
        schema.vertexLabel("person").properties("name", "age").useCustomizeStringId().enableLabelIndex(false).ifNotExist().create();
        schema.vertexLabel("personB").properties("price").nullableKeys("price").useCustomizeNumberId().enableLabelIndex(false).ifNotExist().create();
        schema.vertexLabel("software").properties("name", "lang", "price").useCustomizeStringId().enableLabelIndex(false).ifNotExist().create();
        schema.edgeLabel("knows").link("person", "person").properties("date").enableLabelIndex(false).ifNotExist().create();
        schema.edgeLabel("created").link("person", "software").properties("date").enableLabelIndex(false).ifNotExist().create();
        this.hBaseSer = new HBaseSerializer(client, vertexLogicPartitions, edgeLogicPartitions);
        this.writeGraphElements();
        client.close();
    }

    private void writeGraphElements() {
        GraphManager graph = client.graph();
        final Vertex peter = new Vertex("person");
        peter.property("name", "peter");
        peter.property("age", 35);
        peter.id("peter");
        final Vertex lop = new Vertex("software");
        lop.property("name", "lop");
        lop.property("lang", "java");
        lop.property("price", "328");
        lop.id("lop");
        final Vertex vadasB = new Vertex("personB");
        vadasB.property("price", "120");
        vadasB.id(12345);
        final Edge peterCreateLop = new Edge("created").source(peter).target(lop).property("date", "2017-03-24");
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(){
            {
                this.add(peter);
                this.add(lop);
                this.add(vadasB);
            }
        };
        ArrayList<Edge> edges = new ArrayList<Edge>(){
            {
                this.add(peterCreateLop);
            }
        };
        if (this.bypassServer) {
            this.writeDirectly((List<Vertex>)vertices, (List<Edge>)edges);
        } else {
            this.writeByServer(graph, (List<Vertex>)vertices, (List<Edge>)edges);
        }
    }

    void writeDirectly(List<Vertex> vertices, List<Edge> edges) {
        byte[] values;
        byte[] rowkey;
        for (Vertex vertex : vertices) {
            rowkey = this.hBaseSer.getKeyBytes(vertex);
            values = this.hBaseSer.getValueBytes(vertex);
            this.sendRpcToHBase("vertex", rowkey, values);
        }
        for (Edge edge : edges) {
            rowkey = this.hBaseSer.getKeyBytes(edge);
            values = this.hBaseSer.getValueBytes(edge);
            this.sendRpcToHBase("edge", rowkey, values);
        }
    }

    boolean sendRpcToRocksDB(byte[] rowkey, byte[] values) {
        boolean flag = false;
        return flag;
    }

    void writeByServer(GraphManager graph, List<Vertex> vertices, List<Edge> edges) {
        vertices = graph.addVertices(vertices);
        vertices.forEach(System.out::println);
        edges = graph.addEdges(edges, false);
        edges.forEach(System.out::println);
    }

    boolean sendRpcToHBase(String type, byte[] rowkey, byte[] values) {
        boolean flag = false;
        try {
            flag = this.put(type, rowkey, values);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    boolean put(String type, byte[] rowkey, byte[] values) throws IOException {
        return true;
    }
}

