/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.concurrent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.concurrent.LockGroup;

public class LockManager {
    private static final LockManager INSTANCE = new LockManager();
    private Map<String, LockGroup> lockGroupMap = new ConcurrentHashMap<String, LockGroup>();

    public static LockManager instance() {
        return INSTANCE;
    }

    private LockManager() {
    }

    public boolean exists(String group) {
        return this.lockGroupMap.containsKey(group);
    }

    public LockGroup create(String group) {
        if (this.exists(group)) {
            throw new RuntimeException(String.format("LockGroup '%s' already exists", group));
        }
        LockGroup lockGroup = new LockGroup(group);
        LockGroup previous = this.lockGroupMap.putIfAbsent(group, lockGroup);
        if (previous != null) {
            return previous;
        }
        return lockGroup;
    }

    public LockGroup get(String group) {
        LockGroup lockGroup = this.lockGroupMap.get(group);
        if (lockGroup == null) {
            throw new RuntimeException(String.format("LockGroup '%s' does not exists", group));
        }
        return lockGroup;
    }

    public void destroy(String group) {
        if (!this.exists(group)) {
            throw new RuntimeException(String.format("LockGroup '%s' does not exists", group));
        }
        this.lockGroupMap.remove(group);
    }
}

