/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.servlet;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class ApplicationContextRequestMatcher<C>
implements RequestMatcher {
    private final Class<? extends C> contextClass;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public ApplicationContextRequestMatcher(Class<? extends C> contextClass) {
        Assert.notNull(contextClass, (String)"Context class must not be null");
        this.contextClass = contextClass;
    }

    public final boolean matches(HttpServletRequest request) {
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getServletContext());
        if (this.ignoreApplicationContext(webApplicationContext)) {
            return false;
        }
        Supplier<Object> context = () -> this.getContext(webApplicationContext);
        if (this.initialized.compareAndSet(false, true)) {
            this.initialized(context);
        }
        return this.matches(request, context);
    }

    private C getContext(WebApplicationContext webApplicationContext) {
        if (this.contextClass.isInstance(webApplicationContext)) {
            return (C)webApplicationContext;
        }
        return (C)webApplicationContext.getBean(this.contextClass);
    }

    protected boolean ignoreApplicationContext(WebApplicationContext webApplicationContext) {
        return false;
    }

    protected void initialized(Supplier<C> context) {
    }

    protected abstract boolean matches(HttpServletRequest var1, Supplier<C> var2);
}

