/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.type;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.fury.collection.Tuple2;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.reflect.TypeRef;

public class ScalaTypes {
    private static final Class<?> SCALA_MAP_TYPE;
    private static final Class<?> SCALA_SEQ_TYPE;
    private static final Class<?> SCALA_ITERABLE_TYPE;
    private static final Class<?> SCALA_ITERATOR_TYPE;
    private static final Type SCALA_ITERATOR_RETURN_TYPE;
    private static final Type SCALA_NEXT_RETURN_TYPE;

    public static Class<?> getScalaMapType() {
        return SCALA_MAP_TYPE;
    }

    public static Class<?> getScalaSeqType() {
        return SCALA_SEQ_TYPE;
    }

    public static Class<?> getScalaIterableType() {
        return SCALA_ITERABLE_TYPE;
    }

    public static TypeRef<?> getElementType(TypeRef typeRef) {
        TypeRef<?> supertype = typeRef.getSupertype(ScalaTypes.getScalaIterableType());
        return supertype.resolveType(SCALA_ITERATOR_RETURN_TYPE).resolveType(SCALA_NEXT_RETURN_TYPE);
    }

    public static Tuple2<TypeRef<?>, TypeRef<?>> getMapKeyValueType(TypeRef typeRef) {
        TypeRef<?> kvTupleType = ScalaTypes.getElementType(typeRef);
        ParameterizedType type = (ParameterizedType)kvTupleType.getType();
        Type[] types = type.getActualTypeArguments();
        return Tuple2.of(TypeRef.of(types[0]), TypeRef.of(types[1]));
    }

    static {
        try {
            SCALA_ITERABLE_TYPE = ReflectionUtils.loadClass("scala.collection.Iterable");
            SCALA_ITERATOR_TYPE = ReflectionUtils.loadClass("scala.collection.Iterator");
            SCALA_MAP_TYPE = ReflectionUtils.loadClass("scala.collection.Map");
            SCALA_SEQ_TYPE = ReflectionUtils.loadClass("scala.collection.Seq");
            SCALA_ITERATOR_RETURN_TYPE = SCALA_ITERABLE_TYPE.getMethod("iterator", new Class[0]).getGenericReturnType();
            SCALA_NEXT_RETURN_TYPE = SCALA_ITERATOR_TYPE.getMethod("next", new Class[0]).getGenericReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

