/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft.snapshot.vgroup;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.seata.server.cluster.raft.snapshot.RaftSnapshot;
import org.apache.seata.server.cluster.raft.snapshot.StoreSnapshotFile;
import org.apache.seata.server.session.SessionHolder;
import org.apache.seata.server.storage.raft.store.RaftVGroupMappingStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VGroupSnapshotFile
implements Serializable,
StoreSnapshotFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(VGroupSnapshotFile.class);
    public static final String ROOT_MAPPING_MANAGER_NAME = "vgroup_mapping";
    String group;

    public VGroupSnapshotFile(String group) {
        this.group = group;
    }

    public Status save(SnapshotWriter writer) {
        RaftSnapshot raftSnapshot = new RaftSnapshot();
        RaftVGroupMappingStoreManager raftVGroupMappingStoreManager = (RaftVGroupMappingStoreManager)SessionHolder.getRootVGroupMappingManager();
        Map map = raftVGroupMappingStoreManager.loadVGroupsByUnit(this.group);
        raftSnapshot.setBody((Object)map);
        raftSnapshot.setType(RaftSnapshot.SnapshotType.vgroup_mapping);
        String path = writer.getPath() + File.separator + ROOT_MAPPING_MANAGER_NAME;
        try {
            if (this.save(raftSnapshot, path)) {
                if (writer.addFile(ROOT_MAPPING_MANAGER_NAME)) {
                    return Status.OK();
                }
                return new Status(RaftError.EIO, "Fail to add file to writer", new Object[0]);
            }
        }
        catch (IOException e) {
            LOGGER.error("Fail to save groupId: {} snapshot {}", new Object[]{this.group, path, e});
        }
        return new Status(RaftError.EIO, "Fail to save groupId: " + this.group + " snapshot %s", new Object[]{path});
    }

    public boolean load(SnapshotReader reader) {
        if (reader.getFileMeta(ROOT_MAPPING_MANAGER_NAME) == null) {
            LOGGER.error("Fail to find data file in {}", (Object)reader.getPath());
            return false;
        }
        String path = reader.getPath() + File.separator + ROOT_MAPPING_MANAGER_NAME;
        try {
            Map map = (Map)this.load(path);
            RaftVGroupMappingStoreManager raftVGroupMappingStoreManager = (RaftVGroupMappingStoreManager)SessionHolder.getRootVGroupMappingManager();
            raftVGroupMappingStoreManager.clear(this.group);
            raftVGroupMappingStoreManager.localAddVGroups(map, this.group);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("fail to load snapshot from {}", (Object)path, (Object)e);
            return false;
        }
    }
}

