/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.filter;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.seata.common.store.SessionMode;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.exception.TransactionExceptionCode;
import org.apache.seata.server.cluster.listener.ClusterChangeEvent;
import org.apache.seata.server.cluster.raft.context.SeataClusterContext;
import org.apache.seata.server.console.exception.ConsoleException;
import org.apache.seata.server.filter.RaftCondition;
import org.apache.seata.server.store.StoreConfig;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Conditional(value={RaftCondition.class})
public class RaftRequestFilter
implements Filter,
ApplicationListener<ClusterChangeEvent> {
    private static final Map<String, Boolean> GROUP_PREVENT = new ConcurrentHashMap();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        String group = httpRequest.getParameter("unit");
        if (StringUtils.isBlank((String)group)) {
            group = httpRequest.getHeader("X-SEATA-RAFT-GROUP");
        }
        if (group != null) {
            SeataClusterContext.bindGroup((String)group);
        }
        try {
            String method = httpRequest.getMethod();
            if (!HttpMethod.GET.name().equalsIgnoreCase(method) && !this.isPass(group)) {
                throw new ConsoleException((Throwable)new TransactionException(TransactionExceptionCode.NotRaftLeader, " The current TC is not a leader node, interrupt processing of transactions!"), " The current TC is not a leader node, interrupt processing of transactions!");
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            SeataClusterContext.unbindGroup();
        }
    }

    public void onApplicationEvent(ClusterChangeEvent event) {
        RaftRequestFilter.setPrevent((String)event.getGroup(), (boolean)event.isLeader());
    }

    public void destroy() {
    }

    public static void setPrevent(String group, boolean prevent) {
        if (StoreConfig.getSessionMode() == SessionMode.RAFT) {
            GROUP_PREVENT.put(group, prevent);
        }
    }

    private boolean isPass(String group) {
        return Optional.ofNullable(GROUP_PREVENT.get(group)).orElse(false);
    }
}

