/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.db.store;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.seata.common.exception.DataAccessException;
import org.apache.seata.common.exception.StoreException;
import org.apache.seata.common.util.IOUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.store.BranchTransactionDO;
import org.apache.seata.core.store.GlobalTransactionDO;
import org.apache.seata.core.store.LogStore;
import org.apache.seata.core.store.db.sql.log.LogStoreSqlsFactory;
import org.apache.seata.server.storage.db.store.LogStoreDataBaseDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogStoreDataBaseDAO
implements LogStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogStoreDataBaseDAO.class);
    private static final String TRANSACTION_NAME_KEY = "TRANSACTION_NAME";
    private static final int TRANSACTION_NAME_DEFAULT_SIZE = 128;
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    protected DataSource logStoreDataSource = null;
    protected String globalTable;
    protected String branchTable;
    private String dbType;
    private int transactionNameColumnSize = 128;

    public LogStoreDataBaseDAO(DataSource logStoreDataSource) {
        this.logStoreDataSource = logStoreDataSource;
        this.globalTable = CONFIG.getConfig("store.db.globalTable", "global_table");
        this.branchTable = CONFIG.getConfig("store.db.branchTable", "branch_table");
        this.dbType = CONFIG.getConfig("store.db.dbType");
        if (StringUtils.isBlank((String)this.dbType)) {
            throw new StoreException("there must be db type.");
        }
        if (logStoreDataSource == null) {
            throw new StoreException("there must be logStoreDataSource.");
        }
        this.initTransactionNameSize();
    }

    public GlobalTransactionDO queryGlobalTransactionDO(String xid) {
        GlobalTransactionDO globalTransactionDO;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block5: {
            String sql = LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getQueryGlobalTransactionSQL(this.globalTable);
            conn = null;
            ps = null;
            rs = null;
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(1, xid);
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            GlobalTransactionDO globalTransactionDO2 = this.convertGlobalTransactionDO(rs);
            IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
            return globalTransactionDO2;
        }
        try {
            globalTransactionDO = null;
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
        return globalTransactionDO;
    }

    public GlobalTransactionDO queryGlobalTransactionDO(long transactionId) {
        GlobalTransactionDO globalTransactionDO;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block5: {
            String sql = LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getQueryGlobalTransactionSQLByTransactionId(this.globalTable);
            conn = null;
            ps = null;
            rs = null;
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setLong(1, transactionId);
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            GlobalTransactionDO globalTransactionDO2 = this.convertGlobalTransactionDO(rs);
            IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
            return globalTransactionDO2;
        }
        try {
            globalTransactionDO = null;
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
        return globalTransactionDO;
    }

    public List<GlobalTransactionDO> queryGlobalTransactionDO(int[] statuses, int limit) {
        ArrayList<GlobalTransactionDO> arrayList;
        ArrayList<GlobalTransactionDO> ret = new ArrayList<GlobalTransactionDO>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            String paramsPlaceHolder = org.apache.commons.lang.StringUtils.repeat((String)"?", (String)",", (int)statuses.length);
            String sql = LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getQueryGlobalTransactionSQLByStatus(this.globalTable, paramsPlaceHolder);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < statuses.length; ++i) {
                int status = statuses[i];
                ps.setInt(i + 1, status);
            }
            ps.setInt(statuses.length + 1, limit);
            if ("sqlserver".equalsIgnoreCase(this.dbType)) {
                ps.setInt(1, limit);
                ps.setInt(statuses.length + 1, statuses[0]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ret.add(this.convertGlobalTransactionDO(rs));
            }
            arrayList = ret;
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
        return arrayList;
    }

    public boolean insertGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        boolean bl;
        String sql = LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getInsertGlobalTransactionSQL(this.globalTable);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            int index = 1;
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(index++, globalTransactionDO.getXid());
            ps.setLong(index++, globalTransactionDO.getTransactionId());
            ps.setInt(index++, globalTransactionDO.getStatus());
            ps.setString(index++, globalTransactionDO.getApplicationId());
            ps.setString(index++, globalTransactionDO.getTransactionServiceGroup());
            String transactionName = globalTransactionDO.getTransactionName();
            transactionName = transactionName.length() > this.transactionNameColumnSize ? transactionName.substring(0, this.transactionNameColumnSize) : transactionName;
            ps.setString(index++, transactionName);
            ps.setInt(index++, globalTransactionDO.getTimeout());
            ps.setLong(index++, globalTransactionDO.getBeginTime());
            ps.setString(index++, globalTransactionDO.getApplicationData());
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return bl;
    }

    public boolean updateGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        boolean bl;
        String sql = LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getUpdateGlobalTransactionStatusSQL(this.globalTable);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            int index = 1;
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setInt(index++, globalTransactionDO.getStatus());
            ps.setString(index++, globalTransactionDO.getXid());
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return bl;
    }

    public boolean updateGlobalTransactionDO(GlobalTransactionDO globalTransactionDO, Integer expectedStatus) {
        boolean bl;
        String sql = LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getUpdateGlobalTransactionStatusByStatusSQL(this.globalTable);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setInt(1, globalTransactionDO.getStatus());
            ps.setString(2, globalTransactionDO.getXid());
            ps.setInt(3, expectedStatus);
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return bl;
    }

    public boolean deleteGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        String sql = LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getDeleteGlobalTransactionSQL(this.globalTable);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(1, globalTransactionDO.getXid());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return true;
    }

    public List<BranchTransactionDO> queryBranchTransactionDO(String xid) {
        ArrayList<BranchTransactionDO> arrayList;
        ArrayList<BranchTransactionDO> rets = new ArrayList<BranchTransactionDO>();
        String sql = LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getQueryBranchTransaction(this.branchTable);
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(1, xid);
            rs = ps.executeQuery();
            while (rs.next()) {
                rets.add(this.convertBranchTransactionDO(rs));
            }
            arrayList = rets;
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
        return arrayList;
    }

    public List<BranchTransactionDO> queryBranchTransactionDO(List<String> xids) {
        ArrayList<BranchTransactionDO> i2;
        int length = xids.size();
        ArrayList<BranchTransactionDO> rets = new ArrayList<BranchTransactionDO>(length * 3);
        String paramsPlaceHolder = org.apache.commons.lang.StringUtils.repeat((String)"?", (String)",", (int)length);
        String sql = LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getQueryBranchTransaction(this.branchTable, paramsPlaceHolder);
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            for (int i2 = 0; i2 < length; ++i2) {
                ps.setString(i2 + 1, xids.get(i2));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                rets.add(this.convertBranchTransactionDO(rs));
            }
            i2 = rets;
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
        return i2;
    }

    public boolean insertBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        boolean bl;
        String sql = LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getInsertBranchTransactionSQL(this.branchTable);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            int index = 1;
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(index++, branchTransactionDO.getXid());
            ps.setLong(index++, branchTransactionDO.getTransactionId());
            ps.setLong(index++, branchTransactionDO.getBranchId());
            ps.setString(index++, branchTransactionDO.getResourceGroupId());
            ps.setString(index++, branchTransactionDO.getResourceId());
            ps.setString(index++, branchTransactionDO.getBranchType());
            ps.setInt(index++, branchTransactionDO.getStatus());
            ps.setString(index++, branchTransactionDO.getClientId());
            ps.setString(index++, branchTransactionDO.getApplicationData());
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return bl;
    }

    public boolean updateBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        boolean bl;
        boolean shouldUpdateAppData = StringUtils.isNotBlank((String)branchTransactionDO.getApplicationData());
        String sql = shouldUpdateAppData ? LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getUpdateBranchTransactionStatusAppDataSQL(this.branchTable) : LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getUpdateBranchTransactionStatusSQL(this.branchTable);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            int index = 1;
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setInt(index++, branchTransactionDO.getStatus());
            if (shouldUpdateAppData) {
                ps.setString(index++, branchTransactionDO.getApplicationData());
            }
            ps.setString(index++, branchTransactionDO.getXid());
            ps.setLong(index++, branchTransactionDO.getBranchId());
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return bl;
    }

    public boolean deleteBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        String sql = LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getDeleteBranchTransactionByBranchIdSQL(this.branchTable);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setString(1, branchTransactionDO.getXid());
            ps.setLong(2, branchTransactionDO.getBranchId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return true;
    }

    public long getCurrentMaxSessionId(long high, long low) {
        String transMaxSql = LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getQueryGlobalMax(this.globalTable);
        String branchMaxSql = LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getQueryBranchMax(this.branchTable);
        long maxTransId = this.getCurrentMaxSessionId(transMaxSql, high, low);
        long maxBranchId = this.getCurrentMaxSessionId(branchMaxSql, high, low);
        return Math.max(maxBranchId, maxTransId);
    }

    private long getCurrentMaxSessionId(String sql, long high, long low) {
        long max = 0L;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int index = 1;
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            ps = conn.prepareStatement(sql);
            ps.setLong(index++, high);
            ps.setLong(index++, low);
            rs = ps.executeQuery();
            while (rs.next()) {
                max = rs.getLong(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
        return max;
    }

    private GlobalTransactionDO convertGlobalTransactionDO(ResultSet rs) throws SQLException {
        GlobalTransactionDO globalTransactionDO = new GlobalTransactionDO();
        globalTransactionDO.setXid(rs.getString("xid"));
        globalTransactionDO.setStatus(rs.getInt("status"));
        globalTransactionDO.setApplicationId(rs.getString("application_id"));
        globalTransactionDO.setBeginTime(rs.getLong("begin_time"));
        globalTransactionDO.setTimeout(rs.getInt("timeout"));
        globalTransactionDO.setTransactionId(rs.getLong("transaction_id"));
        globalTransactionDO.setTransactionName(rs.getString("transaction_name"));
        globalTransactionDO.setTransactionServiceGroup(rs.getString("transaction_service_group"));
        globalTransactionDO.setApplicationData(rs.getString("application_data"));
        globalTransactionDO.setGmtCreate((Date)rs.getTimestamp("gmt_create"));
        globalTransactionDO.setGmtModified((Date)rs.getTimestamp("gmt_modified"));
        return globalTransactionDO;
    }

    private BranchTransactionDO convertBranchTransactionDO(ResultSet rs) throws SQLException {
        BranchTransactionDO branchTransactionDO = new BranchTransactionDO();
        branchTransactionDO.setResourceGroupId(rs.getString("resource_group_id"));
        branchTransactionDO.setStatus(rs.getInt("status"));
        branchTransactionDO.setApplicationData(rs.getString("application_data"));
        branchTransactionDO.setClientId(rs.getString("client_id"));
        branchTransactionDO.setXid(rs.getString("xid"));
        branchTransactionDO.setResourceId(rs.getString("resource_id"));
        branchTransactionDO.setBranchId(rs.getLong("branch_id"));
        branchTransactionDO.setBranchType(rs.getString("branch_type"));
        branchTransactionDO.setTransactionId(rs.getLong("transaction_id"));
        branchTransactionDO.setGmtCreate((Date)rs.getTimestamp("gmt_create"));
        branchTransactionDO.setGmtModified((Date)rs.getTimestamp("gmt_modified"));
        return branchTransactionDO;
    }

    public void initTransactionNameSize() {
        ColumnInfo columnInfo = this.queryTableStructure(this.globalTable, TRANSACTION_NAME_KEY);
        if (columnInfo == null) {
            LOGGER.warn("{} table or {} column not found", (Object)this.globalTable, (Object)TRANSACTION_NAME_KEY);
            return;
        }
        this.transactionNameColumnSize = columnInfo.getColumnSize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ColumnInfo queryTableStructure(String tableName, String colName) {
        try (Connection conn = this.logStoreDataSource.getConnection();){
            ColumnInfo info;
            String columnName;
            String table;
            DatabaseMetaData dbmd = conn.getMetaData();
            String schema = this.getSchema(conn);
            ResultSet tableRs = dbmd.getTables(null, schema, "%", new String[]{"TABLE"});
            do {
                if (!tableRs.next()) return null;
            } while (!StringUtils.equalsIgnoreCase((String)(table = tableRs.getString("TABLE_NAME")), (String)tableName));
            ResultSet columnRs = conn.getMetaData().getColumns(null, schema, table, null);
            do {
                if (!columnRs.next()) return null;
                info = new ColumnInfo(null);
                columnName = columnRs.getString("COLUMN_NAME");
                info.setColumnName(columnName);
                String typeName = columnRs.getString("TYPE_NAME");
                info.setTypeName(typeName);
                int columnSize = columnRs.getInt("COLUMN_SIZE");
                info.setColumnSize(columnSize);
                String remarks = columnRs.getString("REMARKS");
                info.setRemarks(remarks);
            } while (!StringUtils.equalsIgnoreCase((String)columnName, (String)colName));
            ColumnInfo columnInfo = info;
            return columnInfo;
        }
        catch (SQLException e) {
            LOGGER.error("query transaction_name size fail, {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private String getSchema(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setLogStoreDataSource(DataSource logStoreDataSource) {
        this.logStoreDataSource = logStoreDataSource;
    }

    public void setGlobalTable(String globalTable) {
        this.globalTable = globalTable;
    }

    public void setBranchTable(String branchTable) {
        this.branchTable = branchTable;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public int getTransactionNameColumnSize() {
        return this.transactionNameColumnSize;
    }
}

