/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.file.store;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.store.MappingDO;
import org.apache.seata.server.store.VGroupMappingStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="file")
public class FileVGroupMappingStoreManager
implements VGroupMappingStoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileVGroupMappingStoreManager.class);
    public static final String ROOT_MAPPING_MANAGER_NAME = "vgroup_mapping.json";
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private String storePath;
    HashMap<String, Object> vGroupMapping = new HashMap();
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    ObjectMapper objectMapper = new ObjectMapper();

    public FileVGroupMappingStoreManager() {
    }

    public FileVGroupMappingStoreManager(String mappingStoreFilePath) {
        this.storePath = mappingStoreFilePath + File.separator + ROOT_MAPPING_MANAGER_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addVGroup(MappingDO mappingDO) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.vGroupMapping.put(mappingDO.getVGroup(), mappingDO.getUnit());
            boolean isSaved = this.save(this.vGroupMapping);
            if (!isSaved) {
                LOGGER.error("add mapping relationship failed!");
            }
            boolean bl = isSaved;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeVGroup(String vGroup) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.vGroupMapping.remove(vGroup);
            boolean isSaved = this.save(this.vGroupMapping);
            if (!isSaved) {
                LOGGER.error("remove mapping relationship failed!");
            }
            boolean bl = isSaved;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public Map<String, Object> readVGroups() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            HashMap hashMap = this.vGroupMapping;
            return hashMap;
        }
        finally {
            readLock.unlock();
        }
    }

    public Map<String, Object> loadVGroups() {
        try {
            String fileContent;
            File fileToLoad = new File(this.storePath);
            if (!fileToLoad.exists()) {
                FileUtils.writeStringToFile((File)fileToLoad, (String)"", (Charset)StandardCharsets.UTF_8);
            }
            if (!(fileContent = FileUtils.readFileToString((File)fileToLoad, (Charset)StandardCharsets.UTF_8)).isEmpty()) {
                this.vGroupMapping = (HashMap)this.objectMapper.readValue(fileContent, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("mapping relationship load failed", e);
        }
        return this.vGroupMapping;
    }

    public boolean save(HashMap<String, Object> vGroupMapping) {
        try {
            String jsonMapping = this.objectMapper.writeValueAsString(vGroupMapping);
            FileUtils.writeStringToFile((File)new File(this.storePath), (String)jsonMapping, (Charset)StandardCharsets.UTF_8);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("mapping relationship saved failed:{}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }
}

