/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelUtil.class);

    public static String getAddressFromChannel(Channel channel) {
        SocketAddress socketAddress = channel.remoteAddress();
        String address = socketAddress.toString();
        if (socketAddress.toString().indexOf("/") == 0) {
            address = socketAddress.toString().substring("/".length());
        }
        return address;
    }

    public static String getClientIpFromChannel(Channel channel) {
        String address = ChannelUtil.getAddressFromChannel(channel);
        String clientIp = address;
        if (clientIp.contains(":")) {
            clientIp = clientIp.substring(0, clientIp.lastIndexOf(":"));
        }
        return clientIp;
    }

    public static Integer getClientPortFromChannel(Channel channel) {
        String address = ChannelUtil.getAddressFromChannel(channel);
        Integer port = 0;
        try {
            if (address.contains(":")) {
                port = Integer.parseInt(address.substring(address.lastIndexOf(":") + 1));
            }
        }
        catch (NumberFormatException exx) {
            LOGGER.error(exx.getMessage());
        }
        return port;
    }
}

