/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty;

import io.netty.channel.Channel;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.NettyRuntime;
import io.netty.util.internal.PlatformDependent;
import org.apache.commons.lang.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.rpc.TransportProtocolType;
import org.apache.seata.core.rpc.TransportServerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyBaseConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyBaseConfig.class);
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    protected static final String BOSS_THREAD_PREFIX = CONFIG.getConfig("transport.threadFactory.bossThreadPrefix");
    protected static final String WORKER_THREAD_PREFIX = CONFIG.getConfig("transport.threadFactory.workerThreadPrefix");
    protected static final boolean SHARE_BOSS_WORKER = CONFIG.getBoolean("transport.threadFactory.shareBossWorker");
    protected static final int WORKER_THREAD_SIZE;
    protected static final TransportServerType TRANSPORT_SERVER_TYPE;
    protected static final Class<? extends ServerChannel> SERVER_CHANNEL_CLAZZ;
    protected static final Class<? extends Channel> CLIENT_CHANNEL_CLAZZ;
    protected static final TransportProtocolType TRANSPORT_PROTOCOL_TYPE;
    private static final int DEFAULT_WRITE_IDLE_SECONDS = 5;
    private static final int READIDLE_BASE_WRITEIDLE = 3;
    protected static final int MAX_WRITE_IDLE_SECONDS;
    protected static final int MAX_READ_IDLE_SECONDS;
    protected static final int MAX_ALL_IDLE_SECONDS = 0;

    private static void raiseUnsupportedTransportError() throws RuntimeException {
        String errMsg = String.format("Unsupported provider type :[%s] for transport:[%s].", new Object[]{TRANSPORT_SERVER_TYPE, TRANSPORT_PROTOCOL_TYPE});
        LOGGER.error(errMsg);
        throw new IllegalArgumentException(errMsg);
    }

    static {
        TRANSPORT_PROTOCOL_TYPE = TransportProtocolType.getType(CONFIG.getConfig("transport.type", TransportProtocolType.TCP.name()));
        String workerThreadSize = CONFIG.getConfig("transport.threadFactory.workerThreadSize");
        WORKER_THREAD_SIZE = StringUtils.isNotBlank((String)workerThreadSize) && StringUtils.isNumeric((String)workerThreadSize) ? Integer.parseInt(workerThreadSize) : (WorkThreadMode.getModeByName(workerThreadSize) != null ? WorkThreadMode.getModeByName(workerThreadSize).getValue() : WorkThreadMode.Default.getValue());
        TRANSPORT_SERVER_TYPE = TransportServerType.getType(CONFIG.getConfig("transport.server", TransportServerType.NIO.name()));
        switch (TRANSPORT_SERVER_TYPE) {
            case NIO: {
                if (TRANSPORT_PROTOCOL_TYPE == TransportProtocolType.TCP) {
                    SERVER_CHANNEL_CLAZZ = NioServerSocketChannel.class;
                    CLIENT_CHANNEL_CLAZZ = NioSocketChannel.class;
                    break;
                }
                NettyBaseConfig.raiseUnsupportedTransportError();
                SERVER_CHANNEL_CLAZZ = null;
                CLIENT_CHANNEL_CLAZZ = null;
                break;
            }
            case NATIVE: {
                if (PlatformDependent.isWindows()) {
                    throw new IllegalArgumentException("no native supporting for Windows.");
                }
                if (PlatformDependent.isOsx()) {
                    if (TRANSPORT_PROTOCOL_TYPE == TransportProtocolType.TCP) {
                        SERVER_CHANNEL_CLAZZ = KQueueServerSocketChannel.class;
                        CLIENT_CHANNEL_CLAZZ = KQueueSocketChannel.class;
                        break;
                    }
                    if (TRANSPORT_PROTOCOL_TYPE == TransportProtocolType.UNIX_DOMAIN_SOCKET) {
                        SERVER_CHANNEL_CLAZZ = KQueueServerDomainSocketChannel.class;
                        CLIENT_CHANNEL_CLAZZ = KQueueDomainSocketChannel.class;
                        break;
                    }
                    NettyBaseConfig.raiseUnsupportedTransportError();
                    SERVER_CHANNEL_CLAZZ = null;
                    CLIENT_CHANNEL_CLAZZ = null;
                    break;
                }
                if (TRANSPORT_PROTOCOL_TYPE == TransportProtocolType.TCP) {
                    SERVER_CHANNEL_CLAZZ = EpollServerSocketChannel.class;
                    CLIENT_CHANNEL_CLAZZ = EpollSocketChannel.class;
                    break;
                }
                if (TRANSPORT_PROTOCOL_TYPE == TransportProtocolType.UNIX_DOMAIN_SOCKET) {
                    SERVER_CHANNEL_CLAZZ = EpollServerDomainSocketChannel.class;
                    CLIENT_CHANNEL_CLAZZ = EpollDomainSocketChannel.class;
                    break;
                }
                NettyBaseConfig.raiseUnsupportedTransportError();
                SERVER_CHANNEL_CLAZZ = null;
                CLIENT_CHANNEL_CLAZZ = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported.");
            }
        }
        boolean enableHeartbeat = CONFIG.getBoolean("transport.heartbeat", true);
        MAX_WRITE_IDLE_SECONDS = enableHeartbeat ? 5 : 0;
        MAX_READ_IDLE_SECONDS = MAX_WRITE_IDLE_SECONDS * 3;
    }

    public static enum WorkThreadMode {
        Auto(NettyRuntime.availableProcessors() * 2 + 1),
        Pin(NettyRuntime.availableProcessors()),
        BusyPin(NettyRuntime.availableProcessors() + 1),
        Default(NettyRuntime.availableProcessors() * 2);

        private int value;

        public int getValue() {
            return this.value;
        }

        private WorkThreadMode(int value) {
            this.value = value;
        }

        public static WorkThreadMode getModeByName(String name) {
            for (WorkThreadMode mode : WorkThreadMode.values()) {
                if (!mode.name().equalsIgnoreCase(name)) continue;
                return mode;
            }
            return null;
        }
    }
}

