/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.processor.server;

import io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.seata.common.util.NetUtil;
import org.apache.seata.core.protocol.AbstractResultMessage;
import org.apache.seata.core.protocol.MessageFuture;
import org.apache.seata.core.protocol.RpcMessage;
import org.apache.seata.core.rpc.RpcContext;
import org.apache.seata.core.rpc.TransactionMessageHandler;
import org.apache.seata.core.rpc.netty.ChannelManager;
import org.apache.seata.core.rpc.processor.RemotingProcessor;
import org.apache.seata.core.rpc.processor.server.BatchLogHandler;
import org.apache.seata.core.rpc.processor.server.ServerOnRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerOnResponseProcessor
implements RemotingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerOnRequestProcessor.class);
    private TransactionMessageHandler transactionMessageHandler;
    private ConcurrentMap<Integer, MessageFuture> futures;

    public ServerOnResponseProcessor(TransactionMessageHandler transactionMessageHandler, ConcurrentHashMap<Integer, MessageFuture> futures) {
        this.transactionMessageHandler = transactionMessageHandler;
        this.futures = futures;
    }

    @Override
    public void process(ChannelHandlerContext ctx, RpcMessage rpcMessage) throws Exception {
        MessageFuture messageFuture = (MessageFuture)this.futures.remove(rpcMessage.getId());
        String receiveMsgLog = String.format("receive msg[single]: %s, clientIp: %s, vgroup: %s", rpcMessage.getBody(), NetUtil.toIpAddress((SocketAddress)ctx.channel().remoteAddress()), ChannelManager.getContextFromIdentified(ctx.channel()).getTransactionServiceGroup());
        if (LOGGER.isInfoEnabled()) {
            BatchLogHandler.INSTANCE.writeLog(receiveMsgLog);
        }
        if (messageFuture != null) {
            messageFuture.setResultMessage(rpcMessage.getBody());
        } else if (ChannelManager.isRegistered(ctx.channel())) {
            this.onResponseMessage(ctx, rpcMessage);
        } else {
            try {
                ctx.disconnect();
                ctx.close();
            }
            catch (Exception exx) {
                LOGGER.error(exx.getMessage());
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("close a unhandled connection! [%s]", ctx.channel().toString()));
            }
        }
    }

    private void onResponseMessage(ChannelHandlerContext ctx, RpcMessage rpcMessage) {
        if (rpcMessage.getBody() instanceof AbstractResultMessage) {
            RpcContext rpcContext = ChannelManager.getContextFromIdentified(ctx.channel());
            this.transactionMessageHandler.onResponse((AbstractResultMessage)rpcMessage.getBody(), rpcContext);
        }
    }
}

