/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.desc.AbstractLob$LobCtl;
import dm.jdbc.desc.Column;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.filter.Filterable;
import dm.jdbc.util.ByteUtil;
import java.io.Serializable;

public abstract class AbstractLob
extends Filterable
implements Serializable {
    public static final byte LOB_FLAG_BYTE = 0;
    public static final byte LOB_FLAG_CHAR = 1;
    public static final byte STORAGE_IN_ROW = 1;
    public static final byte STORAGE_OUT_ROW = 2;
    public static final byte STORAGE_LONG_ROW = 4;
    public static final int NBLOB_HEAD_SIZE_INROW = 13;
    public static final int NBLOB_HEAD_SIZE_OUTROW = 21;
    public static final int NBLOB_HEAD_SIZE_EX = 43;
    public static final int NBLOB_HEAD_SIZE_EX_ROWID_12B = 47;
    public long id;
    public int storageType = 0;
    public int groupId = -1;
    public int fileId = -1;
    public int pageNo = -1;
    public int tabId;
    public int colId;
    public byte[] rowId;
    public int curFileId;
    public int curPageNo;
    public int curOffset;
    public long totalOffset;
    public boolean readOver = false;
    public DmdbConnection connection;
    public boolean local = true;
    public boolean updateable = true;
    public byte lobFlag;
    public long bytesLength = -1L;
    public long length = -1L;
    public boolean compatibleOracle = false;
    public boolean fetchAll = false;
    public boolean freed = false;
    public boolean modify = false;
    public boolean empty = false;

    public AbstractLob(byte[] byArray, byte by, DmdbConnection dmdbConnection, Column column) {
        this(by, dmdbConnection);
        this.lobFlag = by;
        this.compatibleOracle = dmdbConnection.compatibleOracle();
        this.local = false;
        this.updateable = !column.readonly;
        this.tabId = column.lobTabId;
        this.colId = column.lobColId;
        int n2 = 0;
        this.storageType = ByteUtil.getByte(byArray, n2);
        this.id = ByteUtil.getLong(byArray, ++n2);
        this.bytesLength = ByteUtil.getUB4(byArray, n2 += 8);
        if ((n2 += 4) == byArray.length) {
            return;
        }
        this.groupId = ByteUtil.getUB2(byArray, n2);
        this.fileId = ByteUtil.getUB2(byArray, n2 += 2);
        this.pageNo = ByteUtil.getInt(byArray, n2 += 2);
        this.curFileId = this.fileId;
        this.curPageNo = this.pageNo;
        this.curOffset = 0;
        this.totalOffset = 0L;
        if ((n2 += 4) == byArray.length) {
            return;
        }
        this.tabId = ByteUtil.getInt(byArray, n2);
        this.colId = ByteUtil.getUB2(byArray, n2 += 4);
        n2 += 2;
        if (this.connection.msgVersion < 9) {
            this.rowId = ByteUtil.getBytes(byArray, n2, 8);
            n2 += 8;
        } else {
            this.rowId = ByteUtil.getBytes(byArray, n2, 12);
            n2 += 12;
        }
        if (n2 == byArray.length) {
            return;
        }
        if (this.storageType == 4) {
            this.bytesLength = ByteUtil.getLong(byArray, n2);
            n2 += 8;
        }
    }

    public AbstractLob(byte by, DmdbConnection dmdbConnection) {
        super(dmdbConnection, null);
        this.connection = dmdbConnection;
        this.lobFlag = by;
    }

    protected abstract void loadAllData();

    public long do_length() {
        this.checkFreed();
        if (this.length == -1L) {
            this.connection.checkClosed();
            this.length = this.connection.dbAccess.a(this);
        }
        return this.length;
    }

    public void do_free() {
        this.connection = null;
        this.freed = true;
    }

    public void checkFreed() {
        if (this.freed) {
            DBError.ECJDBC_LOB_FREED.throwz(new Object[0]);
        }
    }

    protected void checkConnection() {
        if (this.connection == null) {
            DBError.ECJDBC_LOB_FREED.throwz(new Object[0]);
        }
    }

    public boolean canOptimized(DmdbConnection dmdbConnection) {
        return dmdbConnection.lobOptimized && dmdbConnection == this.connection && this.storageType != 1 && !this.fetchAll && !this.local && !this.modify;
    }

    public AbstractLob$LobCtl buildCtlData() {
        return new AbstractLob$LobCtl(this);
    }

    public int getHeadSize() {
        if (!this.connection.newLobFlag) {
            return this.storageType == 1 ? 13 : 21;
        }
        if (this.connection.msgVersion < 9) {
            return 43;
        }
        return 47;
    }
}

