/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.loggingevent.LogstashMarkersJsonProvider;
import net.logstash.logback.fieldnames.LogstashFieldNames;
import org.slf4j.Marker;

public class TagsJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    public static final String FIELD_TAGS = "tags";

    public TagsJsonProvider() {
        this.setFieldName(FIELD_TAGS);
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        boolean hasWrittenStart = false;
        Marker marker = event.getMarker();
        if (marker != null) {
            hasWrittenStart = this.writeTagIfNecessary(generator, hasWrittenStart, marker);
        }
        if (hasWrittenStart) {
            generator.writeEndArray();
        }
    }

    private boolean writeTagIfNecessary(JsonGenerator generator, boolean hasWrittenStart, Marker marker) throws IOException {
        if (!marker.getName().equals("JSON") && !LogstashMarkersJsonProvider.isLogstashMarker(marker)) {
            if (!hasWrittenStart) {
                generator.writeArrayFieldStart(this.getFieldName());
                hasWrittenStart = true;
            }
            generator.writeString(marker.getName());
        }
        if (marker.hasReferences()) {
            for (Marker next : marker) {
                hasWrittenStart |= this.writeTagIfNecessary(generator, hasWrittenStart, next);
            }
        }
        return hasWrittenStart;
    }

    @Override
    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getTags());
    }
}

