/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.compressor.zstd;

import com.github.luben.zstd.Zstd;

public class ZstdUtil {
    public static final int MAX_COMPRESSED_SIZE = 0x400000;

    public static byte[] compress(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is null");
        }
        return Zstd.compress((byte[])bytes);
    }

    public static byte[] decompress(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is null");
        }
        long size = Zstd.decompressedSize((byte[])bytes);
        if (size < 0L || size > 0x400000L) {
            throw new IllegalArgumentException("Invalid decompressed size: " + size + ", the value of size ranges from 0 to " + 0x400000);
        }
        byte[] decompressBytes = new byte[(int)size];
        Zstd.decompress((byte[])decompressBytes, (byte[])bytes);
        return decompressBytes;
    }
}

