/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http;

import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.HttpClientFactory;
import com.alibaba.nacos.common.http.client.NacosAsyncRestTemplate;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.client.request.DefaultAsyncHttpClientRequest;
import com.alibaba.nacos.common.http.client.request.JdkHttpClientRequest;
import com.alibaba.nacos.common.tls.SelfHostnameVerifier;
import com.alibaba.nacos.common.tls.TlsFileWatcher;
import com.alibaba.nacos.common.tls.TlsHelper;
import com.alibaba.nacos.common.tls.TlsSystemConfig;
import com.alibaba.nacos.common.utils.BiConsumer;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.protocol.RequestContent;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;

public abstract class AbstractHttpClientFactory
implements HttpClientFactory {
    @Override
    public NacosRestTemplate createNacosRestTemplate() {
        HttpClientConfig httpClientConfig = this.buildHttpClientConfig();
        final JdkHttpClientRequest clientRequest = new JdkHttpClientRequest(httpClientConfig);
        this.initTls(new BiConsumer<SSLContext, HostnameVerifier>(){

            @Override
            public void accept(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
                clientRequest.setSSLContext(AbstractHttpClientFactory.this.loadSSLContext());
                clientRequest.replaceSSLHostnameVerifier(hostnameVerifier);
            }
        }, new TlsFileWatcher.FileChangeListener(){

            @Override
            public void onChanged(String filePath) {
                clientRequest.setSSLContext(AbstractHttpClientFactory.this.loadSSLContext());
            }
        });
        return new NacosRestTemplate(this.assignLogger(), clientRequest);
    }

    @Override
    public NacosAsyncRestTemplate createNacosAsyncRestTemplate() {
        HttpClientConfig originalRequestConfig = this.buildHttpClientConfig();
        DefaultConnectingIOReactor ioreactor = this.getIoReactor();
        RequestConfig defaultConfig = this.getRequestConfig();
        return new NacosAsyncRestTemplate(this.assignLogger(), new DefaultAsyncHttpClientRequest(HttpAsyncClients.custom().addInterceptorLast((HttpRequestInterceptor)new RequestContent(true)).setDefaultIOReactorConfig(this.getIoReactorConfig()).setDefaultRequestConfig(defaultConfig).setMaxConnTotal(originalRequestConfig.getMaxConnTotal()).setMaxConnPerRoute(originalRequestConfig.getMaxConnPerRoute()).setUserAgent(originalRequestConfig.getUserAgent()).setConnectionManager(this.getConnectionManager(originalRequestConfig, ioreactor)).build(), ioreactor, defaultConfig));
    }

    private DefaultConnectingIOReactor getIoReactor() {
        DefaultConnectingIOReactor ioreactor;
        try {
            ioreactor = new DefaultConnectingIOReactor(this.getIoReactorConfig());
        }
        catch (IOReactorException e) {
            this.assignLogger().error("[NHttpClientConnectionManager] Create DefaultConnectingIOReactor failed", (Throwable)e);
            throw new IllegalStateException();
        }
        ioreactor.setExceptionHandler(new IOReactorExceptionHandler(){

            public boolean handle(IOException ex) {
                AbstractHttpClientFactory.this.assignLogger().warn("[NHttpClientConnectionManager] handle IOException, ignore it.", (Throwable)ex);
                return true;
            }

            public boolean handle(RuntimeException ex) {
                AbstractHttpClientFactory.this.assignLogger().warn("[NHttpClientConnectionManager] handle RuntimeException, ignore it.", (Throwable)ex);
                return true;
            }
        });
        return ioreactor;
    }

    private NHttpClientConnectionManager getConnectionManager(HttpClientConfig originalRequestConfig, DefaultConnectingIOReactor ioreactor) {
        int maxPerRoute;
        SSLContext sslcontext = SSLContexts.createDefault();
        DefaultHostnameVerifier hostnameVerifier = new DefaultHostnameVerifier();
        SSLIOSessionStrategy sslStrategy = new SSLIOSessionStrategy(sslcontext, null, null, (HostnameVerifier)hostnameVerifier);
        Registry registry = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)sslStrategy).build();
        PoolingNHttpClientConnectionManager poolingmgr = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioreactor, registry);
        int maxTotal = originalRequestConfig.getMaxConnTotal();
        if (maxTotal > 0) {
            poolingmgr.setMaxTotal(maxTotal);
        }
        if ((maxPerRoute = originalRequestConfig.getMaxConnPerRoute()) > 0) {
            poolingmgr.setDefaultMaxPerRoute(maxPerRoute);
        }
        return poolingmgr;
    }

    protected IOReactorConfig getIoReactorConfig() {
        HttpClientConfig httpClientConfig = this.buildHttpClientConfig();
        return IOReactorConfig.custom().setIoThreadCount(httpClientConfig.getIoThreadCount()).build();
    }

    protected RequestConfig getRequestConfig() {
        HttpClientConfig httpClientConfig = this.buildHttpClientConfig();
        return RequestConfig.custom().setConnectTimeout(httpClientConfig.getConTimeOutMillis()).setSocketTimeout(httpClientConfig.getReadTimeOutMillis()).setConnectionRequestTimeout(httpClientConfig.getConnectionRequestTimeout()).setContentCompressionEnabled(httpClientConfig.getContentCompressionEnabled()).setMaxRedirects(httpClientConfig.getMaxRedirects()).build();
    }

    protected void initTls(BiConsumer<SSLContext, HostnameVerifier> initTlsBiFunc, TlsFileWatcher.FileChangeListener tlsChangeListener) {
        if (!TlsSystemConfig.tlsEnable) {
            return;
        }
        HostnameVerifier hv = HttpsURLConnection.getDefaultHostnameVerifier();
        SelfHostnameVerifier selfHostnameVerifier = new SelfHostnameVerifier(hv);
        initTlsBiFunc.accept(this.loadSSLContext(), selfHostnameVerifier);
        if (tlsChangeListener != null) {
            try {
                TlsFileWatcher.getInstance().addFileChangeListener(tlsChangeListener, TlsSystemConfig.tlsClientTrustCertPath, TlsSystemConfig.tlsClientKeyPath);
            }
            catch (IOException e) {
                this.assignLogger().error("add tls file listener fail", (Throwable)e);
            }
        }
    }

    protected synchronized SSLContext loadSSLContext() {
        if (!TlsSystemConfig.tlsEnable) {
            return null;
        }
        try {
            return TlsHelper.buildSslContext(true);
        }
        catch (NoSuchAlgorithmException e) {
            this.assignLogger().error("Failed to create SSLContext", (Throwable)e);
        }
        catch (KeyManagementException e) {
            this.assignLogger().error("Failed to create SSLContext", (Throwable)e);
        }
        return null;
    }

    protected abstract HttpClientConfig buildHttpClientConfig();

    protected abstract Logger assignLogger();
}

