/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor;

import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.NodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.NodePostProcessorStateCommonOperations;
import org.apache.wiki.markdown.nodes.JSPWikiLink;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.variables.VariableManager;

public class MetadataLinkNodePostProcessorState
implements NodePostProcessorState<JSPWikiLink> {
    private static final Logger LOG = LogManager.getLogger(MetadataLinkNodePostProcessorState.class);
    private final Context wikiContext;
    private final boolean m_wysiwygEditorMode;

    public MetadataLinkNodePostProcessorState(Context wikiContext) {
        this.wikiContext = wikiContext;
        Boolean wysiwygVariable = (Boolean)wikiContext.getVariable("WYSIWYG_EDITOR_MODE");
        this.m_wysiwygEditorMode = wysiwygVariable != null ? wysiwygVariable : false;
    }

    @Override
    public void process(NodeTracker state, JSPWikiLink link) {
        String metadataLine = NodePostProcessorStateCommonOperations.inlineLinkTextOnWysiwyg(state, link, this.m_wysiwygEditorMode);
        try {
            String args = metadataLine.substring(metadataLine.indexOf(32), metadataLine.length() - 1);
            String name = args.substring(0, args.indexOf(61));
            String val = args.substring(args.indexOf(61) + 1);
            name = name.trim();
            val = val.trim();
            if (val.startsWith("'")) {
                val = val.substring(1);
            }
            if (val.endsWith("'")) {
                val = val.substring(0, val.length() - 1);
            }
            LOG.debug("page=" + this.wikiContext.getRealPage().getName() + " SET name='" + name + "', value='" + val + "'");
            if (!name.isEmpty() && !val.isEmpty()) {
                val = ((VariableManager)this.wikiContext.getEngine().getManager(VariableManager.class)).expandVariables(this.wikiContext, val);
                this.wikiContext.getPage().setAttribute(name, (Object)val);
                link.unlink();
                state.nodeRemoved((Node)link);
            }
        }
        catch (Exception e) {
            ResourceBundle rb = Preferences.getBundle((Context)this.wikiContext, (String)"CoreResources");
            NodePostProcessorStateCommonOperations.makeError(state, (Node)link, MessageFormat.format(rb.getString("markupparser.error.invalidset"), metadataLine));
        }
    }
}

