/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.io.IOException;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRecursionException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.json.JsonSchemaSerializer;
import org.apache.juneau.json.JsonSerializerSession;
import org.apache.juneau.jsonschema.JsonSchemaBeanPropertyMeta;
import org.apache.juneau.jsonschema.JsonSchemaClassMeta;
import org.apache.juneau.jsonschema.JsonSchemaGeneratorSession;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;

public class JsonSchemaSerializerSession
extends JsonSerializerSession {
    private final JsonSchemaGeneratorSession genSession;
    private final JsonSchemaSerializer ctx;

    protected JsonSchemaSerializerSession(JsonSchemaSerializer ctx, SerializerSessionArgs args) {
        super(ctx, args);
        this.genSession = ctx.getGenerator().createSession(args);
        this.ctx = ctx;
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws IOException, SerializeException {
        try {
            super.doSerialize(out, this.genSession.getSchema(o));
        }
        catch (BeanRecursionException e) {
            throw new SerializeException(e);
        }
    }

    protected JsonSchemaClassMeta getJsonSchemaClassMeta(ClassMeta<?> cm) {
        return this.ctx.getJsonSchemaClassMeta(cm);
    }

    protected JsonSchemaBeanPropertyMeta getJsonSchemaBeanPropertyMeta(BeanPropertyMeta bpm) {
        return this.ctx.getJsonSchemaBeanPropertyMeta(bpm);
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append("JsonSchemaSerializerSession", new DefaultFilteringObjectMap());
    }
}

