/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanMetaFiltered;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.annotation.Swap;
import org.apache.juneau.annotation.Uri;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.DelegateList;
import org.apache.juneau.internal.FilteredMap;
import org.apache.juneau.internal.Flag;
import org.apache.juneau.internal.HashCode;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.swap.Surrogate;
import org.apache.juneau.swaps.StringFormatSwap;

public final class BeanPropertyMeta
implements Comparable<BeanPropertyMeta> {
    final BeanMeta<?> beanMeta;
    private final BeanContext beanContext;
    private final String name;
    private final Field field;
    private final Field innerField;
    private final Method getter;
    private final Method setter;
    private final Method extraKeys;
    private final boolean isUri;
    private final boolean isDyna;
    private final boolean isDynaGetterMap;
    private final ClassMeta<?> rawTypeMeta;
    private final ClassMeta<?> typeMeta;
    private final String[] properties;
    private final ObjectSwap swap;
    private final BeanRegistry beanRegistry;
    private final Object overrideValue;
    private final BeanPropertyMeta delegateFor;
    private final boolean canRead;
    private final boolean canWrite;
    private final boolean readOnly;
    private final boolean writeOnly;
    private final int hashCode;

    public static Builder builder(BeanMeta<?> beanMeta, String name) {
        return new Builder(beanMeta, name);
    }

    protected BeanPropertyMeta(Builder b) {
        this.field = b.field;
        this.innerField = b.innerField;
        this.getter = b.getter;
        this.setter = b.setter;
        this.extraKeys = b.extraKeys;
        this.isUri = b.isUri;
        this.beanMeta = b.beanMeta;
        this.beanContext = b.beanContext;
        this.name = b.name;
        this.rawTypeMeta = b.rawTypeMeta;
        this.typeMeta = b.typeMeta;
        this.properties = b.properties;
        this.swap = b.swap;
        this.beanRegistry = b.beanRegistry;
        this.overrideValue = b.overrideValue;
        this.delegateFor = b.delegateFor;
        this.isDyna = b.isDyna;
        this.isDynaGetterMap = b.isDynaGetterMap;
        this.canRead = b.canRead;
        this.canWrite = b.canWrite;
        this.readOnly = b.readOnly;
        this.writeOnly = b.writeOnly;
        this.hashCode = HashCode.of(this.beanMeta, this.name);
    }

    public String getName() {
        return this.name;
    }

    public BeanMeta<?> getBeanMeta() {
        return this.beanMeta;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public Field getField() {
        return this.field;
    }

    public Field getInnerField() {
        return this.innerField;
    }

    public ClassMeta<?> getClassMeta() {
        return this.typeMeta;
    }

    public BeanRegistry getBeanRegistry() {
        return this.beanRegistry;
    }

    public boolean isUri() {
        return this.isUri;
    }

    public boolean isDyna() {
        return this.isDyna;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public BeanPropertyMeta getDelegateFor() {
        return this.delegateFor != null ? this.delegateFor : this;
    }

    public Object get(BeanMap<?> m, String pName) {
        return m.meta.onReadProperty(m.bean, pName, this.getInner(m, pName));
    }

    private Object getInner(BeanMap<?> m, String pName) {
        try {
            if (this.writeOnly) {
                return null;
            }
            if (this.overrideValue != null) {
                return this.overrideValue;
            }
            Object bean = m.bean;
            if (bean == null) {
                return m.propertyCache.get(this.name);
            }
            return this.toSerializedForm(m.getBeanSession(), this.getRaw(m, pName));
        }
        catch (Throwable e) {
            if (this.beanContext.isIgnoreInvocationExceptionsOnGetters()) {
                if (this.rawTypeMeta.isPrimitive()) {
                    return this.rawTypeMeta.getPrimitiveDefault();
                }
                return null;
            }
            throw new BeanRuntimeException(e, this.beanMeta.c, "Exception occurred while getting property ''{0}''", this.name);
        }
    }

    public Object getRaw(BeanMap<?> m, String pName) {
        try {
            Object bean = m.bean;
            if (bean == null) {
                return m.propertyCache.get(this.name);
            }
            return this.invokeGetter(bean, pName);
        }
        catch (Throwable e) {
            if (this.beanContext.isIgnoreInvocationExceptionsOnGetters()) {
                if (this.rawTypeMeta.isPrimitive()) {
                    return this.rawTypeMeta.getPrimitiveDefault();
                }
                return null;
            }
            throw new BeanRuntimeException(e, this.beanMeta.c, "Exception occurred while getting property ''{0}''", this.name);
        }
    }

    Object toSerializedForm(BeanSession session, Object o) {
        try {
            o = this.transform(session, o);
            if (o == null) {
                return null;
            }
            if (this.properties != null) {
                if (this.rawTypeMeta.isArray()) {
                    Object[] a = (Object[])o;
                    DelegateList l = new DelegateList(this.rawTypeMeta);
                    ClassMeta<?> childType = this.rawTypeMeta.getElementType();
                    for (Object c : a) {
                        l.add(this.applyChildPropertiesFilter(session, childType, c));
                    }
                    return l;
                }
                if (this.rawTypeMeta.isCollection()) {
                    Collection c = (Collection)o;
                    ArrayList l = CollectionUtils.list(c.size());
                    ClassMeta<?> childType = this.rawTypeMeta.getElementType();
                    c.forEach(x -> l.add(this.applyChildPropertiesFilter(session, childType, x)));
                    return l;
                }
                return this.applyChildPropertiesFilter(session, this.rawTypeMeta, o);
            }
            return o;
        }
        catch (SerializeException e) {
            throw new BeanRuntimeException(e);
        }
    }

    public Object set(BeanMap<?> m, String pName, Object value) throws BeanRuntimeException {
        return this.setInner(m, pName, m.meta.onWriteProperty(m.bean, pName, value));
    }

    private Object setInner(BeanMap<?> m, String pName, Object value) throws BeanRuntimeException {
        try {
            if (this.readOnly) {
                return null;
            }
            BeanSession session = m.getBeanSession();
            value = this.unswap(session, value);
            if (m.bean == null) {
                if (m.propertyCache != null) {
                    return m.propertyCache.put(this.name, value);
                }
                throw new BeanRuntimeException("Non-existent bean instance on bean.");
            }
            boolean isMap = this.rawTypeMeta.isMap();
            boolean isCollection = this.rawTypeMeta.isCollection();
            if (!(this.isDyna || this.field != null || this.setter != null || isMap || isCollection)) {
                if (value == null && this.beanContext.isIgnoreUnknownNullBeanProperties() || this.beanContext.isIgnoreMissingSetters()) {
                    return null;
                }
                throw new BeanRuntimeException(this.beanMeta.c, "Setter or public field not defined on property ''{0}''", this.name);
            }
            Object bean = m.getBean(true);
            try {
                Class<?> vc;
                Object r = !(!this.beanContext.isBeanMapPutReturnsOldValue() && !isMap && !isCollection || this.getter == null && this.field == null) ? this.get(m, pName) : null;
                Class<?> propertyClass = this.rawTypeMeta.getInnerClass();
                ClassInfo pcInfo = this.rawTypeMeta.getInfo();
                if (value == null && (isMap || isCollection)) {
                    this.invokeSetter(bean, pName, null);
                    return r;
                }
                Class<?> clazz = vc = value == null ? null : value.getClass();
                if (isMap && (this.setter == null || !pcInfo.isParentOf(vc))) {
                    if (!(value instanceof Map)) {
                        if (value instanceof CharSequence) {
                            value = JsonMap.ofJson((CharSequence)value).session(session);
                        } else {
                            throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}''", this.name, propertyClass.getName(), BeanPropertyMeta.findClassName(value));
                        }
                    }
                    Map valueMap = (Map)value;
                    Map propMap = (Map)r;
                    ClassMeta<?> valueType = this.rawTypeMeta.getValueType();
                    if (!this.rawTypeMeta.canCreateNewInstance()) {
                        if (propMap == null) {
                            if (this.setter == null && this.field == null) {
                                throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}'' because no setter or public field is defined, and the current value is null", this.name, propertyClass.getName(), BeanPropertyMeta.findClassName(value));
                            }
                            if (propertyClass.isInstance(valueMap)) {
                                if (!valueType.isObject()) {
                                    Flag needsConversion = Flag.create();
                                    valueMap.forEach((k, v) -> {
                                        if (v != null && !valueType.getInnerClass().isInstance(v)) {
                                            needsConversion.set();
                                        }
                                    });
                                    if (needsConversion.isSet()) {
                                        valueMap = (Map)session.convertToType((Object)valueMap, this.rawTypeMeta);
                                    }
                                }
                                this.invokeSetter(bean, pName, valueMap);
                                return r;
                            }
                            throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' of type ''{2}'' to object of type ''{2}'' because the assigned map cannot be converted to the specified type because the property type is abstract, and the property value is currently null", this.name, propertyClass.getName(), BeanPropertyMeta.findClassName(value));
                        }
                    } else if (propMap == null) {
                        propMap = BeanCreator.of(Map.class).type(propertyClass).run();
                    } else {
                        propMap.clear();
                    }
                    Map propMap2 = propMap;
                    valueMap.forEach((k, v) -> {
                        if (!valueType.isObject()) {
                            v = session.convertToType(v, valueType);
                        }
                        propMap2.put(k, v);
                    });
                    if (this.setter != null || this.field != null) {
                        this.invokeSetter(bean, pName, propMap);
                    }
                } else if (isCollection && (this.setter == null || !pcInfo.isParentOf(vc))) {
                    if (!(value instanceof Collection)) {
                        if (value instanceof CharSequence) {
                            value = new JsonList((CharSequence)value).setBeanSession(session);
                        } else {
                            throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}''", this.name, propertyClass.getName(), BeanPropertyMeta.findClassName(value));
                        }
                    }
                    Collection valueList = (Collection)value;
                    Collection propList = (Collection)r;
                    ClassMeta<?> elementType = this.rawTypeMeta.getElementType();
                    if (!this.rawTypeMeta.canCreateNewInstance()) {
                        if (propList == null) {
                            if (this.setter == null && this.field == null) {
                                throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}'' because no setter or public field is defined, and the current value is null", this.name, propertyClass.getName(), BeanPropertyMeta.findClassName(value));
                            }
                            if (propertyClass.isInstance(valueList) || this.setter != null && this.setter.getParameterTypes()[0] == Collection.class) {
                                if (!elementType.isObject()) {
                                    JsonList l = new JsonList((Collection<?>)valueList);
                                    ListIterator<?> i = l.listIterator();
                                    while (i.hasNext()) {
                                        Object v2 = i.next();
                                        if (v2 == null || elementType.getInnerClass().isInstance(v2)) continue;
                                        i.set(session.convertToType(v2, elementType));
                                    }
                                    valueList = l;
                                }
                                this.invokeSetter(bean, pName, valueList);
                                return r;
                            }
                            throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}'' because the assigned map cannot be converted to the specified type because the property type is abstract, and the property value is currently null", this.name, propertyClass.getName(), BeanPropertyMeta.findClassName(value));
                        }
                        propList.clear();
                    } else if (propList == null) {
                        propList = BeanCreator.of(Collection.class).type(propertyClass).run();
                        this.invokeSetter(bean, pName, propList);
                    } else {
                        propList.clear();
                    }
                    Collection propList2 = propList;
                    valueList.forEach(x -> {
                        if (!elementType.isObject()) {
                            x = session.convertToType(x, elementType);
                        }
                        propList2.add(x);
                    });
                } else {
                    value = this.swap != null && value != null && this.swap.getSwapClass().isParentOf(value.getClass()) ? this.swap.unswap(session, value, this.rawTypeMeta) : session.convertToType(value, this.rawTypeMeta);
                    this.invokeSetter(bean, pName, value);
                }
                return r;
            }
            catch (BeanRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.beanContext.isIgnoreInvocationExceptionsOnSetters()) {
                    if (this.rawTypeMeta.isPrimitive()) {
                        return this.rawTypeMeta.getPrimitiveDefault();
                    }
                    return null;
                }
                throw new BeanRuntimeException((Throwable)e, this.beanMeta.c, "Error occurred trying to set property ''{0}''", this.name);
            }
        }
        catch (ParseException e) {
            throw new BeanRuntimeException(e);
        }
    }

    private Object invokeGetter(Object bean, String pName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.isDyna) {
            Map m = null;
            if (this.getter != null) {
                if (!this.isDynaGetterMap) {
                    return this.getter.invoke(bean, pName);
                }
                m = (Map)this.getter.invoke(bean, new Object[0]);
            } else if (this.field != null) {
                m = (Map)this.field.get(bean);
            } else {
                throw new BeanRuntimeException(this.beanMeta.c, "Getter or public field not defined on property ''{0}''", this.name);
            }
            return m == null ? null : m.get(pName);
        }
        if (this.getter != null) {
            return this.getter.invoke(bean, new Object[0]);
        }
        if (this.field != null) {
            return this.field.get(bean);
        }
        throw new BeanRuntimeException(this.beanMeta.c, "Getter or public field not defined on property ''{0}''", this.name);
    }

    private Object invokeSetter(Object bean, String pName, Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.isDyna) {
            if (this.setter != null) {
                return this.setter.invoke(bean, pName, val);
            }
            Map m = null;
            if (this.field != null) {
                m = (Map)this.field.get(bean);
            } else if (this.getter != null) {
                m = (Map)this.getter.invoke(bean, new Object[0]);
            } else {
                throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}'' because no setter is defined on this property, and the existing property value is null", this.name, this.getClassMeta().getInnerClass().getName(), BeanPropertyMeta.findClassName(val));
            }
            return m == null ? null : m.put(pName, val);
        }
        if (this.setter != null) {
            return this.setter.invoke(bean, val);
        }
        if (this.field != null) {
            this.field.set(bean, val);
            return null;
        }
        throw new BeanRuntimeException(this.beanMeta.c, "Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}'' because no setter is defined on this property, and the existing property value is null", this.name, this.getClassMeta().getInnerClass().getName(), BeanPropertyMeta.findClassName(val));
    }

    public Map<String, Object> getDynaMap(Object bean) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.isDyna) {
            if (this.extraKeys != null && this.getter != null && !this.isDynaGetterMap) {
                LinkedHashMap<String, Object> m = CollectionUtils.map();
                ((Collection)this.extraKeys.invoke(bean, new Object[0])).forEach(x -> ThrowableUtils.safeRun(() -> m.put((String)x, this.getter.invoke(bean, x))));
                return m;
            }
            if (this.getter != null && this.isDynaGetterMap) {
                return (Map)this.getter.invoke(bean, new Object[0]);
            }
            if (this.field != null) {
                return (Map)this.field.get(bean);
            }
            throw new BeanRuntimeException(this.beanMeta.c, "Getter or public field not defined on property ''{0}''", this.name);
        }
        return Collections.EMPTY_MAP;
    }

    protected void setArray(Object bean, List l) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object array = ArrayUtils.toArray(l, this.rawTypeMeta.getElementType().getInnerClass());
        this.invokeSetter(bean, this.name, array);
    }

    public void add(BeanMap<?> m, String pName, Object value) throws BeanRuntimeException {
        if (m.bean == null) {
            if (!m.propertyCache.containsKey(this.name)) {
                m.propertyCache.put(this.name, new JsonList(m.getBeanSession()));
            }
            ((JsonList)m.propertyCache.get(this.name)).add(value);
            return;
        }
        BeanSession session = m.getBeanSession();
        boolean isCollection = this.rawTypeMeta.isCollection();
        boolean isArray = this.rawTypeMeta.isArray();
        if (!isCollection && !isArray) {
            throw new BeanRuntimeException(this.beanMeta.c, "Attempt to add element to property ''{0}'' which is not a collection or array", this.name);
        }
        Object bean = m.getBean(true);
        ClassMeta<?> elementType = this.rawTypeMeta.getElementType();
        try {
            Object v = session.convertToType(value, elementType);
            if (isCollection) {
                Collection c = (Collection)this.invokeGetter(bean, pName);
                if (c != null) {
                    c.add(v);
                    return;
                }
                c = this.rawTypeMeta.canCreateNewInstance() ? (Collection)this.rawTypeMeta.newInstance() : new JsonList(session);
                c.add(v);
                this.invokeSetter(bean, pName, c);
            } else {
                List<?> l;
                if (m.arrayPropertyCache == null) {
                    m.arrayPropertyCache = new TreeMap();
                }
                if ((l = m.arrayPropertyCache.get(this.name)) == null) {
                    l = new LinkedList();
                    m.arrayPropertyCache.put(this.name, l);
                    Object oldArray = this.invokeGetter(bean, pName);
                    ArrayUtils.copyToList(oldArray, l);
                }
                l.add(v);
            }
        }
        catch (BeanRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanRuntimeException(e);
        }
    }

    public void add(BeanMap<?> m, String pName, String key, Object value) throws BeanRuntimeException {
        if (m.bean == null) {
            if (!m.propertyCache.containsKey(this.name)) {
                m.propertyCache.put(this.name, new JsonMap(m.getBeanSession()));
            }
            ((JsonMap)m.propertyCache.get(this.name)).append(key.toString(), value);
            return;
        }
        BeanSession session = m.getBeanSession();
        boolean isMap = this.rawTypeMeta.isMap();
        boolean isBean = this.rawTypeMeta.isBean();
        if (!isBean && !isMap) {
            throw new BeanRuntimeException(this.beanMeta.c, "Attempt to add key/value to property ''{0}'' which is not a map or bean", this.name);
        }
        Object bean = m.getBean(true);
        ClassMeta<?> elementType = this.rawTypeMeta.getElementType();
        try {
            Object v = session.convertToType(value, elementType);
            if (isMap) {
                Map map = (Map)this.invokeGetter(bean, pName);
                if (map != null) {
                    map.put(key, v);
                    return;
                }
                map = this.rawTypeMeta.canCreateNewInstance() ? (Map)this.rawTypeMeta.newInstance() : new JsonMap(session);
                map.put(key, v);
                this.invokeSetter(bean, pName, map);
            } else {
                Object b = this.invokeGetter(bean, pName);
                if (b != null) {
                    BeanMap<Object> bm = session.toBeanMap(b);
                    bm.put(key, v);
                    return;
                }
                if (this.rawTypeMeta.canCreateNewInstance(m.getBean(false))) {
                    b = this.rawTypeMeta.newInstance();
                    BeanMap<Object> bm = session.toBeanMap(b);
                    bm.put(key, v);
                }
                this.invokeSetter(bean, pName, b);
            }
        }
        catch (BeanRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanRuntimeException(e);
        }
    }

    public <A extends Annotation> List<A> getAllAnnotationsParentFirst(Class<A> a) {
        LinkedList l = new LinkedList();
        BeanContext bc = this.beanContext;
        if (a == null) {
            return l;
        }
        this.getBeanMeta().getClassMeta().getInfo().forEachAnnotation(bc, a, x -> true, x -> l.add(x));
        if (this.field != null) {
            bc.forEachAnnotation(a, this.field, x -> true, x -> l.add(x));
            ClassInfo.of(this.field.getType()).forEachAnnotation(bc, a, x -> true, x -> l.add(x));
        }
        if (this.getter != null) {
            bc.forEachAnnotation(a, this.getter, x -> true, x -> l.add(x));
            ClassInfo.of(this.getter.getReturnType()).forEachAnnotation(bc, a, x -> true, x -> l.add(x));
        }
        if (this.setter != null) {
            bc.forEachAnnotation(a, this.setter, x -> true, x -> l.add(x));
            ClassInfo.of(this.setter.getReturnType()).forEachAnnotation(bc, a, x -> true, x -> l.add(x));
        }
        if (this.extraKeys != null) {
            bc.forEachAnnotation(a, this.extraKeys, x -> true, x -> l.add(x));
            ClassInfo.of(this.extraKeys.getReturnType()).forEachAnnotation(bc, a, x -> true, x -> l.add(x));
        }
        return l;
    }

    public <A extends Annotation> BeanPropertyMeta forEachAnnotation(Class<A> a, Predicate<A> filter, Consumer<A> action) {
        BeanContext bc = this.beanContext;
        if (a != null) {
            bc.forEachAnnotation(a, this.field, filter, action);
            bc.forEachAnnotation(a, this.getter, filter, action);
            bc.forEachAnnotation(a, this.setter, filter, action);
        }
        return this;
    }

    private Object transform(BeanSession session, Object o) throws SerializeException {
        try {
            ObjectSwap<?, ?> f;
            if (this.swap != null) {
                return this.swap.swap(session, o);
            }
            if (o == null) {
                return null;
            }
            if (this.rawTypeMeta.hasChildSwaps() && (f = this.rawTypeMeta.getChildObjectSwapForSwap(o.getClass())) != null) {
                return f.swap(session, o);
            }
            return o;
        }
        catch (SerializeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializeException(e);
        }
    }

    private Object unswap(BeanSession session, Object o) throws ParseException {
        try {
            ObjectSwap<?, ?> f;
            if (this.swap != null) {
                return this.swap.unswap(session, o, this.rawTypeMeta);
            }
            if (o == null) {
                return null;
            }
            if (this.rawTypeMeta.hasChildSwaps() && (f = this.rawTypeMeta.getChildObjectSwapForUnswap(o.getClass())) != null) {
                return f.unswap(session, o, this.rawTypeMeta);
            }
            return o;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    private Object applyChildPropertiesFilter(BeanSession session, ClassMeta cm, Object o) {
        if (o == null) {
            return null;
        }
        if (cm.isBean()) {
            return new BeanMap<Object>(session, o, new BeanMetaFiltered(cm.getBeanMeta(), this.properties));
        }
        if (cm.isMap()) {
            return new FilteredMap(cm, (Map)o, this.properties);
        }
        if (cm.isObject()) {
            if (o instanceof Map) {
                return new FilteredMap(cm, (Map)o, this.properties);
            }
            BeanMeta<?> bm = this.beanContext.getBeanMeta(o.getClass());
            if (bm != null) {
                return new BeanMap<Object>(session, o, new BeanMetaFiltered(cm.getBeanMeta(), this.properties));
            }
        }
        return o;
    }

    private static String findClassName(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Class) {
            return ((Class)o).getName();
        }
        return o.getClass().getName();
    }

    public String toString() {
        return this.name + ": " + this.rawTypeMeta.getInnerClass().getName() + ", field=[" + String.valueOf(this.field) + "], getter=[" + String.valueOf(this.getter) + "], setter=[" + String.valueOf(this.setter) + "]";
    }

    public boolean canRead() {
        return this.canRead;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected boolean isWriteOnly() {
        return this.writeOnly;
    }

    @Override
    public int compareTo(BeanPropertyMeta o) {
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        return o instanceof BeanPropertyMeta && ObjectUtils.eq(this, (BeanPropertyMeta)o, (x, y) -> StringUtils.eq(x.name, y.name) && ObjectUtils.eq(x.beanMeta, y.beanMeta));
    }

    public static final class Builder {
        BeanMeta<?> beanMeta;
        BeanContext beanContext;
        String name;
        Field field;
        Field innerField;
        Method getter;
        Method setter;
        Method extraKeys;
        boolean isConstructorArg;
        boolean isUri;
        boolean isDyna;
        boolean isDynaGetterMap;
        ClassMeta<?> rawTypeMeta;
        ClassMeta<?> typeMeta;
        String[] properties;
        ObjectSwap swap;
        BeanRegistry beanRegistry;
        Object overrideValue;
        BeanPropertyMeta delegateFor;
        boolean canRead;
        boolean canWrite;
        boolean readOnly;
        boolean writeOnly;

        Builder(BeanMeta<?> beanMeta, String name) {
            this.beanMeta = beanMeta;
            this.beanContext = beanMeta.ctx;
            this.name = name;
        }

        public Builder rawMetaType(ClassMeta<?> rawMetaType) {
            this.rawTypeMeta = rawMetaType;
            this.typeMeta = this.rawTypeMeta;
            return this;
        }

        public Builder beanRegistry(BeanRegistry beanRegistry) {
            this.beanRegistry = beanRegistry;
            return this;
        }

        public Builder overrideValue(Object overrideValue) {
            this.overrideValue = overrideValue;
            return this;
        }

        public Builder delegateFor(BeanPropertyMeta delegateFor) {
            this.delegateFor = delegateFor;
            return this;
        }

        Builder canRead() {
            this.canRead = true;
            return this;
        }

        Builder canWrite() {
            this.canWrite = true;
            return this;
        }

        boolean validate(BeanContext bc, BeanRegistry parentBeanRegistry, Map<Class<?>, Class<?>[]> typeVarImpls, Set<String> bpro, Set<String> bpwo) throws Exception {
            Class<?>[] pt;
            ArrayList<Beanp> lp;
            ArrayList<Class> bdClasses = CollectionUtils.list(new Class[0]);
            if (this.field == null && this.getter == null && this.setter == null) {
                return false;
            }
            if (this.field == null && this.setter == null && bc.isBeansRequireSettersForGetters() && !this.isConstructorArg) {
                return false;
            }
            this.canRead |= this.field != null || this.getter != null;
            this.canWrite |= this.field != null || this.setter != null;
            if (this.innerField != null) {
                lp = CollectionUtils.list(new Beanp[0]);
                bc.forEachAnnotation(Beanp.class, this.innerField, x -> true, x -> lp.add((Beanp)x));
                if (this.field != null || lp.size() > 0) {
                    this.rawTypeMeta = bc.resolveClassMeta(CollectionUtils.last(lp), this.innerField.getGenericType(), typeVarImpls);
                    this.isUri |= this.rawTypeMeta.isUri();
                }
                lp.forEach(x -> {
                    if (!x.properties().isEmpty()) {
                        this.properties = StringUtils.split(x.properties());
                    }
                    CollectionUtils.addAll(bdClasses, x.dictionary());
                    if (!x.ro().isEmpty()) {
                        this.readOnly = Boolean.valueOf(x.ro());
                    }
                    if (!x.wo().isEmpty()) {
                        this.writeOnly = Boolean.valueOf(x.wo());
                    }
                });
                bc.forEachAnnotation(Swap.class, this.innerField, x -> true, x -> {
                    this.swap = this.getPropertySwap((Swap)x);
                });
                this.isUri |= bc.firstAnnotation(Uri.class, this.innerField, x -> true) != null;
            }
            if (this.getter != null) {
                lp = CollectionUtils.list(new Beanp[0]);
                bc.forEachAnnotation(Beanp.class, this.getter, x -> true, x -> lp.add((Beanp)x));
                if (this.rawTypeMeta == null) {
                    this.rawTypeMeta = bc.resolveClassMeta(CollectionUtils.last(lp), this.getter.getGenericReturnType(), typeVarImpls);
                }
                this.isUri |= this.rawTypeMeta.isUri() || bc.hasAnnotation(Uri.class, this.getter);
                lp.forEach(x -> {
                    if (this.properties != null && !x.properties().isEmpty()) {
                        this.properties = StringUtils.split(x.properties());
                    }
                    CollectionUtils.addAll(bdClasses, x.dictionary());
                    if (!x.ro().isEmpty()) {
                        this.readOnly = Boolean.valueOf(x.ro());
                    }
                    if (!x.wo().isEmpty()) {
                        this.writeOnly = Boolean.valueOf(x.wo());
                    }
                });
                bc.forEachAnnotation(Swap.class, this.getter, x -> true, x -> {
                    this.swap = this.getPropertySwap((Swap)x);
                });
            }
            if (this.setter != null) {
                lp = CollectionUtils.list(new Beanp[0]);
                bc.forEachAnnotation(Beanp.class, this.setter, x -> true, x -> lp.add((Beanp)x));
                if (this.rawTypeMeta == null) {
                    this.rawTypeMeta = bc.resolveClassMeta(CollectionUtils.last(lp), this.setter.getGenericParameterTypes()[0], typeVarImpls);
                }
                this.isUri |= this.rawTypeMeta.isUri() || bc.hasAnnotation(Uri.class, this.setter);
                lp.forEach(x -> {
                    if (this.swap == null) {
                        this.swap = this.getPropertySwap((Beanp)x);
                    }
                    if (this.properties != null && !x.properties().isEmpty()) {
                        this.properties = StringUtils.split(x.properties());
                    }
                    CollectionUtils.addAll(bdClasses, x.dictionary());
                    if (!x.ro().isEmpty()) {
                        this.readOnly = Boolean.valueOf(x.ro());
                    }
                    if (!x.wo().isEmpty()) {
                        this.writeOnly = Boolean.valueOf(x.wo());
                    }
                });
                bc.forEachAnnotation(Swap.class, this.setter, x -> true, x -> {
                    this.swap = this.getPropertySwap((Swap)x);
                });
            }
            if (this.rawTypeMeta == null) {
                return false;
            }
            this.beanRegistry = new BeanRegistry(this.beanContext, parentBeanRegistry, bdClasses.toArray(new Class[0]));
            this.isDyna = "*".equals(this.name);
            ClassInfo ci = this.rawTypeMeta.getInfo();
            if (this.getter != null) {
                pt = this.getter.getParameterTypes();
                if (this.isDyna) {
                    if (ci.isChildOf(Map.class) && pt.length == 0) {
                        this.isDynaGetterMap = true;
                    } else if (pt.length != 1 || pt[0] != String.class) {
                        return false;
                    }
                } else if (!ci.isChildOf(this.getter.getReturnType())) {
                    return false;
                }
            }
            if (this.setter != null) {
                pt = this.setter.getParameterTypes();
                if (this.isDyna) {
                    if (pt.length != 2 || pt[0] != String.class) {
                        return false;
                    }
                } else if (pt.length != 1 || !ci.isChildOf(pt[0])) {
                    return false;
                }
            }
            if (this.field != null && (this.isDyna ? !ClassInfo.of(this.field.getType()).isChildOf(Map.class) : !ci.isChildOf(this.field.getType()))) {
                return false;
            }
            if (this.isDyna) {
                this.rawTypeMeta = this.rawTypeMeta.getValueType();
                if (this.rawTypeMeta == null) {
                    this.rawTypeMeta = this.beanContext.object();
                }
            }
            if (this.rawTypeMeta == null) {
                return false;
            }
            if (this.typeMeta == null) {
                ClassMeta<Object> classMeta = this.swap != null ? this.beanContext.getClassMeta(this.swap.getSwapClass().innerType(), new Type[0]) : (this.typeMeta = this.rawTypeMeta == null ? this.beanContext.object() : this.rawTypeMeta);
            }
            if (this.typeMeta == null) {
                this.typeMeta = this.rawTypeMeta;
            }
            if (bpro.contains(this.name) || bpro.contains("*")) {
                this.readOnly = true;
            }
            if (bpwo.contains(this.name) || bpwo.contains("*")) {
                this.writeOnly = true;
            }
            return true;
        }

        public BeanPropertyMeta build() {
            return new BeanPropertyMeta(this);
        }

        private ObjectSwap getPropertySwap(Beanp p) {
            if (!p.format().isEmpty()) {
                return BeanCreator.of(ObjectSwap.class).type(StringFormatSwap.class).arg(String.class, p.format()).run();
            }
            return null;
        }

        private ObjectSwap getPropertySwap(Swap s) throws RuntimeException {
            Class<?> c = s.value();
            if (ClassUtils.isVoid(c)) {
                c = s.impl();
            }
            if (ClassUtils.isVoid(c)) {
                return null;
            }
            ClassInfo ci = ClassInfo.of(c);
            if (ci.isChildOf(ObjectSwap.class)) {
                ObjectSwap ps = BeanCreator.of(ObjectSwap.class).type(c).run();
                if (ps.forMediaTypes() != null) {
                    throw new UnsupportedOperationException("TODO - Media types on swaps not yet supported on bean properties.");
                }
                if (ps.withTemplate() != null) {
                    throw new UnsupportedOperationException("TODO - Templates on swaps not yet supported on bean properties.");
                }
                return ps;
            }
            if (ci.isChildOf(Surrogate.class)) {
                throw new UnsupportedOperationException("TODO - Surrogate swaps not yet supported on bean properties.");
            }
            throw new BasicRuntimeException("Invalid class used in @Swap annotation.  Must be a subclass of ObjectSwap or Surrogate. {0}", c);
        }

        Builder setGetter(Method getter) {
            ClassUtils.setAccessible(getter);
            this.getter = getter;
            return this;
        }

        Builder setSetter(Method setter) {
            ClassUtils.setAccessible(setter);
            this.setter = setter;
            return this;
        }

        Builder setField(Field field) {
            ClassUtils.setAccessible(field);
            this.field = field;
            this.innerField = field;
            return this;
        }

        Builder setInnerField(Field innerField) {
            this.innerField = innerField;
            return this;
        }

        Builder setExtraKeys(Method extraKeys) {
            ClassUtils.setAccessible(extraKeys);
            this.extraKeys = extraKeys;
            return this;
        }

        Builder setAsConstructorArg() {
            this.isConstructorArg = true;
            return this;
        }
    }
}

