/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.TimestampedBytesStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.AbstractStoreBuilder;
import org.apache.kafka.streams.state.internals.CachingWindowStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingTimestampedWindowBytesStore;
import org.apache.kafka.streams.state.internals.MeteredTimestampedWindowStore;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedWindowStore;
import org.apache.kafka.streams.state.internals.TimeOrderedCachingWindowStore;
import org.apache.kafka.streams.state.internals.ValueAndTimestampSerde;
import org.apache.kafka.streams.state.internals.WindowToTimestampedWindowByteStoreAdapter;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampedWindowStoreBuilder<K, V>
extends AbstractStoreBuilder<K, ValueAndTimestamp<V>, TimestampedWindowStore<K, V>> {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampedWindowStoreBuilder.class);
    private final WindowBytesStoreSupplier storeSupplier;

    public TimestampedWindowStoreBuilder(WindowBytesStoreSupplier storeSupplier, Serde<K> keySerde, Serde<V> valueSerde, Time time) {
        super(storeSupplier.name(), keySerde, valueSerde == null ? null : new ValueAndTimestampSerde<V>(valueSerde), time);
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        Objects.requireNonNull(storeSupplier.metricsScope(), "storeSupplier's metricsScope can't be null");
        this.storeSupplier = storeSupplier;
    }

    @Override
    public TimestampedWindowStore<K, V> build() {
        WindowStore<Bytes, byte[]> store = (WindowStore<Bytes, byte[]>)this.storeSupplier.get();
        if (!(store instanceof TimestampedBytesStore)) {
            store = store.persistent() ? new WindowToTimestampedWindowByteStoreAdapter(store) : new InMemoryTimestampedWindowStoreMarker(store);
        }
        if (this.storeSupplier.retainDuplicates() && this.enableCaching) {
            LOG.warn("Disabling caching for {} since store was configured to retain duplicates", (Object)this.storeSupplier.name());
            this.enableCaching = false;
        }
        return new MeteredTimestampedWindowStore(this.maybeWrapCaching(this.maybeWrapLogging(store)), this.storeSupplier.windowSize(), this.storeSupplier.metricsScope(), this.time, this.keySerde, this.valueSerde);
    }

    private WindowStore<Bytes, byte[]> maybeWrapCaching(WindowStore<Bytes, byte[]> inner) {
        if (!this.enableCaching) {
            return inner;
        }
        boolean isTimeOrdered = this.isTimeOrderedStore(inner);
        if (isTimeOrdered) {
            return new TimeOrderedCachingWindowStore(inner, this.storeSupplier.windowSize(), this.storeSupplier.segmentIntervalMs());
        }
        return new CachingWindowStore(inner, this.storeSupplier.windowSize(), this.storeSupplier.segmentIntervalMs());
    }

    private boolean isTimeOrderedStore(StateStore stateStore) {
        if (stateStore instanceof RocksDBTimeOrderedWindowStore) {
            return true;
        }
        if (stateStore instanceof WrappedStateStore) {
            return this.isTimeOrderedStore((StateStore)((WrappedStateStore)stateStore).wrapped());
        }
        return false;
    }

    private WindowStore<Bytes, byte[]> maybeWrapLogging(WindowStore<Bytes, byte[]> inner) {
        if (!this.enableLogging) {
            return inner;
        }
        return new ChangeLoggingTimestampedWindowBytesStore(inner, this.storeSupplier.retainDuplicates());
    }

    public long retentionPeriod() {
        return this.storeSupplier.retentionPeriod();
    }

    private static final class InMemoryTimestampedWindowStoreMarker
    extends WrappedStateStore<WindowStore<Bytes, byte[]>, Bytes, byte[]>
    implements WindowStore<Bytes, byte[]>,
    TimestampedBytesStore {
        private InMemoryTimestampedWindowStoreMarker(WindowStore<Bytes, byte[]> wrapped) {
            super(wrapped);
            if (wrapped.persistent()) {
                throw new IllegalArgumentException("Provided store must not be a persistent store, but it is.");
            }
        }

        @Override
        public void put(Bytes key, byte[] value, long windowStartTimestamp) {
            ((WindowStore)this.wrapped()).put(key, value, windowStartTimestamp);
        }

        @Override
        public byte[] fetch(Bytes key, long time) {
            return (byte[])((WindowStore)this.wrapped()).fetch(key, time);
        }

        @Override
        public WindowStoreIterator<byte[]> fetch(Bytes key, long timeFrom, long timeTo) {
            return ((WindowStore)this.wrapped()).fetch(key, timeFrom, timeTo);
        }

        @Override
        public WindowStoreIterator<byte[]> backwardFetch(Bytes key, long timeFrom, long timeTo) {
            return ((WindowStore)this.wrapped()).backwardFetch(key, timeFrom, timeTo);
        }

        @Override
        public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
            return ((WindowStore)this.wrapped()).fetch(keyFrom, keyTo, timeFrom, timeTo);
        }

        @Override
        public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
            return ((WindowStore)this.wrapped()).backwardFetch(keyFrom, keyTo, timeFrom, timeTo);
        }

        @Override
        public KeyValueIterator<Windowed<Bytes>, byte[]> fetchAll(long timeFrom, long timeTo) {
            return ((WindowStore)this.wrapped()).fetchAll(timeFrom, timeTo);
        }

        @Override
        public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetchAll(long timeFrom, long timeTo) {
            return ((WindowStore)this.wrapped()).backwardFetchAll(timeFrom, timeTo);
        }

        @Override
        public KeyValueIterator<Windowed<Bytes>, byte[]> all() {
            return ((WindowStore)this.wrapped()).all();
        }

        @Override
        public KeyValueIterator<Windowed<Bytes>, byte[]> backwardAll() {
            return ((WindowStore)this.wrapped()).backwardAll();
        }

        @Override
        public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
            long start = config.isCollectExecutionInfo() ? System.nanoTime() : -1L;
            QueryResult<R> result = ((WindowStore)this.wrapped()).query(query, positionBound, config);
            if (config.isCollectExecutionInfo()) {
                long end = System.nanoTime();
                result.addExecutionInfo("Handled in " + this.getClass() + " in " + (end - start) + "ns");
            }
            return result;
        }

        @Override
        public boolean persistent() {
            return false;
        }
    }
}

