/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.until;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.linkis.bml.conf.BmlConfiguration;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.utils.Utils;
import org.apache.linkis.httpclient.authentication.AuthenticationStrategy;
import org.apache.linkis.httpclient.dws.authentication.TokenAuthenticationStrategy;
import org.apache.linkis.httpclient.dws.config.DWSClientConfig;
import org.apache.linkis.httpclient.dws.config.DWSClientConfigBuilder;
import org.apache.linkis.monitor.client.MonitorHTTPClient;
import org.apache.linkis.monitor.client.MonitorHTTPClientClientImpl;
import org.apache.linkis.monitor.config.MonitorConfig;
import org.apache.linkis.monitor.entity.IndexEntity;
import org.apache.linkis.monitor.request.EmsListAction;
import org.apache.linkis.monitor.request.EntranceTaskAction;
import org.apache.linkis.monitor.response.EntranceTaskResult;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.apache.linkis.ujes.client.response.EmsListResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class HttpsUntils {
    private static final Logger logger = LoggerFactory.getLogger(HttpsUntils.class);
    public static DWSClientConfig dwsClientConfig = HttpsUntils.createClientConfig(null, null);
    public static MonitorHTTPClient client = new MonitorHTTPClientClientImpl(dwsClientConfig);
    public static final String localHost = Utils.getLocalHostname();

    public static Map<String, Object> sendHttp(String url, Map<String, Object> properties) throws IOException {
        if (null == dwsClientConfig) {
            dwsClientConfig = HttpsUntils.createClientConfig(url, properties);
        }
        if (null == client) {
            client = new MonitorHTTPClientClientImpl(dwsClientConfig);
        }
        EmsListAction build = EmsListAction.newBuilder().setUser("hadoop").build();
        EmsListResult result = client.list(build);
        return result.getResultMap();
    }

    public static DWSClientConfig createClientConfig(String url, Map<String, Object> properties) {
        String realUrl = "";
        realUrl = StringUtils.isBlank((CharSequence)url) ? Configuration.getGateWayURL() : url;
        Map<Object, Object> parms = new HashMap();
        if (MapUtils.isNotEmpty(properties)) {
            parms = properties;
        }
        int maxConnection = (Integer)parms.getOrDefault(BmlConfiguration.CONNECTION_MAX_SIZE_SHORT_NAME(), BmlConfiguration.CONNECTION_MAX_SIZE().getValue());
        int connectTimeout = (Integer)parms.getOrDefault(BmlConfiguration.CONNECTION_TIMEOUT_SHORT_NAME(), BmlConfiguration.CONNECTION_TIMEOUT().getValue());
        int readTimeout = (Integer)parms.getOrDefault(BmlConfiguration.CONNECTION_READ_TIMEOUT_SHORT_NAME(), BmlConfiguration.CONNECTION_READ_TIMEOUT().getValue());
        String tokenKey = (String)parms.getOrDefault(BmlConfiguration.AUTH_TOKEN_KEY_SHORT_NAME(), BmlConfiguration.AUTH_TOKEN_KEY().getValue());
        String tokenValue = (String)parms.getOrDefault(BmlConfiguration.AUTH_TOKEN_VALUE_SHORT_NAME(), BmlConfiguration.AUTH_TOKEN_VALUE().getValue());
        DWSClientConfig clientConfig = ((DWSClientConfigBuilder)DWSClientConfigBuilder.newBuilder().addServerUrl(realUrl).connectionTimeout((long)connectTimeout).discoveryEnabled(false).discoveryFrequency(1L, TimeUnit.MINUTES).loadbalancerEnabled(false).maxConnectionSize(maxConnection).retryEnabled(false).readTimeout((long)readTimeout).setAuthenticationStrategy((AuthenticationStrategy)new TokenAuthenticationStrategy()).setAuthTokenKey(tokenKey).setAuthTokenValue(tokenValue)).setDWSVersion("v1").build();
        return clientConfig;
    }

    public static Map<String, Object> getEntranceTask(String url, String user, String Instance) throws IOException {
        if (null == dwsClientConfig) {
            dwsClientConfig = HttpsUntils.createClientConfig(null, null);
        }
        if (null == client) {
            client = new MonitorHTTPClientClientImpl(dwsClientConfig);
        }
        EntranceTaskAction build = EntranceTaskAction.newBuilder().setUser(user).setInstance(Instance).build();
        EntranceTaskResult result = client.entranList(build);
        return result.getResultMap();
    }

    public static void sendIndex(List<IndexEntity> list) throws IOException {
        HashMap<String, Object> parm = new HashMap<String, Object>();
        parm.put("userAuthKey", MonitorConfig.ECM_TASK_USER_AUTHKEY.getValue());
        parm.put("metricDataList", list);
        String json = BDPJettyServerHelper.gson().toJson(parm);
        RequestConfig requestConfig = RequestConfig.DEFAULT;
        StringEntity entity = new StringEntity(json, ContentType.create((String)ContentType.APPLICATION_JSON.getMimeType(), (String)"UTF-8"));
        entity.setContentEncoding("UTF-8");
        HttpPost httpPost = new HttpPost((String)MonitorConfig.ECM_TASK_IMURL.getValue());
        httpPost.setConfig(requestConfig);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse execute = httpClient.execute((HttpUriRequest)httpPost);
        String responseStr = EntityUtils.toString((HttpEntity)execute.getEntity(), (String)"UTF-8");
        Map map = (Map)BDPJettyServerHelper.gson().fromJson(responseStr, Map.class);
        logger.info("send index response :{}", (Object)map);
        Assert.isTrue((!"0".equals(map.get("resultCode")) ? 1 : 0) != 0, (String)((String)map.get("resultMsg")));
    }
}

