/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.provider.redis.rdd;

import com.redislabs.provider.redis.ReadWriteConfig;
import com.redislabs.provider.redis.RedisNode;
import com.redislabs.provider.redis.partitioner.RedisPartition;
import com.redislabs.provider.redis.rdd.Keys;
import com.redislabs.provider.redis.util.ParseUtils$;
import com.redislabs.provider.redis.util.PipelineUtils$;
import java.io.Serializable;
import org.apache.spark.Partition;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import redis.clients.jedis.Jedis;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001Q4Aa\u0003\u0007\u0001/!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005;\u0001\t\u0015\r\u0011\"\u0001<\u0011!a\u0004A!A!\u0002\u0013I\u0003\u0002C\u001f\u0001\u0005\u000b\u0007I1\u0001 \t\u0011\r\u0003!\u0011!Q\u0001\n}BQ\u0001\u0012\u0001\u0005\u0002\u0015CQA\u0013\u0001\u0005B-CQa\u0015\u0001\u0005BQCQ!\u001a\u0001\u0005\u0002\u0019DQ\u0001\u001d\u0001\u0005\u0002E\u0014!BU3eSN\\eK\u0015#E\u0015\tia\"A\u0002sI\u0012T!a\u0004\t\u0002\u000bI,G-[:\u000b\u0005E\u0011\u0012\u0001\u00039s_ZLG-\u001a:\u000b\u0005M!\u0012!\u0003:fI&\u001cH.\u00192t\u0015\u0005)\u0012aA2p[\u000e\u00011c\u0001\u0001\u0019iA\u0019\u0011$I\u0012\u000e\u0003iQ!!D\u000e\u000b\u0005qi\u0012!B:qCJ\\'B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001eL!A\t\u000e\u0003\u0007I#E\t\u0005\u0003%O%JS\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\rQ+\b\u000f\\33!\tQ\u0013G\u0004\u0002,_A\u0011A&J\u0007\u0002[)\u0011aFF\u0001\u0007yI|w\u000e\u001e \n\u0005A*\u0013A\u0002)sK\u0012,g-\u0003\u00023g\t11\u000b\u001e:j]\u001eT!\u0001M\u0013\u0011\u0005U2T\"\u0001\u0007\n\u0005]b!\u0001B&fsN\fA\u0001\u001d:fmB\u0019\u0011$I\u0015\u0002\u000fI$G\rV=qKV\t\u0011&\u0001\u0005sI\u0012$\u0016\u0010]3!\u0003=\u0011X-\u00193Xe&$XmQ8oM&<W#A \u0011\u0005\u0001\u000bU\"\u0001\b\n\u0005\ts!a\u0004*fC\u0012<&/\u001b;f\u0007>tg-[4\u0002!I,\u0017\rZ,sSR,7i\u001c8gS\u001e\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003G\u000f\"K\u0005CA\u001b\u0001\u0011\u0015Ad\u00011\u0001:\u0011\u0015Qd\u00011\u0001*\u0011\u0015id\u0001q\u0001@\u000359W\r\u001e)beRLG/[8ogV\tA\nE\u0002%\u001b>K!AT\u0013\u0003\u000b\u0005\u0013(/Y=\u0011\u0005A\u000bV\"A\u000e\n\u0005I[\"!\u0003)beRLG/[8o\u0003\u001d\u0019w.\u001c9vi\u0016$2!\u00160a!\r16l\t\b\u0003/fs!\u0001\f-\n\u0003\u0019J!AW\u0013\u0002\u000fA\f7m[1hK&\u0011A,\u0018\u0002\t\u0013R,'/\u0019;pe*\u0011!,\n\u0005\u0006?\"\u0001\raT\u0001\u0006gBd\u0017\u000e\u001e\u0005\u0006C\"\u0001\rAY\u0001\bG>tG/\u001a=u!\t\u00016-\u0003\u0002e7\tYA+Y:l\u0007>tG/\u001a=u\u0003\u00159W\r^&W)\r)v-\u001c\u0005\u0006Q&\u0001\r![\u0001\u0006]>$Wm\u001d\t\u0004I5S\u0007C\u0001!l\u0013\tagBA\u0005SK\u0012L7OT8eK\")a.\u0003a\u0001_\u0006!1.Z=t!\r16,K\u0001\bO\u0016$\b*Q*I)\r)&o\u001d\u0005\u0006Q*\u0001\r!\u001b\u0005\u0006]*\u0001\ra\u001c")
public class RedisKVRDD
extends RDD<Tuple2<String, String>>
implements Keys {
    private final RDD<String> prev;
    private final String rddType;
    private final ReadWriteConfig readWriteConfig;

    @Override
    public boolean isRedisRegex(String key) {
        return Keys.isRedisRegex$(this, key);
    }

    @Override
    public Iterator<String> getKeys(RedisNode[] nodes, int sPos, int ePos, String keyPattern, ReadWriteConfig readWriteConfig) {
        return Keys.getKeys$(this, nodes, sPos, ePos, keyPattern, readWriteConfig);
    }

    @Override
    public RedisNode getMasterNode(RedisNode[] nodes, String key) {
        return Keys.getMasterNode$(this, nodes, key);
    }

    @Override
    public Iterator<Tuple2<RedisNode, String[]>> groupKeysByNode(RedisNode[] nodes, Iterator<String> keys) {
        return Keys.groupKeysByNode$(this, nodes, keys);
    }

    @Override
    public String[] filterKeysByType(Jedis conn, String[] keys, String t, ReadWriteConfig readWriteConfig) {
        return Keys.filterKeysByType$(this, conn, keys, t, readWriteConfig);
    }

    public String rddType() {
        return this.rddType;
    }

    public ReadWriteConfig readWriteConfig() {
        return this.readWriteConfig;
    }

    public Partition[] getPartitions() {
        return this.prev.partitions();
    }

    public Iterator<Tuple2<String, String>> compute(Partition split, TaskContext context) {
        Iterator<Tuple2<String, String>> iterator;
        RedisPartition partition = (RedisPartition)split;
        int sPos = partition.slots()._1$mcI$sp();
        int ePos = partition.slots()._2$mcI$sp();
        RedisNode[] nodes = partition.redisConfig().getNodesBySlots(sPos, ePos);
        Iterator keys = this.firstParent(ClassTag$.MODULE$.apply(String.class)).iterator(split, context);
        String auth = partition.redisConfig().getAuth();
        int db = partition.redisConfig().getDB();
        String string = this.rddType();
        if ("kv".equals(string)) {
            iterator = this.getKV(nodes, (Iterator<String>)keys);
        } else if ("hash".equals(string)) {
            iterator = this.getHASH(nodes, (Iterator<String>)keys);
        } else {
            throw new MatchError((Object)string);
        }
        return iterator;
    }

    public Iterator<Tuple2<String, String>> getKV(RedisNode[] nodes, Iterator<String> keys) {
        return this.groupKeysByNode(nodes, keys).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            RedisNode node = (RedisNode)tuple2._1();
            String[] nodeKeys = (String[])tuple2._2();
            Jedis conn = node.endpoint().connect();
            Seq<Object> response = PipelineUtils$.MODULE$.mapWithPipeline(conn, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodeKeys)), (Function2 & Serializable & scala.Serializable)(pipeline, key) -> {
                pipeline.get(key);
                return BoxedUnit.UNIT;
            }, this.readWriteConfig());
            Iterator res = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodeKeys)).zip(response, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Object e;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null && (e = tuple2._2()) instanceof Throwable) {
                    Throwable throwable = (Throwable)e;
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Failure(throwable)));
                }
                if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                if (!(v instanceof String)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                String string = (String)v;
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Success((Object)new Tuple2((Object)k, (Object)string))));
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Try.class))))).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable((Option)ParseUtils$.MODULE$.ignoreJedisWrongTypeException(x$1).get()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).iterator();
            conn.close();
            Iterator iterator = res;
            return iterator;
        });
    }

    public Iterator<Tuple2<String, String>> getHASH(RedisNode[] nodes, Iterator<String> keys) {
        return this.groupKeysByNode(nodes, keys).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            RedisNode node = (RedisNode)tuple2._1();
            String[] nodeKeys = (String[])tuple2._2();
            Jedis conn = node.endpoint().connect();
            Iterator res = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodeKeys)).flatMap((Function1 & Serializable & scala.Serializable)k -> Option$.MODULE$.option2Iterable((Option)ParseUtils$.MODULE$.ignoreJedisWrongTypeException(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(conn.hgetAll(k)).toMap(Predef$.MODULE$.$conforms()))).get()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class))))).flatten((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(Tuple2.class)))).iterator();
            conn.close();
            Iterator iterator = res;
            return iterator;
        });
    }

    public RedisKVRDD(RDD<String> prev, String rddType, ReadWriteConfig readWriteConfig) {
        this.prev = prev;
        this.rddType = rddType;
        this.readWriteConfig = readWriteConfig;
        super(prev, ClassTag$.MODULE$.apply(Tuple2.class));
        Keys.$init$(this);
    }
}

