/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.job.common;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.linkis.cli.application.entity.job.JobStatus;
import org.apache.linkis.cli.application.interactor.job.common.ResultSet;
import org.apache.linkis.cli.application.operator.ujes.LinkisOperResultAdapter;

public class ResultData {
    private final String user;
    private final String jobId;
    private final String execId;
    private final LinkedBlockingDeque<ResultSet> resultContent = new LinkedBlockingDeque();
    private String extraMessage;
    private JobStatus jobStatus = null;
    private String resultLocation;
    private String[] resultSetPaths = null;
    private Boolean hasNextResultPage;
    private Integer errCode = null;
    private String errDesc = null;
    private boolean hasResult = true;
    private volatile Boolean resultFin = false;

    public ResultData(String user, String jobId, String execId) {
        this.user = user;
        this.jobId = jobId;
        this.execId = execId;
    }

    public String getJobID() {
        return this.jobId;
    }

    public String getUser() {
        return this.user;
    }

    public final String getExecID() {
        return this.execId;
    }

    public final String getResultLocation() {
        return this.resultLocation;
    }

    public final void setResultLocation(String resultLocation) {
        this.resultLocation = resultLocation;
    }

    public String[] getResultSetPaths() {
        return this.resultSetPaths;
    }

    public final void setResultSetPaths(String[] resultSetPaths) {
        this.resultSetPaths = resultSetPaths;
    }

    public Integer getErrCode() {
        return this.errCode;
    }

    public void setErrCode(Integer errCode) {
        this.errCode = errCode;
    }

    public String getErrDesc() {
        return this.errDesc;
    }

    public void setErrDesc(String errDesc) {
        this.errDesc = errDesc;
    }

    public List<ResultSet> consumeResultContent() {
        LinkedList<ResultSet> ret = new LinkedList<ResultSet>();
        this.resultContent.drainTo(ret, this.resultContent.size());
        return ret;
    }

    public void appendResultContent(ResultSet resultContent) {
        this.resultContent.add(resultContent);
    }

    public Boolean hasNextResultPage() {
        return this.hasNextResultPage;
    }

    public void setHasNextResultPage(Boolean hasNextResultPage) {
        this.hasNextResultPage = hasNextResultPage;
    }

    public void setResultFin() {
        this.resultFin = true;
    }

    public boolean isResultFin() {
        return this.resultFin;
    }

    public boolean hasResult() {
        return this.hasResult;
    }

    public void setHasResult(boolean hasResult) {
        this.hasResult = hasResult;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public String getExtraMessage() {
        return this.extraMessage;
    }

    public void setExtraMessage(String extraMessage) {
        this.extraMessage = extraMessage;
    }

    public void updateByOperResult(LinkisOperResultAdapter adapter) {
        if (adapter.getResultLocation() != null) {
            this.setResultLocation(adapter.getResultLocation());
        }
        if (adapter.getResultSetPaths() != null) {
            this.setResultSetPaths(adapter.getResultSetPaths());
        }
        if (adapter.getErrCode() != null) {
            this.setErrCode(adapter.getErrCode());
        }
        if (adapter.getErrDesc() != null) {
            this.setErrDesc(adapter.getErrDesc());
        }
        if (adapter.getResultContent() != null && adapter.resultHasNextPage() != null) {
            this.setHasNextResultPage(adapter.resultHasNextPage());
            this.appendResultContent(adapter.getResultContent());
        }
        if (adapter.getJobStatus() != null) {
            this.setJobStatus(adapter.getJobStatus());
        }
    }
}

