/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.job.jobcmd;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.cli.application.entity.context.CliCtx;
import org.apache.linkis.cli.application.entity.job.Job;
import org.apache.linkis.cli.application.entity.job.JobResult;
import org.apache.linkis.cli.application.exception.LinkisClientExecutionException;
import org.apache.linkis.cli.application.exception.LinkisClientRuntimeException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.job.common.JobKiller;
import org.apache.linkis.cli.application.interactor.job.common.KillResult;
import org.apache.linkis.cli.application.interactor.job.common.LogRetriever;
import org.apache.linkis.cli.application.interactor.job.common.ResultRetriever;
import org.apache.linkis.cli.application.interactor.job.jobcmd.JobCmdDesc;
import org.apache.linkis.cli.application.interactor.job.jobcmd.JobCmdDescBuilder;
import org.apache.linkis.cli.application.interactor.job.jobcmd.JobCmdJobResult;
import org.apache.linkis.cli.application.interactor.job.jobcmd.JobCmdSubType;
import org.apache.linkis.cli.application.operator.OperManager;
import org.apache.linkis.cli.application.operator.ujes.LinkisJobOper;
import org.apache.linkis.cli.application.operator.ujes.LinkisOperResultAdapter;
import org.apache.linkis.cli.application.present.JobInfoPresenter;
import org.apache.linkis.cli.application.present.LogPresenter;
import org.apache.linkis.cli.application.present.ResultPresenter;
import org.apache.linkis.cli.application.present.model.LinkisJobInfoModel;
import org.apache.linkis.cli.application.utils.LoggerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobCmdJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(JobCmdJob.class);
    protected CliCtx ctx;
    protected LinkisJobOper oper;
    protected JobCmdDesc desc;

    @Override
    public void build(CliCtx ctx) {
        this.ctx = ctx;
        this.desc = JobCmdDescBuilder.build(ctx);
        this.oper = (LinkisJobOper)OperManager.getNew("linkis.oper", ctx);
    }

    @Override
    public JobResult run() {
        JobCmdSubType subType = this.desc.getSubType();
        if (!(subType instanceof JobCmdSubType)) {
            throw new LinkisClientExecutionException("EXE0030", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, "JobSubType is not instance of JobManSubType");
        }
        JobCmdJobResult result = new JobCmdJobResult(true, "Execute Success!!!", new HashMap<String, String>());
        switch (subType) {
            case STATUS: {
                try {
                    LinkisOperResultAdapter jobInfoResult = this.oper.queryJobInfo(this.desc.getUser(), this.desc.getJobID());
                    LinkisJobInfoModel model = new LinkisJobInfoModel();
                    model.buildModel(jobInfoResult);
                    new JobInfoPresenter().present(model);
                }
                catch (Exception e) {
                    result.setSuccess(false);
                    result.setMessage(ExceptionUtils.getStackTrace((Throwable)e));
                }
                if (!result.isSuccess().booleanValue()) {
                    LoggerManager.getPlaintTextLogger().error("Failed to get job-info. Message: " + result.getMessage());
                }
                return result;
            }
            case LOG: {
                try {
                    LinkisOperResultAdapter jobInfoResult = this.oper.queryJobInfo(this.desc.getUser(), this.desc.getJobID());
                    LogRetriever logRetriever = new LogRetriever(jobInfoResult.getUser(), jobInfoResult.getJobID(), jobInfoResult.getStrongerExecId(), false, this.oper, new LogPresenter());
                    logRetriever.retrieveLogAsync();
                    logRetriever.waitIncLogComplete();
                }
                catch (Exception e) {
                    result.setSuccess(false);
                    result.setMessage(ExceptionUtils.getStackTrace((Throwable)e));
                }
                if (!result.isSuccess().booleanValue()) {
                    LoggerManager.getInformationLogger().error("Failed to get log. Message: " + result.getMessage());
                }
                return result;
            }
            case RESULT: {
                LinkisOperResultAdapter jobInfoResult = this.oper.queryJobInfo(this.desc.getUser(), this.desc.getJobID());
                String outputPath = this.ctx.getVarAccess().getVar(String.class, "wds.linkis.client.common.output.path");
                ResultPresenter presenter = StringUtils.isBlank((CharSequence)outputPath) ? new ResultPresenter() : new ResultPresenter(true, outputPath);
                ResultRetriever resultRetriever = new ResultRetriever(jobInfoResult.getUser(), jobInfoResult.getJobID(), jobInfoResult.getStrongerExecId(), this.oper, presenter);
                result = this.getResult(resultRetriever);
                if (!result.isSuccess().booleanValue()) {
                    LoggerManager.getInformationLogger().error("Failed to get result. Message: " + result.getMessage());
                }
                return result;
            }
            case KILL: {
                KillResult killResult;
                JobKiller jobKiller = new JobKiller(this.oper);
                try {
                    killResult = jobKiller.doKill(this.desc.getUser(), this.desc.getJobID());
                }
                catch (Exception e) {
                    killResult = new KillResult(false, "Failed to kill job. Messgae: " + ExceptionUtils.getStackTrace((Throwable)e), new HashMap<String, String>());
                }
                if (killResult.isSuccess().booleanValue()) {
                    LoggerManager.getPlaintTextLogger().info("Kill Success. Current job-info:");
                } else {
                    LoggerManager.getPlaintTextLogger().error("Kill Failed. Messgae: " + killResult.getMessage() + "\n Current job-info:");
                }
                try {
                    LinkisOperResultAdapter jobInfoResult2 = this.oper.queryJobInfo(this.desc.getUser(), this.desc.getJobID());
                    LinkisJobInfoModel model = new LinkisJobInfoModel();
                    model.buildModel(jobInfoResult2);
                    new JobInfoPresenter().present(model);
                }
                catch (Exception e) {
                    LoggerManager.getInformationLogger().error("Failed to get jobInfo", (Throwable)e);
                }
                return new JobCmdJobResult(killResult.isSuccess(), killResult.getMessage(), killResult.getExtraMessage());
            }
        }
        return new JobCmdJobResult(false, "JobSubType + \"" + (Object)((Object)subType) + "\" is not supported", new HashMap<String, String>());
    }

    private JobCmdJobResult getResult(ResultRetriever resultRetriever) throws LinkisClientRuntimeException {
        JobCmdJobResult result = new JobCmdJobResult(true, "Execute Success!!!", new HashMap<String, String>());
        try {
            resultRetriever.retrieveResultSync();
            result.setSuccess(true);
            result.setMessage("execute success!!!");
        }
        catch (LinkisClientExecutionException e) {
            if (e.getCode().equals("EXE0037")) {
                result.setSuccess(true);
                result.setMessage("execute success!!!");
                LoggerManager.getInformationLogger().warn(e.getMessage());
            } else {
                result.setSuccess(false);
                result.setMessage("execute failed!!!\n" + ExceptionUtils.getStackTrace((Throwable)e));
            }
            resultRetriever.setResultFin();
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setMessage("execute failed!!!\n" + ExceptionUtils.getStackTrace((Throwable)e));
            resultRetriever.setResultFin();
        }
        return result;
    }

    @Override
    public void onDestroy() {
    }
}

