/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.core.formdata;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.linkis.datasourcemanager.core.formdata.MultiPartFormDataTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMultiPartFormDataTransformer
implements MultiPartFormDataTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(CustomMultiPartFormDataTransformer.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void injectToObject(Object object, Field field, List<String> stepFieldNames, int step, Object value) throws Exception {
        Class<?> fieldType = field.getType();
        String fieldName = field.getName();
        if (step + 1 >= stepFieldNames.size()) {
            if (fieldType.equals(String.class) || PrimitiveUtils.isPrimitive(fieldType)) {
                this.setObjectField(object, field, PrimitiveUtils.primitiveTypeConverse(value, fieldType));
                return;
            } else {
                if (!fieldType.equals(Object.class)) throw new IllegalAccessException("Cannot set value: " + value + " to object field: " + fieldName);
                this.setObjectField(object, field, value);
            }
            return;
        } else {
            if (PrimitiveUtils.isPrimitive(fieldType)) return;
            Object subObject = this.getObjectField(object, field);
            if (null == subObject) {
                subObject = fieldType.equals(Map.class) ? HashMap.class.getConstructor(new Class[0]).newInstance(new Object[0]) : (fieldType.equals(List.class) ? ArrayList.class.getConstructor(new Class[0]).newInstance(new Object[0]) : fieldType.getConstructor(new Class[0]).newInstance(new Object[0]));
                this.setObjectField(object, field, subObject);
            }
            this.injectRecurse(subObject, field, stepFieldNames, step + 1, value);
        }
    }

    private void injectToMap(Map mapObject, Class<?> valueType, List<String> stepFieldNames, int step, Object value) throws Exception {
        String fieldName = stepFieldNames.get(step);
        if (step + 1 >= stepFieldNames.size()) {
            if (valueType.equals(String.class) || PrimitiveUtils.isPrimitive(valueType)) {
                mapObject.put(fieldName, PrimitiveUtils.primitiveTypeConverse(value, valueType));
            } else if (valueType.equals(Object.class)) {
                mapObject.put(fieldName, value);
            } else {
                throw new IllegalAccessException("Cannot set value: " + value + " to map: " + stepFieldNames.get(step - 1));
            }
        }
    }

    private void injectToList(List listObject, Class<?> elementType, List<String> stepFieldNames, int step, Object value) throws Exception {
        String fieldName = stepFieldNames.get(step);
        if (step + 1 >= stepFieldNames.size() && fieldName.matches("\\[\\d+]")) {
            int index = Integer.parseInt(fieldName.substring(1, fieldName.length() - 1));
            int expand = index + 1 - listObject.size();
            while (expand-- > 0) {
                listObject.add(null);
            }
            if (elementType.equals(String.class) || PrimitiveUtils.isPrimitive(elementType)) {
                listObject.set(index, PrimitiveUtils.primitiveTypeConverse(value, elementType));
            } else if (elementType.equals(Object.class)) {
                listObject.set(index, value);
            } else {
                throw new IllegalAccessException("Cannot set value: " + value + " to array: " + stepFieldNames.get(step - 1));
            }
        }
    }

    private void injectRecurse(Object subObject, Field field, List<String> stepFieldNames, int step, Object value) throws Exception {
        Class<?> fieldType = field.getType();
        if (fieldType.equals(Map.class)) {
            Class<?>[] generic = this.getGenericTypes(field);
            if (null == generic || generic[0].equals(String.class)) {
                Class<String> valueType = null == generic ? String.class : generic[1];
                this.injectToMap((Map)subObject, valueType, stepFieldNames, step, value);
            }
        } else if (fieldType.equals(List.class)) {
            Class<?>[] generic = this.getGenericTypes(field);
            this.injectToList((List)subObject, generic == null ? String.class : generic[0], stepFieldNames, step, value);
        } else {
            String nextFieldName = stepFieldNames.get(step);
            Field nextField = subObject.getClass().getField(nextFieldName);
            this.injectToObject(subObject, nextField, stepFieldNames, step, value);
        }
    }

    private Class<?>[] getGenericTypes(Field field) {
        Type[] types;
        Type fc = field.getGenericType();
        if (fc instanceof ParameterizedType && null != (types = ((ParameterizedType)fc).getActualTypeArguments()) && types.length > 0) {
            Class[] genericClazz = new Class[types.length];
            for (int i = 0; i < genericClazz.length; ++i) {
                genericClazz[i] = (Class)types[i];
            }
            return genericClazz;
        }
        return null;
    }

    private void setObjectField(Object object, Field field, Object value) throws Exception {
        field.setAccessible(true);
        field.set(object, value);
    }

    private Object getObjectField(Object object, Field field) throws Exception {
        field.setAccessible(true);
        return field.get(object);
    }

    public static class PrimitiveUtils {
        public static Object primitiveTypeConverse(Object objValue, Class<?> type) {
            if (type.equals(String.class) || null == objValue) {
                return objValue;
            }
            String value = String.valueOf(objValue);
            if (!type.isPrimitive()) {
                try {
                    type = (Class)type.getField("TYPE").get(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            switch (type.getSimpleName()) {
                case "int": {
                    return Integer.valueOf(value);
                }
                case "long": {
                    return Long.valueOf(value);
                }
                case "short": {
                    return Short.valueOf(value);
                }
                case "char": {
                    return Character.valueOf(value.toCharArray()[0]);
                }
                case "float": {
                    return Float.valueOf(value);
                }
                case "double": {
                    return Double.valueOf(value);
                }
                case "byte": {
                    return Byte.valueOf(value);
                }
                case "boolean": {
                    return Boolean.valueOf(value);
                }
            }
            throw new RuntimeException("Type: " + type.getSimpleName() + " is not primitive");
        }

        public static boolean isPrimitive(Class<?> type) {
            try {
                return type.isPrimitive() || ((Class)type.getField("TYPE").get(null)).isPrimitive();
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

