/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.server;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.common.exception.ExceptionManager;
import org.apache.linkis.common.exception.FatalException;
import org.apache.linkis.common.exception.WarnException;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.errorcode.LinkisModuleErrorCodeSummary;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.Message$;
import org.apache.linkis.server.exception.BDPServerErrorException;
import org.apache.linkis.server.exception.NonLoginException;
import org.apache.linkis.server.security.SecurityFilter$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class package$ {
    public static package$ MODULE$;
    private final String EXCEPTION_MSG;

    static {
        new package$();
    }

    public String EXCEPTION_MSG() {
        return this.EXCEPTION_MSG;
    }

    public String getUser(HttpServletRequest req) {
        return SecurityFilter$.MODULE$.getLoginUsername(req);
    }

    public Message validateFailed(String message) {
        int x$1 = 2;
        String x$2 = Message$.MODULE$.apply$default$1();
        String x$3 = Message$.MODULE$.apply$default$3();
        HashMap<String, Object> x$4 = Message$.MODULE$.apply$default$4();
        return Message$.MODULE$.apply(x$2, x$1, x$3, x$4).setMessage(message);
    }

    public <T> void validate(java.util.Map<String, T> json, Seq<String> keys) {
        keys.foreach((Function1 & Serializable & scala.Serializable)k -> {
            package$.$anonfun$validate$1(json, k);
            return BoxedUnit.UNIT;
        });
    }

    public Message error(String message) {
        return Message$.MODULE$.error(message);
    }

    public Message ok(String msg) {
        return Message$.MODULE$.ok(msg);
    }

    public Message error(Throwable t) {
        return Message$.MODULE$.error(t);
    }

    public Message error(Tuple2<String, Throwable> e) {
        return Message$.MODULE$.error(e);
    }

    public Message error(String msg, Throwable t) {
        return Message$.MODULE$.error((Tuple2<String, Throwable>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)msg), (Object)t));
    }

    public Message catchMsg(Function0<Message> tryOp, String msg, Logger log) {
        return (Message)Utils$.MODULE$.tryCatch(tryOp, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof FatalException) {
                FatalException fatalException = (FatalException)throwable;
                log.error("Fatal Error, system exit...", (Throwable)fatalException);
                System.exit(fatalException.getErrCode());
                return Message$.MODULE$.error("Fatal Error, system exit...");
            }
            if (throwable instanceof NonLoginException) {
                NonLoginException nonLoginException = (NonLoginException)((Object)((Object)throwable));
                Message message = Message$.MODULE$.noLogin(nonLoginException.getMessage());
                message.data(MODULE$.EXCEPTION_MSG(), nonLoginException.toMap());
                return message;
            }
            if (throwable instanceof ErrorException) {
                String string;
                ErrorException errorException = (ErrorException)throwable;
                Throwable cause = errorException.getCause();
                Throwable throwable2 = cause;
                if (throwable2 instanceof ErrorException) {
                    ErrorException errorException2 = (ErrorException)throwable2;
                    string = new StringBuilder(41).append("error code(\u9519\u8bef\u7801): ").append(errorException2.getErrCode()).append(", error message(\u9519\u8bef\u4fe1\u606f): ").append(errorException2.getDesc()).append(".").toString();
                } else {
                    string = new StringBuilder(41).append("error code(\u9519\u8bef\u7801): ").append(errorException.getErrCode()).append(", error message(\u9519\u8bef\u4fe1\u606f): ").append(errorException.getDesc()).append(".").toString();
                }
                String errorMsg = string;
                log.error(errorMsg, (Throwable)errorException);
                Message message = Message$.MODULE$.error(errorMsg);
                message.data(MODULE$.EXCEPTION_MSG(), errorException.toMap());
                return message;
            }
            if (throwable instanceof WarnException) {
                WarnException warnException = (WarnException)throwable;
                String warnMsg = new StringBuilder(45).append("Warning code(\u8b66\u544a\u7801): ").append(warnException.getErrCode()).append(", Warning message(\u8b66\u544a\u4fe1\u606f): ").append(warnException.getDesc()).append(".").toString();
                log.warn(warnMsg, (Throwable)warnException);
                Message message = Message$.MODULE$.warn(warnMsg);
                message.data(MODULE$.EXCEPTION_MSG(), warnException.toMap());
                return message;
            }
            log.error(msg, throwable);
            String errorMsg = ExceptionUtils.getRootCauseMessage((Throwable)throwable);
            Message message = StringUtils.isNotEmpty((CharSequence)errorMsg) && !"operation failed(\u64cd\u4f5c\u5931\u8d25)".equals(msg) ? MODULE$.error(new StringBuilder(16).append(msg).append("\uff01the reason(\u539f\u56e0)\uff1a").append(errorMsg).toString()) : (StringUtils.isNotEmpty((CharSequence)errorMsg) ? MODULE$.error(errorMsg) : MODULE$.error(msg));
            return message.data(MODULE$.EXCEPTION_MSG(), ExceptionManager.unknownException((String)message.getMessage()));
        });
    }

    public Message catchIt(Function0<Message> tryOp, Logger log) {
        return this.catchMsg(tryOp, "operation failed(\u64cd\u4f5c\u5931\u8d25)s", log);
    }

    public <T> Buffer<T> toScalaBuffer(List<T> list) {
        return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala();
    }

    public <K, V> Map<K, V> toScalaMap(java.util.Map<K, V> map) {
        return (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala();
    }

    public <T> List<T> toJavaList(Buffer<T> list) {
        ArrayList arrayList = new ArrayList();
        list.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)arrayList.add(x$1)));
        return arrayList;
    }

    public <K, V> HashMap<K, V> toJavaMap(Map<K, V> map) {
        HashMap hashMap = new HashMap();
        map.foreach((Function1 & Serializable & scala.Serializable)m -> hashMap.put(m._1(), m._2()));
        return hashMap;
    }

    public <K, V> HashMap<K, V> toJavaMap(scala.collection.immutable.Map<K, V> map) {
        HashMap hashMap = new HashMap();
        map.foreach((Function1 & Serializable & scala.Serializable)m -> hashMap.put(m._1(), m._2()));
        return hashMap;
    }

    public String asString(Tuple2<java.util.Map<String, Object>, String> mapWithKey) {
        return (String)((java.util.Map)mapWithKey._1()).get(mapWithKey._2());
    }

    public String getString(Tuple2<java.util.Map<String, String>, String> mapWithKey) {
        return (String)((java.util.Map)mapWithKey._1()).get(mapWithKey._2());
    }

    public int asInt(java.util.Map<String, Object> map, String key) {
        return BoxesRunTime.unboxToInt((Object)map.get(key));
    }

    public boolean asBoolean(Tuple2<java.util.Map<String, Object>, String> mapWithKey) {
        return BoxesRunTime.unboxToBoolean(((java.util.Map)mapWithKey._1()).get(mapWithKey._2()));
    }

    public static final /* synthetic */ void $anonfun$validate$1(java.util.Map json$1, String k) {
        if (!MODULE$.toScalaMap(json$1).contains((Object)k) || json$1.get(k) == null || StringUtils.isEmpty((CharSequence)json$1.get(k).toString())) {
            throw new BDPServerErrorException(LinkisModuleErrorCodeSummary.VERIFICATION_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisModuleErrorCodeSummary.VERIFICATION_CANNOT_EMPTY.getErrorDesc(), k));
        }
    }

    private package$() {
        MODULE$ = this;
        this.EXCEPTION_MSG = "errorMsg";
    }
}

