/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.server.socket.controller;

import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.listener.ListenerEventBus;
import org.apache.linkis.errorcode.LinkisModuleErrorCodeSummary;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.Message$;
import org.apache.linkis.server.exception.BDPServerErrorException;
import org.apache.linkis.server.socket.controller.ServerEvent;
import org.apache.linkis.server.socket.controller.ServerEventService;
import org.apache.linkis.server.socket.controller.SocketServerEvent;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0003\u0006\u0001/!Iq\u0005\u0001B\u0001B\u0003%\u0001F\f\u0005\t_\u0001\u0011\t\u0011)A\u0005a!A1\b\u0001B\u0001B\u0003%\u0001\u0006\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u00159\u0005\u0001\"\u0015I\u0011\u001dy\u0005A1A\u0005RACa!\u0016\u0001!\u0002\u0013\t&AF*feZ,'\u000fT5ti\u0016tWM]#wK:$()^:\u000b\u0005-a\u0011AC2p]R\u0014x\u000e\u001c7fe*\u0011QBD\u0001\u0007g>\u001c7.\u001a;\u000b\u0005=\u0001\u0012AB:feZ,'O\u0003\u0002\u0012%\u00051A.\u001b8lSNT!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u00011C\u0001\u0001\u0019!\u0011Ib\u0004\t\u0013\u000e\u0003iQ!a\u0007\u000f\u0002\u00111L7\u000f^3oKJT!!\b\t\u0002\r\r|W.\\8o\u0013\ty\"D\u0001\tMSN$XM\\3s\u000bZ,g\u000e\u001e\"vgB\u0011\u0011EI\u0007\u0002\u0015%\u00111E\u0003\u0002\u0013'\u0016\u0014h/\u001a:Fm\u0016tGoU3sm&\u001cW\r\u0005\u0002\"K%\u0011aE\u0003\u0002\u0012'>\u001c7.\u001a;TKJ4XM]#wK:$\u0018AE3wK:$\u0018+^3vK\u000e\u000b\u0007/Y2jif\u0004\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u00121!\u00138u\u0013\t9c$\u0001\u0003oC6,\u0007CA\u00199\u001d\t\u0011d\u0007\u0005\u00024U5\tAG\u0003\u00026-\u00051AH]8pizJ!a\u000e\u0016\u0002\rA\u0013X\rZ3g\u0013\tI$H\u0001\u0004TiJLgn\u001a\u0006\u0003o)\n!\u0004\\5ti\u0016tWM]\"p]N,X.\u001a:UQJ,\u0017\rZ*ju\u0016\f\u0011\u0004\\5ti\u0016tWM\u001d+ie\u0016\fG-T1y\rJ,W\rV5nKB\u0011\u0011FP\u0005\u0003\u007f)\u0012A\u0001T8oO\u00061A(\u001b8jiz\"RAQ\"E\u000b\u001a\u0003\"!\t\u0001\t\u000b\u001d*\u0001\u0019\u0001\u0015\t\u000b=*\u0001\u0019\u0001\u0019\t\u000bm*\u0001\u0019\u0001\u0015\t\u000bq*\u0001\u0019A\u001f\u0002\u0017\u0011|\u0007k\\:u\u000bZ,g\u000e\u001e\u000b\u0004\u00132k\u0005CA\u0015K\u0013\tY%F\u0001\u0003V]&$\b\"B\u000e\u0007\u0001\u0004\u0001\u0003\"\u0002(\u0007\u0001\u0004!\u0013!B3wK:$\u0018!\u00033s_B,e/\u001a8u+\u0005\t\u0006C\u0001*T\u001b\u0005\u0001\u0011B\u0001+\u001f\u0005%!%o\u001c9Fm\u0016tG/\u0001\u0006ee>\u0004XI^3oi\u0002\u0002")
public class ServerListenerEventBus
extends ListenerEventBus<ServerEventService, SocketServerEvent> {
    private final ListenerEventBus.DropEvent dropEvent = new ListenerEventBus.DropEvent(null){

        public void onDropEvent(SocketServerEvent event) {
            throw new BDPServerErrorException(LinkisModuleErrorCodeSummary.WEBSOCKET_STOPPED.getErrorCode(), LinkisModuleErrorCodeSummary.WEBSOCKET_STOPPED.getErrorDesc());
        }

        public void onBusStopped(SocketServerEvent event) {
            throw new BDPServerErrorException(LinkisModuleErrorCodeSummary.WEBSOCKET_IS_FULL.getErrorCode(), LinkisModuleErrorCodeSummary.WEBSOCKET_IS_FULL.getErrorDesc());
        }
    };

    public void doPostEvent(ServerEventService listener, SocketServerEvent event) {
        ServerEvent serverEvent = event.serverEvent();
        if (StringUtils.isEmpty((CharSequence)serverEvent.getMethod())) {
            this.logger().info(new StringBuilder(25).append("ignore empty method with ").append(serverEvent.getData()).toString());
            return;
        }
        if (serverEvent.getMethod().startsWith(listener.serviceName())) {
            Message response = listener.onEvent(serverEvent);
            if (response != null) {
                response.setMethod(serverEvent.getMethod());
                event.socket().sendMessage(Message$.MODULE$.response(response));
                return;
            }
            return;
        }
    }

    public ListenerEventBus.DropEvent dropEvent() {
        return this.dropEvent;
    }

    public ServerListenerEventBus(int eventQueueCapacity, String name, int listenerConsumerThreadSize, long listenerThreadMaxFreeTime) {
        super(eventQueueCapacity, name, listenerConsumerThreadSize, listenerThreadMaxFreeTime);
    }
}

