/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.utils;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseValueVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class ArrowUtils$ {
    public static ArrowUtils$ MODULE$;

    static {
        new ArrowUtils$();
    }

    public byte[] toArrow(Dataset<Row> df) {
        RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
        Tuple2<VectorSchemaRoot, List<FieldVector>> tuple2 = this.createArrowVectors(df, allocator);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        VectorSchemaRoot root = (VectorSchemaRoot)tuple2._1();
        List fieldVectors = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)root, (Object)fieldVectors);
        VectorSchemaRoot root2 = (VectorSchemaRoot)tuple22._1();
        List fieldVectors2 = (List)tuple22._2();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ArrowStreamWriter writer = new ArrowStreamWriter(root2, null, (OutputStream)outStream);
        writer.start();
        writer.writeBatch();
        writer.end();
        writer.close();
        byte[] arrowBytes = outStream.toByteArray();
        fieldVectors2.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        allocator.close();
        return arrowBytes;
    }

    private Tuple2<VectorSchemaRoot, List<FieldVector>> createArrowVectors(Dataset<Row> df, RootAllocator allocator) {
        StructType schema = df.schema();
        List fieldVectors = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            DataType dataType = field.dataType();
            if (IntegerType$.MODULE$.equals(dataType)) {
                IntVector vector = new IntVector(field.name(), (BufferAllocator)allocator);
                vector.allocateNew((int)df.count());
                return vector;
            }
            if (LongType$.MODULE$.equals(dataType)) {
                BigIntVector vector = new BigIntVector(field.name(), (BufferAllocator)allocator);
                vector.allocateNew((int)df.count());
                return vector;
            }
            if (DoubleType$.MODULE$.equals(dataType)) {
                Float8Vector vector = new Float8Vector(field.name(), (BufferAllocator)allocator);
                vector.allocateNew((int)df.count());
                return vector;
            }
            if (BooleanType$.MODULE$.equals(dataType)) {
                BitVector vector = new BitVector(field.name(), (BufferAllocator)allocator);
                vector.allocateNew((int)df.count());
                return vector;
            }
            VarCharVector vector = new VarCharVector(field.name(), (BufferAllocator)allocator);
            vector.allocateNew((int)df.count());
            return vector;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BaseValueVector.class))))).toList();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.collect())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArrowUtils$.$anonfun$createArrowVectors$2(fieldVectors, x0$1);
            return BoxedUnit.UNIT;
        });
        ArrayList javaFieldVectors = new ArrayList();
        fieldVectors.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)javaFieldVectors.add(x$1)));
        VectorSchemaRoot root = new VectorSchemaRoot(javaFieldVectors);
        return new Tuple2((Object)root, (Object)fieldVectors);
    }

    public static final /* synthetic */ void $anonfun$createArrowVectors$2(List fieldVectors$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Row row = (Row)tuple2._1();
            int i = tuple2._2$mcI$sp();
            fieldVectors$1.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
                BaseValueVector vector = (BaseValueVector)fieldVectors$1.apply(j);
                DataType dataType = row.schema().fields()[j].dataType();
                if (IntegerType$.MODULE$.equals(dataType)) {
                    ((IntVector)vector).setSafe(i, row.getInt(j));
                } else if (LongType$.MODULE$.equals(dataType)) {
                    ((BigIntVector)vector).setSafe(i, row.getLong(j));
                } else if (DoubleType$.MODULE$.equals(dataType)) {
                    ((Float8Vector)vector).setSafe(i, row.getDouble(j));
                } else if (BooleanType$.MODULE$.equals(dataType)) {
                    ((BitVector)vector).setSafe(i, row.getBoolean(j) ? 1 : 0);
                } else {
                    ((VarCharVector)vector).setSafe(i, row.getString(j).getBytes());
                }
                vector.setValueCount(vector.getValueCount() + 1);
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private ArrowUtils$() {
        MODULE$ = this;
    }
}

