/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.interceptor.impl;

import java.io.Serializable;
import org.apache.linkis.common.utils.CodeAndRunTypeUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.entrance.errorcode.EntranceErrorCodeSummary;
import org.apache.linkis.entrance.exception.DangerousGramsCheckException;
import org.apache.linkis.entrance.interceptor.EntranceInterceptor;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.manager.label.entity.engine.EngineType$;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!4Aa\u0003\u0007\u00013!)A\u0006\u0001C\u0001[!9\u0001\u0007\u0001b\u0001\n\u0013\t\u0004BB\u001b\u0001A\u0003%!\u0007C\u00047\u0001\t\u0007I\u0011B\u001c\t\r\u0001\u0003\u0001\u0015!\u00039\u0011\u001d\t\u0005A1A\u0005\n]BaA\u0011\u0001!\u0002\u0013A\u0004\"B\"\u0001\t\u0003!\u0005\"B)\u0001\t\u0003\u0011\u0006\"\u0002+\u0001\t\u0003*&\u0001I*iK2dG)\u00198hKJ|Wo]$sC6lWM]%oi\u0016\u00148-\u001a9u_JT!!\u0004\b\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u001fA\t1\"\u001b8uKJ\u001cW\r\u001d;pe*\u0011\u0011CE\u0001\tK:$(/\u00198dK*\u00111\u0003F\u0001\u0007Y&t7.[:\u000b\u0005U1\u0012AB1qC\u000eDWMC\u0001\u0018\u0003\ry'oZ\u0002\u0001'\u0011\u0001!\u0004\t\u0013\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g!\t\t#%D\u0001\u000f\u0013\t\u0019cBA\nF]R\u0014\u0018M\\2f\u0013:$XM]2faR|'\u000f\u0005\u0002&U5\taE\u0003\u0002(Q\u0005)Q\u000f^5mg*\u0011\u0011FE\u0001\u0007G>lWn\u001c8\n\u0005-2#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\u0002\"a\f\u0001\u000e\u00031\t\u0001e\u001d5fY2$\u0015M\\4fe>,8o\u0012:b[6,'o\u00115fG.\u001cv/\u001b;dQV\t!\u0007\u0005\u0002\u001cg%\u0011A\u0007\b\u0002\b\u0005>|G.Z1o\u0003\u0005\u001a\b.\u001a7m\t\u0006tw-\u001a:pkN<%/Y7nKJ\u001c\u0005.Z2l'^LGo\u00195!\u0003=\u0019\b.\u001a7m\t\u0006tw-\u001a:D_\u0012,W#\u0001\u001d\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014\u0001\u00027b]\u001eT\u0011!P\u0001\u0005U\u00064\u0018-\u0003\u0002@u\t11\u000b\u001e:j]\u001e\f\u0001c\u001d5fY2$\u0015M\\4fe\u000e{G-\u001a\u0011\u0002\u001fMDW\r\u001c7XQ&$XmQ8eKN\f\u0001c\u001d5fY2<\u0006.\u001b;f\u0007>$Wm\u001d\u0011\u0002\u001fMDW\r\u001c7XQ&$X-V:bO\u0016$\"AM#\t\u000b\u0019C\u0001\u0019A$\u0002\u0019MDW\r\u001c7D_:$XM\u001c;\u0011\u0005!{eBA%N!\tQE$D\u0001L\u0015\ta\u0005$\u0001\u0004=e>|GOP\u0005\u0003\u001dr\ta\u0001\u0015:fI\u00164\u0017BA Q\u0015\tqE$A\ftQ\u0016dGnQ8oi\u0006Lg\u000eR1oO\u0016\u0014Xk]1hKR\u0011!g\u0015\u0005\u0006\r&\u0001\raR\u0001\u0006CB\u0004H.\u001f\u000b\u0004-\u0006\u001c\u0007CA,`\u001b\u0005A&BA-[\u0003\rQwN\u0019\u0006\u00037r\u000ba!\u001a8uSRL(BA\u0015^\u0015\tq&#\u0001\u0006h_Z,'O\\1oG\u0016L!\u0001\u0019-\u0003\u0015){'MU3rk\u0016\u001cH\u000fC\u0003c\u0015\u0001\u0007a+\u0001\u0006k_\n\u0014V-];fgRDQ\u0001\u001a\u0006A\u0002\u0015\f1\u0002\\8h\u0003B\u0004XM\u001c3feB\u0011\u0011HZ\u0005\u0003Oj\u0012Qb\u0015;sS:<')^5mI\u0016\u0014\b")
public class ShellDangerousGrammerInterceptor
implements EntranceInterceptor,
Logging {
    private final boolean shellDangerousGrammerCheckSwitch;
    private final String shellDangerCode;
    private final String shellWhiteCodes;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        ShellDangerousGrammerInterceptor shellDangerousGrammerInterceptor = this;
        synchronized (shellDangerousGrammerInterceptor) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private boolean shellDangerousGrammerCheckSwitch() {
        return this.shellDangerousGrammerCheckSwitch;
    }

    private String shellDangerCode() {
        return this.shellDangerCode;
    }

    private String shellWhiteCodes() {
        return this.shellWhiteCodes;
    }

    public boolean shellWhiteUsage(String shellContent) {
        String[] shellLines = shellContent.split("\n");
        BooleanRef signature = BooleanRef.create((boolean)false);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])shellLines)).foreach((Function1 & Serializable & scala.Serializable)shellLine -> {
            ShellDangerousGrammerInterceptor.$anonfun$shellWhiteUsage$1(this, signature, shellLine);
            return BoxedUnit.UNIT;
        });
        return signature.elem;
    }

    public boolean shellContainDangerUsage(String shellContent) {
        String[] shellLines = shellContent.split("\n");
        BooleanRef signature = BooleanRef.create((boolean)false);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])shellLines)).foreach((Function1 & Serializable & scala.Serializable)shellLine -> {
            ShellDangerousGrammerInterceptor.$anonfun$shellContainDangerUsage$1(this, signature, shellLine);
            return BoxedUnit.UNIT;
        });
        return signature.elem;
    }

    @Override
    public JobRequest apply(JobRequest jobRequest, StringBuilder logAppender) {
        if (!this.shellDangerousGrammerCheckSwitch()) {
            return jobRequest;
        }
        String codeType = LabelUtil$.MODULE$.getCodeType(jobRequest.getLabels());
        String languageType = CodeAndRunTypeUtils$.MODULE$.getLanguageTypeByCodeType(codeType, CodeAndRunTypeUtils$.MODULE$.getLanguageTypeByCodeType$default$2());
        String engineType = LabelUtil$.MODULE$.getEngineType(jobRequest.getLabels());
        if (CodeAndRunTypeUtils$.MODULE$.LANGUAGE_TYPE_SHELL().equals(languageType) || EngineType$.MODULE$.SHELL().equals((Object)EngineType$.MODULE$.mapStringToEngineType(engineType))) {
            this.logger().info(new StringBuilder(39).append("GET REQUEST CODE_TYPE ").append(codeType).append(" and ENGINE_TYPE ").append(EngineType$.MODULE$).toString());
            if (this.shellContainDangerUsage(jobRequest.getExecutionCode())) {
                throw new DangerousGramsCheckException(EntranceErrorCodeSummary.SHELL_BLACKLISTED_CODE.getErrorDesc());
            }
            return jobRequest;
        }
        return jobRequest;
    }

    public static final /* synthetic */ void $anonfun$shellWhiteUsage$2(ShellDangerousGrammerInterceptor $this, BooleanRef signature$1, String inner) {
        String shellCommand = inner.trim().split(" ")[0];
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.shellWhiteCodes().split(","))).contains((Object)shellCommand)) {
            signature$1.elem = true;
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$shellWhiteUsage$1(ShellDangerousGrammerInterceptor $this, BooleanRef signature$1, String shellLine) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])shellLine.split(";"))).foreach((Function1 & Serializable & scala.Serializable)inner -> {
            ShellDangerousGrammerInterceptor.$anonfun$shellWhiteUsage$2($this, signature$1, inner);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$shellContainDangerUsage$2(ShellDangerousGrammerInterceptor $this, BooleanRef signature$2, String shellCommand) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.shellDangerCode().split(","))).contains((Object)shellCommand)) {
            signature$2.elem = true;
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$shellContainDangerUsage$1(ShellDangerousGrammerInterceptor $this, BooleanRef signature$2, String shellLine) {
        if (shellLine.trim().endsWith(".sh")) {
            signature$2.elem = true;
            return;
        }
        String[] shellCommands = shellLine.trim().split(" ");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])shellCommands)).foreach((Function1 & Serializable & scala.Serializable)shellCommand -> {
            ShellDangerousGrammerInterceptor.$anonfun$shellContainDangerUsage$2($this, signature$2, shellCommand);
            return BoxedUnit.UNIT;
        });
    }

    public ShellDangerousGrammerInterceptor() {
        block0: {
            Logging.$init$((Logging)this);
            this.shellDangerousGrammerCheckSwitch = BoxesRunTime.unboxToBoolean((Object)EntranceConfiguration$.MODULE$.SHELL_DANGER_CHECK_SWITCH().getValue());
            this.shellDangerCode = (String)EntranceConfiguration$.MODULE$.SHELL_DANGER_USAGE().getValue();
            this.shellWhiteCodes = (String)EntranceConfiguration$.MODULE$.SHELL_WHITE_USAGE().getValue();
            this.logger().info(new StringBuilder(35).append("shellDangerousGrammerCheckSwitch : ").append(this.shellDangerousGrammerCheckSwitch()).toString());
            if (!this.shellDangerousGrammerCheckSwitch()) break block0;
            this.logger().info(new StringBuilder(19).append("SHELL DANGER USAGE ").append(this.shellDangerCode()).toString());
            this.logger().info(new StringBuilder(18).append("SHELL White USAGE ").append(this.shellWhiteCodes()).toString());
        }
    }
}

