/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.restful;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.entrance.EntranceServer;
import org.apache.linkis.scheduler.queue.ConsumerManager;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"entrance lable manager"})
@RestController
@RequestMapping(path={"/entrance/operation/consumer"})
public class EntranceConsumerRestfulApi {
    private EntranceServer entranceServer;
    private static final Logger logger = LoggerFactory.getLogger(EntranceConsumerRestfulApi.class);

    @Autowired
    public void setEntranceServer(EntranceServer entranceServer) {
        this.entranceServer = entranceServer;
    }

    @ApiOperation(value="kill-consumer", notes="kill consumer", response=Message.class)
    @RequestMapping(path={"/kill"}, method={RequestMethod.GET})
    public Message killConsumer(HttpServletRequest req, @RequestParam(value="groupName") String groupName) {
        String operationUser = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"kill consumer");
        if (Configuration.isNotAdmin((String)operationUser)) {
            return Message.error((String)"only admin can do this");
        }
        logger.info("user {} to kill consumer {}", (Object)operationUser, (Object)groupName);
        ConsumerManager consumerManager = this.entranceServer.getEntranceContext().getOrCreateScheduler().getSchedulerContext().getOrCreateConsumerManager();
        consumerManager.destroyConsumer(groupName);
        logger.info("user {} finished to kill consumer {}", (Object)operationUser, (Object)groupName);
        return Message.ok();
    }

    @ApiOperation(value="consumer-info", notes="list consumers info", response=Message.class)
    @RequestMapping(path={"/info"}, method={RequestMethod.GET})
    public Message countConsumer(HttpServletRequest req) {
        String operationUser = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"kill consumer");
        if (Configuration.isNotAdmin((String)operationUser)) {
            return Message.error((String)"only admin can do this");
        }
        ConsumerManager consumerManager = this.entranceServer.getEntranceContext().getOrCreateScheduler().getSchedulerContext().getOrCreateConsumerManager();
        return Message.ok().data("consumerNum", (Object)consumerManager.listConsumers().length);
    }
}

