/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.client.deployment.util;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.engineplugin.spark.client.deployment.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesHelper {
    private static final Logger logger = LoggerFactory.getLogger(KubernetesHelper.class);

    public static KubernetesClient getKubernetesClientByUrl(String k8sMasterUrl, String k8sUsername, String k8sPassword) {
        Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(k8sMasterUrl)).withUsername(k8sUsername)).withPassword(k8sPassword)).build();
        DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient(config);
        logger.info("KubernetesClient Create success,kubernetesClient masterUrl: {}", (Object)kubernetesClient.getMasterUrl().toString());
        return kubernetesClient;
    }

    public static KubernetesClient getKubernetesClientByUrl(String k8sMasterUrl) {
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(k8sMasterUrl)).build();
        DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient(config);
        logger.info("KubernetesClient Create success,kubernetesClient masterUrl: {}", (Object)kubernetesClient.getMasterUrl().toString());
        return kubernetesClient;
    }

    public static KubernetesClient getKubernetesClient(String kubeConfigFile, String k8sMasterUrl, String k8sUsername, String k8sPassword) {
        logger.info("Start create KubernetesClient,kubeConfigFile: {},k8sMasterUrl: {}", (Object)kubeConfigFile, (Object)k8sMasterUrl);
        if (StringUtils.isBlank((CharSequence)kubeConfigFile) && StringUtils.isBlank((CharSequence)kubeConfigFile)) {
            throw new KubernetesClientException("Both kubeConfigFile and k8sMasterUrl are empty. Initializing KubernetesClient failed.");
        }
        if (StringUtils.isNotBlank((CharSequence)kubeConfigFile)) {
            return KubernetesHelper.getKubernetesClientByKubeConfigFile(kubeConfigFile);
        }
        if (StringUtils.isNotBlank((CharSequence)k8sMasterUrl) && StringUtils.isNotBlank((CharSequence)k8sUsername) && StringUtils.isNotBlank((CharSequence)k8sPassword)) {
            return KubernetesHelper.getKubernetesClientByUrl(k8sMasterUrl, k8sUsername, k8sPassword);
        }
        if (StringUtils.isNotBlank((CharSequence)k8sMasterUrl)) {
            return KubernetesHelper.getKubernetesClientByUrl(k8sMasterUrl);
        }
        throw new KubernetesClientException("Initializing KubernetesClient failed.");
    }

    public static KubernetesClient getKubernetesClientByKubeConfigFile(String kubeConfigFile) {
        Config config;
        if (kubeConfigFile != null) {
            try {
                config = Config.fromKubeconfig(null, (String)FileUtils.readFileUtf8(new File(kubeConfigFile)), null);
            }
            catch (IOException e) {
                throw new KubernetesClientException("Load kubernetes config failed.", (Throwable)e);
            }
        } else {
            config = Config.autoConfigure(null);
        }
        DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient(config);
        logger.info("KubernetesClient Create success,kubernetesClient masterUrl: {}", (Object)kubernetesClient.getMasterUrl().toString());
        return kubernetesClient;
    }
}

