/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.sink;

import org.apache.commons.text.StringSubstitutor;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcPlugin;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcSink;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcPluginConfig;
import org.apache.linkis.engineplugin.spark.datacalc.model.SinkConfig;
import org.apache.linkis.engineplugin.spark.datacalc.sink.FileSinkConfig;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import scala.Function0;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00113Aa\u0001\u0003\u0001'!)A\u0006\u0001C\u0001[!)q\u0006\u0001C\u0001a\tAa)\u001b7f'&t7N\u0003\u0002\u0006\r\u0005!1/\u001b8l\u0015\t9\u0001\"\u0001\u0005eCR\f7-\u00197d\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u0005aQM\\4j]\u0016\u0004H.^4j]*\u0011QBD\u0001\u0007Y&t7.[:\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\u0011\u0001AC\u0007\u0013\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g!\rYb\u0004I\u0007\u00029)\u0011QDB\u0001\u0004CBL\u0017BA\u0010\u001d\u00051!\u0015\r^1DC2\u001c7+\u001b8l!\t\t#%D\u0001\u0005\u0013\t\u0019CA\u0001\bGS2,7+\u001b8l\u0007>tg-[4\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001dB\u0013!B;uS2\u001c(BA\u0015\r\u0003\u0019\u0019w.\\7p]&\u00111F\n\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\ta\u0006\u0005\u0002\"\u0001\u00051q.\u001e;qkR$2!\r\u001b=!\t)\"'\u0003\u00024-\t!QK\\5u\u0011\u0015I!\u00011\u00016!\t1$(D\u00018\u0015\tA\u0014(A\u0002tc2T!!\u0003\b\n\u0005m:$\u0001D*qCJ\\7+Z:tS>t\u0007\"B\u001f\u0003\u0001\u0004q\u0014A\u00013t!\r1t(Q\u0005\u0003\u0001^\u0012q\u0001R1uCN,G\u000f\u0005\u00027\u0005&\u00111i\u000e\u0002\u0004%><\b")
public class FileSink
implements DataCalcSink<FileSinkConfig>,
Logging {
    private Logger logger;
    private FileSinkConfig config;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    @Override
    public Object getConfig() {
        return DataCalcPlugin.getConfig$(this);
    }

    @Override
    public void setConfig(Object config) {
        DataCalcPlugin.setConfig$(this, config);
    }

    @Override
    public void prepare(SparkSession spark) {
        DataCalcPlugin.prepare$(this, spark);
    }

    private Logger logger$lzycompute() {
        FileSink fileSink = this;
        synchronized (fileSink) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public FileSinkConfig config() {
        return this.config;
    }

    @Override
    public void config_$eq(FileSinkConfig x$1) {
        this.config = x$1;
    }

    @Override
    public void output(SparkSession spark, Dataset<Row> ds) {
        BoxedUnit boxedUnit;
        DataFrameWriter writer = ds.write().mode(((FileSinkConfig)this.config()).getSaveMode());
        if (((FileSinkConfig)this.config()).getPartitionBy() != null && !((FileSinkConfig)this.config()).getPartitionBy().isEmpty()) {
            Buffer partitionKeys = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((FileSinkConfig)this.config()).getPartitionBy()).asScala();
            boxedUnit = writer.partitionBy((Seq)partitionKeys);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = ((SinkConfig)this.config()).getOptions() != null && !((SinkConfig)this.config()).getOptions().isEmpty() ? writer.options(((SinkConfig)this.config()).getOptions()) : BoxedUnit.UNIT;
        StringSubstitutor substitutor = new StringSubstitutor(((DataCalcPluginConfig)this.config()).getVariables());
        String path = substitutor.replace(((FileSinkConfig)this.config()).getPath());
        this.logger().info(new StringBuilder(25).append("Save data to file, path: ").append(path).toString());
        String string = ((FileSinkConfig)this.config()).getSerializer();
        if ("csv".equals(string)) {
            writer.csv(path);
            return;
        }
        if ("json".equals(string)) {
            writer.json(path);
            return;
        }
        if ("parquet".equals(string)) {
            writer.parquet(path);
            return;
        }
        if ("text".equals(string)) {
            writer.text(path);
            return;
        }
        if ("orc".equals(string)) {
            writer.orc(path);
            return;
        }
        if ("excel".equals(string)) {
            writer.format("excel").save(path);
            return;
        }
        writer.format(((FileSinkConfig)this.config()).getSerializer()).save(path);
    }

    public FileSink() {
        DataCalcPlugin.$init$(this);
        Logging.$init$((Logging)this);
    }
}

