/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.service.postgres;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.metadata.query.service.AbstractSqlConnection;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlConnection
extends AbstractSqlConnection {
    private static final Logger LOG = LoggerFactory.getLogger(SqlConnection.class);
    private static final CommonVars<String> SQL_DRIVER_CLASS = CommonVars.apply((String)"wds.linkis.server.mdm.service.postgre.driver", (Object)"org.postgresql.Driver");
    private static final CommonVars<String> SQL_CONNECT_URL = CommonVars.apply((String)"wds.linkis.server.mdm.service.postgre.url", (Object)"jdbc:postgresql://%s:%s/%s");

    public SqlConnection(String host, Integer port, String username, String password, String database, Map<String, Object> extraParams) throws ClassNotFoundException, SQLException {
        super(host, port, username, password, Strings.isBlank((String)database) ? "" : database, extraParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllDatabases() throws SQLException {
        ArrayList<String> dataBaseName = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery("select datname from pg_database");
            while (rs.next()) {
                dataBaseName.add(rs.getString(1));
            }
        }
        catch (Throwable throwable) {
            this.closeResource(null, stmt, rs);
            throw throwable;
        }
        this.closeResource(null, stmt, rs);
        return dataBaseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllTables(String schemaname) throws SQLException {
        ArrayList<String> arrayList;
        ArrayList<String> tableNames = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery("SELECT tablename FROM pg_tables where schemaname = '" + schemaname + "'");
            while (rs.next()) {
                tableNames.add(rs.getString(1));
            }
            arrayList = tableNames;
        }
        catch (Throwable throwable) {
            this.closeResource(null, stmt, rs);
            throw throwable;
        }
        this.closeResource(null, stmt, rs);
        return arrayList;
    }

    @Override
    public Connection getDBConnection(AbstractSqlConnection.ConnectMessage connectMessage, String database) throws ClassNotFoundException, SQLException {
        Class.forName((String)SQL_DRIVER_CLASS.getValue());
        String url = String.format((String)SQL_CONNECT_URL.getValue(), connectMessage.host, connectMessage.port, database);
        if (MapUtils.isNotEmpty(connectMessage.extraParams)) {
            String extraParamString = connectMessage.extraParams.entrySet().stream().map(e -> String.join((CharSequence)"=", (CharSequence)e.getKey(), String.valueOf(e.getValue()))).collect(Collectors.joining("&"));
            url = url + "?" + extraParamString;
        }
        return DriverManager.getConnection(url, connectMessage.username, connectMessage.password);
    }

    public String getSqlConnectUrl() {
        return (String)SQL_CONNECT_URL.getValue();
    }
}

