/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.clone;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.clone.ColumnLoader;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;

class ArrayTable
extends AbstractQueryableTable
implements ScannableTable {
    private final RelProtoDataType protoRowType;
    private final Supplier<Content> supplier;

    ArrayTable(Type elementType, RelProtoDataType protoRowType, Supplier<Content> supplier) {
        super(elementType);
        this.protoRowType = protoRowType;
        this.supplier = supplier;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.protoRowType.apply(typeFactory);
    }

    @Override
    public Statistic getStatistic() {
        ArrayList keys = Lists.newArrayList();
        Content content = (Content)this.supplier.get();
        for (Ord ord : Ord.zip((List)content.columns)) {
            if (((Column)ord.e).cardinality != content.size) continue;
            keys.add(ImmutableBitSet.of(ord.i));
        }
        return Statistics.of(content.size, keys, (List<RelCollation>)content.collations);
    }

    @Override
    public Enumerable<Object[]> scan(DataContext root) {
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<Object[]> enumerator() {
                Content content = (Content)ArrayTable.this.supplier.get();
                return content.arrayEnumerator();
            }
        };
    }

    @Override
    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new AbstractTableQueryable<T>(queryProvider, schema, this, tableName){

            public Enumerator<T> enumerator() {
                Content content = (Content)ArrayTable.this.supplier.get();
                return content.enumerator();
            }
        };
    }

    private static <T> Pair<Object, T> toPair(Object dataSet) {
        return (Pair)dataSet;
    }

    private static <E> List<E> permuteList(final List<E> list, final int[] sources) {
        if (sources == null) {
            return list;
        }
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return list.get(sources[index]);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static class Content {
        private final List<Column> columns;
        private final int size;
        private final ImmutableList<RelCollation> collations;

        Content(List<? extends Column> columns, int size, Iterable<? extends RelCollation> collations) {
            this.columns = ImmutableList.copyOf(columns);
            this.size = size;
            this.collations = ImmutableList.copyOf(collations);
        }

        @Deprecated
        Content(List<? extends Column> columns, int size, int sortField) {
            this(columns, size, (Iterable<? extends RelCollation>)(sortField >= 0 ? RelCollations.createSingleton(sortField) : ImmutableList.of()));
        }

        public <T> Enumerator<T> enumerator() {
            if (this.columns.size() == 1) {
                return new ObjectEnumerator(this.size, this.columns.get(0));
            }
            return new ArrayEnumerator(this.size, this.columns);
        }

        public Enumerator<Object[]> arrayEnumerator() {
            return new ArrayEnumerator(this.size, this.columns);
        }

        private static class ArrayEnumerator
        implements Enumerator<Object[]> {
            final int rowCount;
            final List<Column> columns;
            int i = -1;

            ArrayEnumerator(int rowCount, List<Column> columns) {
                this.rowCount = rowCount;
                this.columns = columns;
            }

            public Object[] current() {
                Object[] objects = new Object[this.columns.size()];
                for (int j = 0; j < objects.length; ++j) {
                    Column pair = this.columns.get(j);
                    objects[j] = pair.representation.getObject(pair.dataSet, this.i);
                }
                return objects;
            }

            public boolean moveNext() {
                return ++this.i < this.rowCount;
            }

            public void reset() {
                this.i = -1;
            }

            public void close() {
            }
        }

        private static class ObjectEnumerator
        implements Enumerator<Object> {
            final int rowCount;
            final Object dataSet;
            final Representation representation;
            int i = -1;

            ObjectEnumerator(int rowCount, Column column) {
                this.rowCount = rowCount;
                this.dataSet = column.dataSet;
                this.representation = column.representation;
            }

            public Object current() {
                return this.representation.getObject(this.dataSet, this.i);
            }

            public boolean moveNext() {
                return ++this.i < this.rowCount;
            }

            public void reset() {
                this.i = -1;
            }

            public void close() {
            }
        }
    }

    public static class BitSlicedPrimitiveArray
    implements Representation {
        final int ordinal;
        final int bitCount;
        final Primitive primitive;
        final boolean signed;

        BitSlicedPrimitiveArray(int ordinal, int bitCount, Primitive primitive, boolean signed) {
            assert (bitCount > 0);
            this.ordinal = ordinal;
            this.bitCount = bitCount;
            this.primitive = primitive;
            this.signed = signed;
        }

        public String toString() {
            return "BitSlicedPrimitiveArray(ordinal=" + this.ordinal + ", bitCount=" + this.bitCount + ", primitive=" + this.primitive + ", signed=" + this.signed + ")";
        }

        @Override
        public RepresentationType getType() {
            return RepresentationType.BIT_SLICED_PRIMITIVE_ARRAY;
        }

        @Override
        public Object freeze(ColumnLoader.ValueSet valueSet, int[] sources) {
            int chunksPerWord = 64 / this.bitCount;
            List valueList = ArrayTable.permuteList(valueSet.values, sources);
            int valueCount = valueList.size();
            int wordCount = (valueCount + (chunksPerWord - 1)) / chunksPerWord;
            int remainingChunkCount = valueCount % chunksPerWord;
            long[] longs = new long[wordCount];
            int n = valueCount / chunksPerWord;
            int k = 0;
            if (valueCount > 0 && valueList.get(0) instanceof Boolean) {
                int j;
                long v;
                List booleans = valueList;
                for (int i = 0; i < n; ++i) {
                    v = 0L;
                    for (j = 0; j < chunksPerWord; ++j) {
                        v |= (Boolean)booleans.get(k++) != false ? (long)(1 << this.bitCount * j) : 0L;
                    }
                    longs[i] = v;
                }
                if (remainingChunkCount > 0) {
                    v = 0L;
                    for (j = 0; j < remainingChunkCount; ++j) {
                        v |= (Boolean)booleans.get(k++) != false ? (long)(1 << this.bitCount * j) : 0L;
                    }
                    longs[i] = v;
                }
            } else {
                int j;
                long v;
                List numbers = valueList;
                for (int i = 0; i < n; ++i) {
                    v = 0L;
                    for (j = 0; j < chunksPerWord; ++j) {
                        v |= ((Number)numbers.get(k++)).longValue() << this.bitCount * j;
                    }
                    longs[i] = v;
                }
                if (remainingChunkCount > 0) {
                    v = 0L;
                    for (j = 0; j < remainingChunkCount; ++j) {
                        v |= ((Number)numbers.get(k++)).longValue() << this.bitCount * j;
                    }
                    longs[i] = v;
                }
            }
            return longs;
        }

        @Override
        public Object permute(Object dataSet, int[] sources) {
            long[] longs0 = (long[])dataSet;
            int n = sources.length;
            long[] longs = new long[longs0.length];
            for (int i = 0; i < n; ++i) {
                BitSlicedPrimitiveArray.orLong(this.bitCount, longs, i, BitSlicedPrimitiveArray.getLong(this.bitCount, longs0, sources[i]));
            }
            return longs;
        }

        @Override
        public Object getObject(Object dataSet, int ordinal) {
            long[] longs = (long[])dataSet;
            int chunksPerWord = 64 / this.bitCount;
            int word = ordinal / chunksPerWord;
            long v = longs[word];
            int chunk = ordinal % chunksPerWord;
            int mask = (1 << this.bitCount) - 1;
            int signMask = 1 << this.bitCount - 1;
            int shift = chunk * this.bitCount;
            long w = v >> shift;
            long x = w & (long)mask;
            if (this.signed && (x & (long)signMask) != 0L) {
                x = -x;
            }
            switch (this.primitive) {
                case BOOLEAN: {
                    return x != 0L;
                }
                case BYTE: {
                    return (byte)x;
                }
                case CHAR: {
                    return Character.valueOf((char)x);
                }
                case SHORT: {
                    return (short)x;
                }
                case INT: {
                    return (int)x;
                }
                case LONG: {
                    return x;
                }
            }
            throw new AssertionError((Object)(this.primitive + " unexpected"));
        }

        @Override
        public int getInt(Object dataSet, int ordinal) {
            long[] longs = (long[])dataSet;
            int chunksPerWord = 64 / this.bitCount;
            int word = ordinal / chunksPerWord;
            long v = longs[word];
            int chunk = ordinal % chunksPerWord;
            int mask = (1 << this.bitCount) - 1;
            int signMask = 1 << this.bitCount - 1;
            int shift = chunk * this.bitCount;
            long w = v >> shift;
            long x = w & (long)mask;
            if (this.signed && (x & (long)signMask) != 0L) {
                x = -x;
            }
            return (int)x;
        }

        public static long getLong(int bitCount, long[] values, int ordinal) {
            return BitSlicedPrimitiveArray.getLong(bitCount, 64 / bitCount, (1L << bitCount) - 1L, values, ordinal);
        }

        public static long getLong(int bitCount, int chunksPerWord, long mask, long[] values, int ordinal) {
            int word = ordinal / chunksPerWord;
            int chunk = ordinal % chunksPerWord;
            long value = values[word];
            int shift = chunk * bitCount;
            return value >> shift & mask;
        }

        public static void orLong(int bitCount, long[] values, int ordinal, long value) {
            BitSlicedPrimitiveArray.orLong(bitCount, 64 / bitCount, values, ordinal, value);
        }

        public static void orLong(int bitCount, int chunksPerWord, long[] values, int ordinal, long value) {
            int word = ordinal / chunksPerWord;
            int chunk = ordinal % chunksPerWord;
            int shift = chunk * bitCount;
            int n = word;
            values[n] = values[n] | value << shift;
        }

        @Override
        public int size(Object dataSet) {
            long[] longs = (long[])dataSet;
            int chunksPerWord = 64 / this.bitCount;
            return longs.length * chunksPerWord;
        }

        @Override
        public String toString(Object dataSet) {
            return Column.asList(this, dataSet).toString();
        }
    }

    public static class Constant
    implements Representation {
        final int ordinal;

        Constant(int ordinal) {
            this.ordinal = ordinal;
        }

        public String toString() {
            return "Constant(ordinal=" + this.ordinal + ")";
        }

        @Override
        public RepresentationType getType() {
            return RepresentationType.CONSTANT;
        }

        @Override
        public Object freeze(ColumnLoader.ValueSet valueSet, int[] sources) {
            int size = valueSet.values.size();
            return Pair.of(size == 0 ? null : valueSet.values.get(0), size);
        }

        @Override
        public Object permute(Object dataSet, int[] sources) {
            return dataSet;
        }

        @Override
        public Object getObject(Object dataSet, int ordinal) {
            Pair pair = ArrayTable.toPair(dataSet);
            return pair.left;
        }

        @Override
        public int getInt(Object dataSet, int ordinal) {
            Pair pair = ArrayTable.toPair(dataSet);
            return ((Number)pair.left).intValue();
        }

        @Override
        public int size(Object dataSet) {
            Pair pair = ArrayTable.toPair(dataSet);
            return (Integer)pair.right;
        }

        @Override
        public String toString(Object dataSet) {
            Pair pair = ArrayTable.toPair(dataSet);
            return Collections.nCopies((Integer)pair.right, pair.left).toString();
        }
    }

    public static class ByteStringDictionary
    implements Representation {
        ByteStringDictionary() {
        }

        public String toString() {
            return "ByteStringDictionary()";
        }

        @Override
        public RepresentationType getType() {
            return RepresentationType.BYTE_STRING_DICTIONARY;
        }

        @Override
        public Object freeze(ColumnLoader.ValueSet valueSet, int[] sources) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object permute(Object dataSet, int[] sources) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getObject(Object dataSet, int ordinal) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getInt(Object dataSet, int ordinal) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size(Object dataSet) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString(Object dataSet) {
            return Column.asList(this, dataSet).toString();
        }
    }

    public static class StringDictionary
    implements Representation {
        StringDictionary() {
        }

        public String toString() {
            return "StringDictionary()";
        }

        @Override
        public RepresentationType getType() {
            return RepresentationType.STRING_DICTIONARY;
        }

        @Override
        public Object freeze(ColumnLoader.ValueSet valueSet, int[] sources) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object permute(Object dataSet, int[] sources) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getObject(Object dataSet, int ordinal) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getInt(Object dataSet, int ordinal) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size(Object dataSet) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString(Object dataSet) {
            return Column.asList(this, dataSet).toString();
        }
    }

    public static class ObjectDictionary
    implements Representation {
        final int ordinal;
        final Representation representation;

        ObjectDictionary(int ordinal, Representation representation) {
            this.ordinal = ordinal;
            this.representation = representation;
        }

        public String toString() {
            return "ObjectDictionary(ordinal=" + this.ordinal + ", representation=" + this.representation + ")";
        }

        @Override
        public RepresentationType getType() {
            return RepresentationType.OBJECT_DICTIONARY;
        }

        @Override
        public Object freeze(ColumnLoader.ValueSet valueSet, int[] sources) {
            int n = valueSet.map.keySet().size();
            int extra = valueSet.containsNull ? 1 : 0;
            Object[] codeValues = valueSet.map.keySet().toArray(new Comparable[n + extra]);
            Arrays.sort(codeValues, 0, n);
            ColumnLoader.ValueSet codeValueSet = new ColumnLoader.ValueSet(Integer.TYPE);
            List list = ArrayTable.permuteList(valueSet.values, sources);
            for (Comparable value : list) {
                int code;
                if (value == null) {
                    code = n;
                } else {
                    code = Arrays.binarySearch(codeValues, value);
                    assert (code >= 0) : code + ", " + value;
                }
                codeValueSet.add(Integer.valueOf(code));
            }
            Object codes = this.representation.freeze(codeValueSet, null);
            return Pair.of(codes, codeValues);
        }

        @Override
        public Object permute(Object dataSet, int[] sources) {
            Pair pair = ArrayTable.toPair(dataSet);
            Object codes = pair.left;
            Comparable[] codeValues = (Comparable[])pair.right;
            return Pair.of(this.representation.permute(codes, sources), codeValues);
        }

        @Override
        public Object getObject(Object dataSet, int ordinal) {
            Pair pair = ArrayTable.toPair(dataSet);
            int code = this.representation.getInt(pair.left, ordinal);
            return ((Comparable[])pair.right)[code];
        }

        @Override
        public int getInt(Object dataSet, int ordinal) {
            return ((Number)this.getObject(dataSet, ordinal)).intValue();
        }

        @Override
        public int size(Object dataSet) {
            Pair pair = ArrayTable.toPair(dataSet);
            return this.representation.size(pair.left);
        }

        @Override
        public String toString(Object dataSet) {
            return Column.asList(this, dataSet).toString();
        }
    }

    public static class PrimitiveDictionary
    implements Representation {
        PrimitiveDictionary() {
        }

        public String toString() {
            return "PrimitiveDictionary()";
        }

        @Override
        public RepresentationType getType() {
            return RepresentationType.PRIMITIVE_DICTIONARY;
        }

        @Override
        public Object freeze(ColumnLoader.ValueSet valueSet, int[] sources) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object permute(Object dataSet, int[] sources) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getObject(Object dataSet, int ordinal) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getInt(Object dataSet, int ordinal) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size(Object dataSet) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString(Object dataSet) {
            throw new UnsupportedOperationException();
        }
    }

    public static class PrimitiveArray
    implements Representation {
        final int ordinal;
        private final Primitive primitive;
        private final Primitive p;

        PrimitiveArray(int ordinal, Primitive primitive, Primitive p) {
            this.ordinal = ordinal;
            this.primitive = primitive;
            this.p = p;
        }

        public String toString() {
            return "PrimitiveArray(ordinal=" + this.ordinal + ", primitive=" + this.primitive + ", p=" + this.p + ")";
        }

        @Override
        public RepresentationType getType() {
            return RepresentationType.PRIMITIVE_ARRAY;
        }

        @Override
        public Object freeze(ColumnLoader.ValueSet valueSet, int[] sources) {
            return this.primitive.toArray2((Collection)ArrayTable.permuteList(valueSet.values, sources));
        }

        @Override
        public Object permute(Object dataSet, int[] sources) {
            return this.primitive.permute(dataSet, sources);
        }

        @Override
        public Object getObject(Object dataSet, int ordinal) {
            return this.p.arrayItem(dataSet, ordinal);
        }

        @Override
        public int getInt(Object dataSet, int ordinal) {
            return Array.getInt(dataSet, ordinal);
        }

        @Override
        public int size(Object dataSet) {
            return Array.getLength(dataSet);
        }

        @Override
        public String toString(Object dataSet) {
            return this.p.arrayToString(dataSet);
        }
    }

    public static class ObjectArray
    implements Representation {
        final int ordinal;

        ObjectArray(int ordinal) {
            this.ordinal = ordinal;
        }

        public String toString() {
            return "ObjectArray(ordinal=" + this.ordinal + ")";
        }

        @Override
        public RepresentationType getType() {
            return RepresentationType.OBJECT_ARRAY;
        }

        @Override
        public Object freeze(ColumnLoader.ValueSet valueSet, int[] sources) {
            List list = ArrayTable.permuteList(valueSet.values, sources);
            return list.toArray(new Comparable[list.size()]);
        }

        @Override
        public Object permute(Object dataSet, int[] sources) {
            Comparable[] list = (Comparable[])dataSet;
            int size = list.length;
            Comparable[] comparables = new Comparable[size];
            for (int i = 0; i < size; ++i) {
                comparables[i] = list[sources[i]];
            }
            return comparables;
        }

        @Override
        public Object getObject(Object dataSet, int ordinal) {
            return ((Comparable[])dataSet)[ordinal];
        }

        @Override
        public int getInt(Object dataSet, int ordinal) {
            return ((Number)this.getObject(dataSet, ordinal)).intValue();
        }

        @Override
        public int size(Object dataSet) {
            return ((Comparable[])dataSet).length;
        }

        @Override
        public String toString(Object dataSet) {
            return Arrays.toString((Comparable[])dataSet);
        }
    }

    public static interface Representation {
        public RepresentationType getType();

        public Object freeze(ColumnLoader.ValueSet var1, int[] var2);

        public Object getObject(Object var1, int var2);

        public int getInt(Object var1, int var2);

        public Object permute(Object var1, int[] var2);

        public int size(Object var1);

        public String toString(Object var1);
    }

    public static class Column {
        final Representation representation;
        final Object dataSet;
        final int cardinality;

        Column(Representation representation, Object data, int cardinality) {
            this.representation = representation;
            this.dataSet = data;
            this.cardinality = cardinality;
        }

        public Column permute(int[] sources) {
            return new Column(this.representation, this.representation.permute(this.dataSet, sources), this.cardinality);
        }

        public String toString() {
            return "Column(representation=" + this.representation + ", value=" + this.representation.toString(this.dataSet) + ")";
        }

        public static List asList(final Representation representation, final Object dataSet) {
            final int size = representation.size(dataSet);
            return new AbstractList(){

                @Override
                public Object get(int index) {
                    return representation.getObject(dataSet, index);
                }

                @Override
                public int size() {
                    return size;
                }
            };
        }
    }

    static enum RepresentationType {
        CONSTANT,
        OBJECT_ARRAY,
        PRIMITIVE_ARRAY,
        BIT_SLICED_PRIMITIVE_ARRAY,
        PRIMITIVE_DICTIONARY,
        OBJECT_DICTIONARY,
        STRING_DICTIONARY,
        BYTE_STRING_DICTIONARY;

    }
}

