/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.entity.resource;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.manager.common.entity.resource.CPUResource;
import org.apache.linkis.manager.common.entity.resource.DriverAndKubernetesResource;
import org.apache.linkis.manager.common.entity.resource.DriverAndYarnResource;
import org.apache.linkis.manager.common.entity.resource.LoadResource;
import org.apache.linkis.manager.common.entity.resource.MemoryResource;
import org.apache.linkis.manager.common.entity.resource.Resource;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LoadInstanceResource
extends Resource {
    private final long memory;
    private final int cores;
    private final int instances;

    private LoadInstanceResource(Resource r) {
        if (r instanceof LoadInstanceResource) {
            LoadInstanceResource t = (LoadInstanceResource)r;
            this.memory = t.memory;
            this.cores = t.cores;
            this.instances = t.instances;
        } else if (r instanceof LoadResource) {
            LoadResource l = (LoadResource)r;
            this.memory = l.getMemory();
            this.cores = l.getCores();
            this.instances = 0;
        } else if (r instanceof MemoryResource) {
            MemoryResource m = (MemoryResource)r;
            this.memory = m.getMemory();
            this.cores = 0;
            this.instances = 0;
        } else if (r instanceof CPUResource) {
            CPUResource c = (CPUResource)r;
            this.memory = 0L;
            this.cores = c.getCores();
            this.instances = 0;
        } else if (r instanceof DriverAndYarnResource) {
            DriverAndYarnResource d = (DriverAndYarnResource)r;
            this.memory = d.getLoadInstanceResource().getMemory();
            this.cores = d.getLoadInstanceResource().getCores();
            this.instances = d.getLoadInstanceResource().getInstances();
        } else if (r instanceof DriverAndKubernetesResource) {
            DriverAndKubernetesResource d = (DriverAndKubernetesResource)r;
            this.memory = d.getLoadInstanceResource().getMemory();
            this.cores = d.getLoadInstanceResource().getCores();
            this.instances = d.getLoadInstanceResource().getInstances();
        } else {
            this.memory = Long.MAX_VALUE;
            this.cores = Integer.MAX_VALUE;
            this.instances = Integer.MAX_VALUE;
        }
    }

    public LoadInstanceResource() {
        this(Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public LoadInstanceResource(long memory, int cores, int instances) {
        this.memory = memory;
        this.cores = cores;
        this.instances = instances;
    }

    @Override
    public LoadInstanceResource add(Resource r) {
        LoadInstanceResource temp = new LoadInstanceResource(r);
        return new LoadInstanceResource(this.memory + temp.memory, this.cores + temp.cores, this.instances + temp.instances);
    }

    @Override
    public LoadInstanceResource minus(Resource r) {
        LoadInstanceResource temp = new LoadInstanceResource(r);
        return new LoadInstanceResource(this.memory - temp.memory, this.cores - temp.cores, this.instances - temp.instances);
    }

    @Override
    public LoadInstanceResource multiplied(Resource r) {
        LoadInstanceResource temp = new LoadInstanceResource(r);
        return new LoadInstanceResource(this.memory * temp.memory, this.cores * temp.cores, this.instances * temp.instances);
    }

    @Override
    public LoadInstanceResource multiplied(float rate) {
        return new LoadInstanceResource((long)((float)this.memory * rate), Math.round((float)this.cores * rate), (int)((float)this.instances * rate));
    }

    @Override
    public LoadInstanceResource divide(Resource r) {
        LoadInstanceResource temp = new LoadInstanceResource(r);
        return new LoadInstanceResource(this.memory / temp.memory, this.cores / temp.cores, this.instances / temp.instances);
    }

    @Override
    public LoadInstanceResource divide(int rate) {
        return new LoadInstanceResource(this.memory / (long)rate, this.cores / rate, this.instances / rate);
    }

    @Override
    public boolean moreThan(Resource r) {
        LoadInstanceResource temp = new LoadInstanceResource(r);
        return this.memory > temp.memory && this.cores > temp.cores && this.instances > temp.instances;
    }

    @Override
    public boolean caseMore(Resource r) {
        LoadInstanceResource temp = new LoadInstanceResource(r);
        return this.memory > temp.memory || this.cores > temp.cores || this.instances > temp.instances;
    }

    @Override
    public boolean equalsTo(Resource r) {
        LoadInstanceResource temp = new LoadInstanceResource(r);
        return this.memory == temp.memory && this.cores == temp.cores && this.instances == temp.instances;
    }

    @Override
    public boolean notLess(Resource r) {
        LoadInstanceResource temp = new LoadInstanceResource(r);
        return this.memory >= temp.memory && this.cores >= temp.cores && this.instances >= temp.instances;
    }

    @Override
    public boolean less(Resource r) {
        return !this.notLess(r);
    }

    @Override
    public int compare(Resource r) {
        LoadInstanceResource temp = new LoadInstanceResource(r);
        if (this.getMemory() > temp.getMemory()) {
            return 1;
        }
        if (this.getMemory() < temp.getMemory()) {
            return -1;
        }
        if (this.getCores() > temp.getCores()) {
            return 1;
        }
        if (this.getCores() < temp.getCores()) {
            return -1;
        }
        return Integer.compare(this.getInstances(), temp.getInstances());
    }

    @Override
    public String toJson() {
        return String.format("{\"instance\":%d,\"memory\":\"%s\",\"cpu\":%d}", this.instances, ByteTimeUtils.bytesToString((long)this.memory), this.cores);
    }

    public String toString() {
        return String.format("Number of instances(\u5b9e\u4f8b\u6570)\uff1a%d\uff0c(RAM)\u5185\u5b58\uff1a%s ,cpu: %s", this.getInstances(), ByteTimeUtils.bytesToString((long)this.getMemory()), this.getCores());
    }

    public long getMemory() {
        return this.memory;
    }

    public int getCores() {
        return this.cores;
    }

    public int getInstances() {
        return this.instances;
    }
}

